/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.expr.OperationTerm;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;

public class UnaryOperation
extends QueryEvaluator {
    private final QueryEvaluator right;

    public UnaryOperation(OperationTerm term, QueryEvaluator right) {
        super(term);
        this.right = right;
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        switch (this.term.getToken()) {
            case add: {
                break;
            }
            case sub: {
                sql.append('-');
                break;
            }
            case not: {
                sql.append("NOT ");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.right.generate(sql, query);
    }

    @Override
    public QueryValueEvaluator getValue() {
        return null;
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
        if (this.isIgnored()) {
            return;
        }
        this.right.getDatasourceUsage(usage);
    }

    @Override
    public boolean isAggregative() {
        return !this.isIgnored() && this.right.isAggregative();
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.right.isIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.right.isStringType();
    }

    @Override
    public boolean hasNull() {
        return this.right != null && this.right.hasNull();
    }

    @Override
    public boolean isMultipleValue() {
        return this.right != null && this.right.isMultipleValue();
    }

    @Override
    public QuerySubjectEvaluator getSubject() {
        return null;
    }
}

