/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.fn;

import inform.agent.expr.Term;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryFunctionEvaluator;

public class SQLCaseEvaluator
extends QueryFunctionEvaluator {
    public SQLCaseEvaluator(Term term) {
        super(term);
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        int argCount = this.argCount();
        if (argCount == 0) {
            return;
        }
        if (this.arguments.size() == 1) {
            ((QueryEvaluator)this.arguments.get(0)).generate(sql, query);
            return;
        }
        boolean hasLast = false;
        int count = this.arguments.size();
        if ((count & 1) != 0) {
            hasLast = true;
            --count;
        }
        if (argCount == 1 && hasLast) {
            ((QueryEvaluator)this.arguments.get(count)).generate(sql, query);
            return;
        }
        sql.append("CASE ");
        for (int i = 0; i < count; i += 2) {
            QueryEvaluator condition = (QueryEvaluator)this.arguments.get(i);
            QueryEvaluator arg = (QueryEvaluator)this.arguments.get(i + 1);
            if (condition.isIgnored() || arg.isIgnored()) continue;
            sql.append(" WHEN ");
            condition.generate(sql, query);
            sql.append(" THEN ");
            arg.generate(sql, query);
        }
        if (hasLast && !((QueryEvaluator)this.arguments.get(count)).isIgnored()) {
            sql.append(" ELSE ");
            ((QueryEvaluator)this.arguments.get(count)).generate(sql, query);
        }
        sql.append(" END");
    }

    private int argCount() {
        if (this.term.isIgnored()) {
            return 0;
        }
        if (this.arguments.isEmpty()) {
            return 0;
        }
        if (this.arguments.size() == 1) {
            return ((QueryEvaluator)this.arguments.get(0)).isIgnored() ? 0 : 1;
        }
        boolean hasLast = false;
        int count = this.arguments.size();
        if ((count & 1) != 0) {
            hasLast = true;
            --count;
        }
        int result = 0;
        for (int i = 0; i < count; i += 2) {
            QueryEvaluator condition = (QueryEvaluator)this.arguments.get(i);
            QueryEvaluator arg = (QueryEvaluator)this.arguments.get(i + 1);
            if (condition.isIgnored() || arg.isIgnored()) continue;
            ++result;
        }
        if (hasLast && !((QueryEvaluator)this.arguments.get(count)).isIgnored()) {
            ++result;
        }
        return result;
    }

    @Override
    public boolean isIgnored() {
        return this.argCount() == 0;
    }
}

