/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.stat;

import inform.adt.DateTime;
import inform.adt.collections.DoubleHash;
import inform.agent.scripts.stat.DataNodeProfile;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import inform.agent.scripts.stat.ModuleProfile;
import java.util.ArrayList;
import java.util.Collections;

public class Profile {
    private final double ownerId;
    private final DoubleHash<ModuleProfile> modules = new DoubleHash();
    private final DoubleHash<DataNodeProfile> nodes = new DoubleHash();
    private final double startLogTime;

    public Profile(double ownerId) {
        this.ownerId = ownerId;
        this.startLogTime = DateTime.currentDateTime();
    }

    public DatasourceProfile addDatasource(int uid, double nodeId, double filterId, double moduleId) {
        ModuleProfile m;
        DataNodeProfile n = this.nodes.get(nodeId);
        if (n == null) {
            n = new DataNodeProfile(nodeId);
            this.nodes.add(n);
        }
        if ((m = this.modules.get(moduleId)) == null) {
            m = new ModuleProfile(moduleId);
            this.modules.add(m);
        }
        return m.addDatasource(uid, n, filterId);
    }

    public DirectoryProfile addDirectory(double nodeId, double moduleId) {
        ModuleProfile m;
        DataNodeProfile n = this.nodes.get(nodeId);
        if (n == null) {
            n = new DataNodeProfile(nodeId);
            this.nodes.add(n);
        }
        if ((m = this.modules.get(moduleId)) == null) {
            m = new ModuleProfile(moduleId);
            this.modules.add(m);
        }
        return m.addDirectory(n);
    }

    public String getProfile() {
        StringBuilder profile = new StringBuilder();
        profile.append("*********** Server Datamodel Profile started ").append(DateTime.toString(this.startLogTime)).append(" ***********\n");
        profile.append("  Node ").append((long)this.ownerId).append("\n");
        profile.append("***********\n");
        for (ModuleProfile m : this.modules) {
            m.getProfile(profile);
            profile.append('\n');
        }
        ArrayList<DataNodeProfile> nodeProfile = new ArrayList<DataNodeProfile>(this.nodes.size());
        for (DataNodeProfile n : this.nodes) {
            nodeProfile.add(n);
        }
        Collections.sort(nodeProfile);
        profile.append("  ***********\n");
        for (DataNodeProfile n : nodeProfile) {
            n.getProfile(profile);
            profile.append('\n');
        }
        return profile.toString();
    }
}

