/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textutils;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ODFParserHandler
extends DefaultHandler {
    private static final char EOLN = '\n';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    private String currentElement;
    private int cntTables = 0;
    private final Stack<String> stack = new Stack();
    private final StringBuilder sb;
    private final boolean withTableName;

    public ODFParserHandler(StringBuilder sb, boolean withTableName) {
        this.sb = sb;
        this.withTableName = withTableName;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.currentElement = qName;
        this.stack.add(this.currentElement);
        if ("table:table".equals(qName)) {
            String v;
            ++this.cntTables;
            if (this.withTableName && (v = atts.getValue("table:name")) != null) {
                this.sb.append(v).append('\n');
            }
        } else if ("text:tab".equals(qName)) {
            this.sb.append('\t');
        } else if ("text:s".equals(qName)) {
            this.sb.append(' ');
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement.startsWith("text:")) {
            String s = new String(ch, start, length);
            this.sb.append(s);
            if (this.cntTables > 0) {
                this.sb.append(' ');
            } else {
                this.sb.append('\n');
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.currentElement = this.stack.pop();
        if ("table:table-cell".equals(qName)) {
            this.sb.append('\t');
        } else if ("table:table-row".equals(qName)) {
            this.sb.append('\n');
        } else if ("table:table".equals(qName)) {
            --this.cntTables;
        }
    }
}

