/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textutils;

import inform.agent.scripts.textutils.AngleCollector;
import inform.agent.scripts.textutils.FilteredTextStripper;
import inform.agent.scripts.textutils.NullWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.util.Matrix;

public class PDFTextExtractor {
    private final InputStream dataStream;

    public PDFTextExtractor(InputStream dataStream) {
        this.dataStream = dataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtractText() throws IOException {
        String string;
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        StringWriter output = new StringWriter();
        PDDocument document = null;
        try {
            Map embeddedFileNames;
            PDEmbeddedFilesNameTreeNode embeddedFiles;
            document = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(this.dataStream));
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canExtractContent()) {
                throw new IOException("You do not have permission to extract text");
            }
            FilteredTextStripper stripper = new FilteredTextStripper();
            stripper.setSortByPosition(true);
            stripper.setShouldSeparateByBeads(true);
            this.extractPages(startPage, Math.min(endPage, document.getNumberOfPages()), stripper, document, output);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDDocumentNameDictionary names = catalog.getNames();
            if (names != null && (embeddedFiles = names.getEmbeddedFiles()) != null && (embeddedFileNames = embeddedFiles.getNames()) != null) {
                for (Map.Entry ent : embeddedFileNames.entrySet()) {
                    PDComplexFileSpecification spec = (PDComplexFileSpecification)ent.getValue();
                    PDEmbeddedFile file = spec.getEmbeddedFile();
                    if (file == null || !"application/pdf".equals(file.getSubtype())) continue;
                    COSInputStream fis = file.createInputStream();
                    PDDocument subDoc = null;
                    try {
                        subDoc = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer((InputStream)fis));
                        this.extractPages(1, subDoc.getNumberOfPages(), stripper, subDoc, output);
                    }
                    finally {
                        fis.close();
                        IOUtils.closeQuietly((Closeable)subDoc);
                    }
                }
            }
            string = ((Object)output).toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)output);
            IOUtils.closeQuietly(document);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)output);
        IOUtils.closeQuietly((Closeable)document);
        return string;
    }

    private void extractPages(int startPage, int endPage, PDFTextStripper stripper, PDDocument document, Writer output) throws IOException {
        for (int p = startPage; p <= endPage; ++p) {
            stripper.setStartPage(p);
            stripper.setEndPage(p);
            try {
                PDPage page = document.getPage(p - 1);
                int rotation = page.getRotation();
                page.setRotation(0);
                AngleCollector angleCollector = new AngleCollector();
                angleCollector.setStartPage(p);
                angleCollector.setEndPage(p);
                angleCollector.writeText(document, new NullWriter());
                for (int angle : angleCollector.getAngles()) {
                    COSBase cb;
                    PDPageContentStream cs = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, false);
                    cs.transform(Matrix.getRotateInstance((double)(-Math.toRadians(angle)), (float)0.0f, (float)0.0f));
                    cs.close();
                    stripper.writeText(document, output);
                    COSDictionary cd = page.getCOSObject();
                    if (cd == null || !((cb = cd.getItem(COSName.CONTENTS)) instanceof COSArray)) continue;
                    COSArray ca = (COSArray)cb;
                    ca.remove(0);
                }
                page.setRotation(rotation);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

