/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textutils;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.textutils.ExtractionDataInfo;
import inform.agent.scripts.textutils.ODFParserHandler;
import inform.agent.scripts.textutils.PDFTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.impl.AsmoLogger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextExtractor {
    private static final String FILEMARKER_MSWORD = "word/document.xml";
    private static final String FILEMARKER_MSEXCEL = "xl/workbook.xml";
    private static final String FILEMARKER_MSPOINT = "ppt/presentation.xml";
    private static final String FILECONTENTMARKER_ODF = "mimetype";
    private static final String FILECONTENT_ODF = "content.xml";
    private static final String FILESTYLES_ODF = "styles.xml";
    private static final byte[] CONTENTMARKER_MSWORD = "document.xml".getBytes();
    private static final byte[] CONTENTMARKER_MSEXCEL = "workbook.xml".getBytes();
    private static final byte[] CONTENTMARKER_MSPOINT = "presentation.xml".getBytes();
    private static final byte[] CONTENTMARKER_ODT = "application/vnd.oasis.opendocument.text".getBytes();
    private static final byte[] CONTENTMARKER_ODS = "application/vnd.oasis.opendocument.spreadsheet".getBytes();
    private static final byte[] CONTENTMARKER_ODP = "application/vnd.oasis.opendocument.presentation".getBytes();
    private static final String MESSAGE_UNKNOWNFORMAT = "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
    private static final int HEADER_MAXSIZE = 1024;
    private static final int MAX_TSVECTOR_TEXT_LENGTH = 800000;
    private final DOCUMENT_FORMAT format;
    private final InputStream dataStream;
    private Object msDocument2003;
    private ExtractionDataInfo dataInfo;
    private static int sizeof_EndOfCentralDir = 22;
    private static int sizeof_Zip64EndOfCentralDirLocator = 20;
    private static int sizeof_Zip64EndOfCentralDir = 54;
    private static int END_OF_CENTRAL_DIR_SIGNATURE = 101010256;
    private static int ZIP64_END_OF_CENTRAL_DIR_SIGNATURE = 101075792;
    private static int ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE = 117853008;
    private static int OVERFULL32 = -1;

    public static int maxTextLength(FieldDescriptor fd) {
        if (fd.getType() == DataType.BLOB && fd.getBlobRawType() == FieldDescriptor.BlobRawType.BINARY && fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
            return 800000;
        }
        return fd.getSize();
    }

    public TextExtractor(InputStream aStream) throws IOException {
        this(aStream, null);
    }

    public TextExtractor(InputStream aStream, ExtractionDataInfo aDataInfo) throws IOException {
        this.dataInfo = aDataInfo;
        if (aStream == null) {
            this.format = null;
            this.dataStream = null;
        } else {
            PushbackInputStream stream = new PushbackInputStream(aStream, 1024);
            byte[] header = new byte[1024];
            int headerSize = stream.read(header, 0, 1024);
            HEADER_TYPE headerType = HEADER_TYPE.determineHeaderType(header, headerSize);
            stream.unread(header, 0, headerSize);
            if (headerType == null) {
                this.format = DOCUMENT_FORMAT.DOCUMENT_BINARY;
                this.dataStream = stream;
            } else {
                switch (headerType) {
                    case HEADER_PDF: {
                        this.format = DOCUMENT_FORMAT.DOCUMENT_PDF;
                        this.dataStream = stream;
                        break;
                    }
                    case HEADER_ZIP: {
                        byte[] data = this.getData(stream);
                        this.format = this.determineXMLDocumentFormat(data);
                        this.dataStream = new ByteArrayInputStream(data);
                        break;
                    }
                    case HEADER_MSOFFICE2003: {
                        byte[] data = this.getData(stream);
                        this.format = this.determineMSDocument2003Format(data);
                        this.dataStream = stream;
                        break;
                    }
                    default: {
                        this.format = DOCUMENT_FORMAT.DOCUMENT_BINARY;
                        this.dataStream = stream;
                    }
                }
            }
        }
    }

    public TextExtractor(byte[] aData) throws IOException {
        this(aData, null);
    }

    public TextExtractor(byte[] aData, ExtractionDataInfo aDataInfo) throws IOException {
        this.dataInfo = aDataInfo;
        if (aData == null || aData.length == 0) {
            this.format = null;
            this.dataStream = null;
        } else {
            HEADER_TYPE headerType = HEADER_TYPE.determineHeaderType(aData, aData.length);
            this.dataStream = new ByteArrayInputStream(aData);
            if (headerType == null) {
                this.format = DOCUMENT_FORMAT.DOCUMENT_BINARY;
            } else {
                switch (headerType) {
                    case HEADER_PDF: {
                        this.format = DOCUMENT_FORMAT.DOCUMENT_PDF;
                        break;
                    }
                    case HEADER_ZIP: {
                        this.format = this.determineXMLDocumentFormat(aData);
                        break;
                    }
                    case HEADER_MSOFFICE2003: {
                        this.format = this.determineMSDocument2003Format(aData);
                        break;
                    }
                    default: {
                        this.format = DOCUMENT_FORMAT.DOCUMENT_BINARY;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOCUMENT_FORMAT determineXMLDocumentFormat(byte[] aData) throws IOException {
        DOCUMENT_FORMAT result = this.determineXMLDocumentFormat_light(aData);
        if (result != DOCUMENT_FORMAT.DOCUMENT_BINARY) {
            return result;
        }
        try (ZipInputStream zis = new ZipInputStream((InputStream)new ByteArrayInputStream(aData), Charset.forName("Cp866"));){
            block20: {
                ZipEntry zipEntry;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    DOCUMENT_FORMAT dOCUMENT_FORMAT;
                    String fileName = zipEntry.getName();
                    if (FILEMARKER_MSWORD.equals(fileName)) {
                        dOCUMENT_FORMAT = DOCUMENT_FORMAT.DOCUMENT_DOCX;
                        return dOCUMENT_FORMAT;
                    }
                    if (FILEMARKER_MSEXCEL.equals(fileName)) {
                        dOCUMENT_FORMAT = DOCUMENT_FORMAT.DOCUMENT_XLSX;
                        return dOCUMENT_FORMAT;
                    }
                    if (FILEMARKER_MSPOINT.equals(fileName)) {
                        dOCUMENT_FORMAT = DOCUMENT_FORMAT.DOCUMENT_PPTX;
                        return dOCUMENT_FORMAT;
                    }
                    if (!FILECONTENTMARKER_ODF.equals(fileName)) continue;
                    byte[] memotype = new byte[1024];
                    int cnt = zis.read(memotype, 0, 1024);
                    if (HEADER_TYPE.containsHeader(CONTENTMARKER_ODT, memotype, cnt)) {
                        DOCUMENT_FORMAT dOCUMENT_FORMAT2 = DOCUMENT_FORMAT.DOCUMENT_ODT;
                        return dOCUMENT_FORMAT2;
                    }
                    if (HEADER_TYPE.containsHeader(CONTENTMARKER_ODS, memotype, cnt)) {
                        DOCUMENT_FORMAT dOCUMENT_FORMAT3 = DOCUMENT_FORMAT.DOCUMENT_ODS;
                        return dOCUMENT_FORMAT3;
                    }
                    if (!HEADER_TYPE.containsHeader(CONTENTMARKER_ODP, memotype, cnt)) {
                        continue;
                    }
                    break block20;
                }
                return DOCUMENT_FORMAT.DOCUMENT_BINARY;
            }
            DOCUMENT_FORMAT dOCUMENT_FORMAT = DOCUMENT_FORMAT.DOCUMENT_ODP;
            return dOCUMENT_FORMAT;
        }
    }

    private DOCUMENT_FORMAT determineMSDocument2003Format(byte[] aData) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(aData));
            this.msDocument2003 = new HWPFDocument(fs);
            return DOCUMENT_FORMAT.DOCUMENT_DOC;
        }
        catch (Exception ex1) {
            Core.logger.error(null, ex1);
            try {
                this.msDocument2003 = new HSSFWorkbook((InputStream)new ByteArrayInputStream(aData));
                return DOCUMENT_FORMAT.DOCUMENT_XLS;
            }
            catch (Exception ex2) {
                Core.logger.error(null, ex2);
                try {
                    HSLFSlideShow ppt = new HSLFSlideShow((InputStream)new ByteArrayInputStream(aData));
                    this.msDocument2003 = new SlideShowExtractor((SlideShow)ppt);
                    return DOCUMENT_FORMAT.DOCUMENT_PPT;
                }
                catch (Exception ex3) {
                    Core.logger.error(null, ex3);
                    return DOCUMENT_FORMAT.DOCUMENT_BINARY;
                }
            }
        }
    }

    public DOCUMENT_FORMAT getFormat() {
        return this.format;
    }

    public String extractText() throws IOException, ParserConfigurationException, SAXException {
        if (this.format == null) {
            return null;
        }
        switch (this.format) {
            case DOCUMENT_PDF: {
                return this.extractTextFromPDF();
            }
            case DOCUMENT_DOCX: {
                return this.extractTextFromDOCX();
            }
            case DOCUMENT_XLSX: {
                return this.extractTextFromXLSX();
            }
            case DOCUMENT_PPTX: {
                return this.extractTextFromPPTX();
            }
            case DOCUMENT_DOC: {
                return this.extractTextFromDOC();
            }
            case DOCUMENT_XLS: {
                return this.extractTextFromXLS();
            }
            case DOCUMENT_PPT: {
                return this.extractTextFromPPT();
            }
            case DOCUMENT_ODT: 
            case DOCUMENT_ODS: 
            case DOCUMENT_ODP: {
                return this.extractTextFromODF();
            }
        }
        throw new IOException(MESSAGE_UNKNOWNFORMAT);
    }

    private String extractTextFromPDF() throws IOException {
        PDFTextExtractor pdfTextExtractor = new PDFTextExtractor(this.dataStream);
        return new String(pdfTextExtractor.getExtractText().getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI).replace('\u0000', ' ');
    }

    private String extractTextFromDOCX() throws IOException {
        try {
            XWPFDocument document = new XWPFDocument(this.dataStream);
            String text = new XWPFWordExtractor(document).getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 DOCX-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    private String extractTextFromXLSX() throws IOException {
        try {
            XSSFWorkbook document = new XSSFWorkbook(this.dataStream);
            String text = new XSSFExcelExtractor(document).getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 XLSX-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    private String extractTextFromPPTX() throws IOException {
        try {
            XMLSlideShow document = new XMLSlideShow(this.dataStream);
            String text = new SlideShowExtractor((SlideShow)document).getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 PPTX-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    private String extractTextFromDOC() {
        assert (this.msDocument2003 instanceof HWPFDocument);
        try {
            String text = new WordExtractor((HWPFDocument)this.msDocument2003).getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 DOC-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    private String extractTextFromXLS() {
        assert (this.msDocument2003 instanceof HSSFWorkbook);
        try {
            ExcelExtractor extractor = new ExcelExtractor((HSSFWorkbook)this.msDocument2003);
            extractor.setIncludeSheetNames(true);
            String text = extractor.getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 XLS-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    private String extractTextFromPPT() {
        assert (this.msDocument2003 instanceof SlideShowExtractor);
        try {
            String text = ((SlideShowExtractor)this.msDocument2003).getText();
            return new String(text.getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
        }
        catch (Exception e) {
            Object message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 \u0438\u0437 PPT-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            if (this.dataInfo != null) {
                message = (String)message + this.dataInfo;
            }
            Core.logger.log(AsmoLogger.Level.WARN, (String)message, e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractTextFromODF() throws IOException, ParserConfigurationException, SAXException {
        try (ZipInputStream zis = new ZipInputStream(this.dataStream);){
            ZipEntry zipEntry;
            byte[] content = null;
            byte[] styles = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String fileName = zipEntry.getName();
                if (FILESTYLES_ODF.equals(fileName)) {
                    styles = this.getData(zis);
                }
                if (!FILECONTENT_ODF.equals(fileName)) continue;
                content = this.getData(zis);
            }
            StringBuilder sb = new StringBuilder();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ODFParserHandler handler = new ODFParserHandler(sb, this.format == DOCUMENT_FORMAT.DOCUMENT_ODS);
            parser.parse((InputStream)new ByteArrayInputStream(content), (DefaultHandler)handler);
            parser.parse((InputStream)new ByteArrayInputStream(styles), (DefaultHandler)handler);
            String string = new String(sb.toString().getBytes(TaggedWriter.ANSI), TaggedWriter.ANSI);
            return string;
        }
    }

    private byte[] getData(InputStream aStream) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int bufferSize = 4092;
        byte[] buffer = new byte[bufferSize];
        while ((len = aStream.read(buffer, 0, bufferSize)) > 0) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }

    private DOCUMENT_FORMAT determineXMLDocumentFormat_light(byte[] aData) {
        int centralDirOffs = TextExtractor.getCentralDirOffsetZip(aData);
        if (centralDirOffs > 0) {
            int size = aData.length - centralDirOffs;
            if (TextExtractor.findFromEnd(CONTENTMARKER_MSWORD, aData, CONTENTMARKER_MSWORD.length, aData.length, size)) {
                return DOCUMENT_FORMAT.DOCUMENT_DOCX;
            }
            if (TextExtractor.findFromEnd(CONTENTMARKER_MSEXCEL, aData, CONTENTMARKER_MSEXCEL.length, aData.length, size)) {
                return DOCUMENT_FORMAT.DOCUMENT_XLSX;
            }
            if (TextExtractor.findFromEnd(CONTENTMARKER_MSPOINT, aData, CONTENTMARKER_MSPOINT.length, aData.length, size)) {
                return DOCUMENT_FORMAT.DOCUMENT_PPTX;
            }
        }
        return DOCUMENT_FORMAT.DOCUMENT_BINARY;
    }

    private static int getCentralDirOffsetZip(byte[] data) {
        byte[] requiredSignature = new byte[]{80, 75, 5, 6};
        if (data == null || data.length <= requiredSignature.length) {
            return 0;
        }
        int pos = -1;
        for (int i = 0; i <= data.length - requiredSignature.length; ++i) {
            boolean match = true;
            for (int j = 0; j < requiredSignature.length; ++j) {
                if (data[i + j] == requiredSignature[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            pos = i;
            break;
        }
        if (pos < 0) {
            return 0;
        }
        byte[] endOfCentralDir = Arrays.copyOfRange(data, pos, data.length);
        int centralDirOffset = (int)TextExtractor.bytesToLong(endOfCentralDir, 16, 4);
        int centralDirSize = (int)TextExtractor.bytesToLong(endOfCentralDir, 12, 4);
        int entriesCount = (int)TextExtractor.bytesToLong(endOfCentralDir, 8, 2);
        if (entriesCount == 65535 || centralDirSize == OVERFULL32 || centralDirOffset == OVERFULL32) {
            pos = data.length - sizeof_EndOfCentralDir - sizeof_Zip64EndOfCentralDirLocator;
            byte[] endDir64Locator = Arrays.copyOfRange(data, pos, sizeof_Zip64EndOfCentralDirLocator);
            int signature = (int)TextExtractor.bytesToLong(endDir64Locator, 0, 4);
            if (signature != ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE) {
                return 0;
            }
            pos = (int)TextExtractor.bytesToLong(endDir64Locator, 8, 8);
            byte[] endDir64 = Arrays.copyOfRange(data, pos, sizeof_Zip64EndOfCentralDir);
            signature = (int)TextExtractor.bytesToLong(endDir64, 0, 4);
            if (signature != ZIP64_END_OF_CENTRAL_DIR_SIGNATURE) {
                return 0;
            }
            centralDirOffset = (int)TextExtractor.bytesToLong(endDir64, 46, 8);
        }
        return centralDirOffset;
    }

    private static long bytesToLong(byte[] data, int offset, int len) {
        if (data == null) {
            return 0L;
        }
        long v = 0L;
        for (int i = offset + len - 1; i >= 0 && i < data.length && len > 0; --i, --len) {
            byte b = data[i];
            v = (v << 8) + (long)(b & 0xFF);
        }
        return v;
    }

    private static boolean memcmp(byte[] aSrc, byte[] aData, int aDataLen, int aDataPos) {
        assert (aSrc != null);
        assert (aSrc.length > 0);
        int len = aSrc.length;
        if (aData == null || aDataLen == 0 || aDataLen + aDataPos < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (aSrc[i] == aData[i + aDataPos]) continue;
            return false;
        }
        return true;
    }

    private static boolean findFromEnd(byte[] src, byte[] dst, int lenSrc, int lenDst, int limit) {
        assert (lenDst >= lenSrc);
        if (limit > lenDst) {
            limit = lenDst;
        }
        int m = lenDst - limit;
        for (int i = lenDst - lenSrc; i >= m; --i) {
            if (TextExtractor.memcmp(src, dst, lenSrc, i)) {
                return true;
            }
            if (i == 0) break;
        }
        return false;
    }

    private static final class HEADER_TYPE
    extends Enum<HEADER_TYPE> {
        public static final /* enum */ HEADER_TYPE HEADER_PDF = new HEADER_TYPE("%PDF-".getBytes());
        public static final /* enum */ HEADER_TYPE HEADER_ZIP = new HEADER_TYPE("PK".getBytes());
        public static final /* enum */ HEADER_TYPE HEADER_MSOFFICE2003 = new HEADER_TYPE(new byte[]{-48, -49, 17, -32, -95, -79, 26, -31});
        private final byte[] headerData;
        private static final /* synthetic */ HEADER_TYPE[] $VALUES;

        public static HEADER_TYPE[] values() {
            return (HEADER_TYPE[])$VALUES.clone();
        }

        public static HEADER_TYPE valueOf(String name) {
            return Enum.valueOf(HEADER_TYPE.class, name);
        }

        private HEADER_TYPE(byte[] aHeaderData) {
            this.headerData = aHeaderData;
        }

        public static HEADER_TYPE determineHeaderType(byte[] aData, int aDataLen) {
            if (aData == null || aDataLen == 0) {
                return null;
            }
            for (HEADER_TYPE value : HEADER_TYPE.values()) {
                if (!HEADER_TYPE.containsHeader(value.headerData, aData, aDataLen)) continue;
                return value;
            }
            return null;
        }

        public static boolean containsHeader(byte[] aHeader, byte[] aData, int aDataLen) {
            assert (aHeader != null);
            assert (aHeader.length > 0);
            int len = aHeader.length;
            if (aData == null || aDataLen == 0 || aDataLen < len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (aHeader[i] == aData[i]) continue;
                return false;
            }
            return true;
        }

        static {
            $VALUES = new HEADER_TYPE[]{HEADER_PDF, HEADER_ZIP, HEADER_MSOFFICE2003};
        }
    }

    public static enum DOCUMENT_FORMAT {
        DOCUMENT_BINARY(0),
        DOCUMENT_PDF(1),
        DOCUMENT_DOCX(2),
        DOCUMENT_XLSX(3),
        DOCUMENT_PPTX(4),
        DOCUMENT_DOC(5),
        DOCUMENT_XLS(6),
        DOCUMENT_PPT(7),
        DOCUMENT_ODT(8),
        DOCUMENT_ODS(9),
        DOCUMENT_ODP(10);

        private final int typeId;

        private DOCUMENT_FORMAT(int pTypeId) {
            this.typeId = pTypeId;
        }

        public int getTypeId() {
            return this.typeId;
        }
    }
}

