/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.adt.Strings;
import inform.agent.scripts.libs.SystemLibrary;
import inform.common.SmartScriptableObject;
import java.io.Closeable;
import java.io.IOException;

public class ScriptMutex
extends SmartScriptableObject
implements Closeable {
    private final String key;
    private SystemLibrary systemLibrary;

    public ScriptMutex(String key, SystemLibrary systemLibrary) {
        assert (!Strings.isVoid(key));
        this.key = key;
        this.systemLibrary = systemLibrary;
        systemLibrary.task.registerCloseable(this);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @SmartScriptableObject.PropertyTag
    public String getName() {
        return this.key;
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        if (this.systemLibrary != null) {
            this.systemLibrary.closeMutex(this.key);
            this.systemLibrary = null;
        }
    }
}

