/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.scripts.zip.ZipReaderEntry;
import inform.common.SmartScriptableObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ZipReader
extends SmartScriptableObject {
    public static final Charset DEFAULT_CHARSET = TaggedWriter.UTF8;
    private ZipReaderEntry _entryExporter;
    private final ZipFile _zipFile;
    private int _entryIndex;
    private File _tmpFile = null;

    public ZipReader(String fileName, Charset charset) throws IOException {
        this._zipFile = new ZipFile(Core.mountfs.resolvePath(fileName), charset);
        this._entryExporter = null;
        this._entryIndex = 0;
    }

    public ZipReader(File file, Charset charset) throws IOException {
        this._tmpFile = file;
        this._zipFile = new ZipFile(this._tmpFile, charset);
        this._entryExporter = null;
        this._entryIndex = 0;
    }

    @Override
    public String getClassName() {
        return "ZipReader";
    }

    @SmartScriptableObject.PropertyTag
    public ZipReaderEntry getentry() {
        return this._entryExporter;
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this._zipFile.close();
        if (this._tmpFile != null && this._tmpFile.exists()) {
            this._tmpFile.delete();
        }
    }

    @SmartScriptableObject.FunctionTag
    public static Object nextEntry(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        ZipReader reader = (ZipReader)thisObj;
        ZipEntry entry = null;
        if (args.length > 0 && args[0] instanceof String) {
            entry = reader._zipFile.getEntry((String)args[0]);
        } else {
            Enumeration<? extends ZipEntry> entries = reader._zipFile.entries();
            int idx = -1;
            while (reader._entryIndex < reader._zipFile.size()) {
                if (entries.hasMoreElements() && ++idx <= reader._entryIndex) {
                    entry = entries.nextElement();
                }
                if (idx < reader._entryIndex) continue;
            }
            ++reader._entryIndex;
        }
        if (entry == null) {
            reader._entryExporter = null;
            return null;
        }
        reader._entryExporter = new ZipReaderEntry(entry, reader._zipFile);
        return reader._entryExporter;
    }

    @SmartScriptableObject.FunctionTag
    public void reset() {
        this._entryIndex = 0;
        this._entryExporter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public void extractTo(String destinationFolder) throws IOException, InformException {
        try {
            byte[] buf = new byte[1024];
            Enumeration<? extends ZipEntry> entries = this._zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File newFile = new File(Core.mountfs.resolvePath(destinationFolder), entry.getName());
                File dir = newFile.getParentFile();
                if (dir != null) {
                    dir.mkdirs();
                }
                if (entry.isDirectory()) continue;
                InputStream is = this._zipFile.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int n;
                    while ((n = is.read(buf, 0, 1024)) > -1) {
                        fos.write(buf, 0, n);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430!");
        }
    }
}

