/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.zip.ZipWriterEntry;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipWriter
extends SmartScriptableObject {
    private final ByteArrayOutputStream _memoryOutputStream;
    private final ZipOutputStream _zipOutputStream;
    private ZipWriterEntry _entry = null;
    private boolean _isWriterFixed = false;
    private boolean _compressed = true;
    private String _comment = "";

    public ZipWriter(ZipOutputStream zipOutputStream) {
        this._memoryOutputStream = null;
        this._zipOutputStream = zipOutputStream;
        this._zipOutputStream.setMethod(8);
        this._zipOutputStream.setLevel(8);
    }

    public ZipWriter() {
        this._memoryOutputStream = new ByteArrayOutputStream();
        this._zipOutputStream = new ZipOutputStream(this._memoryOutputStream);
        this._zipOutputStream.setMethod(8);
        this._zipOutputStream.setLevel(8);
    }

    @Override
    public String getClassName() {
        return "ZipWriter";
    }

    @SmartScriptableObject.PropertyTag
    public String getcomment() {
        return this._comment;
    }

    public void setcomment(String comment) throws InformException, UnsupportedEncodingException {
        if (this._isWriterFixed) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432 \u0432 \u0430\u0440\u0445\u0438\u0432!");
        }
        this._comment = comment;
        this._zipOutputStream.setComment(comment);
    }

    @SmartScriptableObject.PropertyTag
    public boolean getcompressed() {
        return this._compressed;
    }

    public void setcompressed(boolean compressed) throws InformException {
        if (this._isWriterFixed) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u043e\u0434\u0430 \u0441\u0436\u0430\u0442\u0438\u044f \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432 \u0432 \u0430\u0440\u0445\u0438\u0432!");
        }
        this._compressed = compressed;
        if (this._compressed) {
            this._zipOutputStream.setLevel(8);
        } else {
            this._zipOutputStream.setLevel(0);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException, ZipException {
        this.putEntry();
        this._zipOutputStream.close();
    }

    @SmartScriptableObject.FunctionTag
    public Object nextEntry(String entryName) throws NullPointerException, IllegalArgumentException, IOException {
        this._isWriterFixed = true;
        this.putEntry();
        this._entry = new ZipWriterEntry(new ZipEntry(entryName));
        return this._entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public void writeFromFile(String fileName) throws IOException, InformException {
        if (this._entry == null) {
            throw new InformException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0430\u0440\u0445\u0438\u0432\u0430!");
        }
        this.putEntry();
        try (FileInputStream fis = new FileInputStream(Core.mountfs.resolve(new File(fileName)).getPath());){
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            this._zipOutputStream.write(buffer);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void writeFromBinary(BinaryObject binary) throws IOException, InformException {
        if (this._entry == null) {
            throw new InformException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0430\u0440\u0445\u0438\u0432\u0430!");
        }
        if (binary == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        this.putEntry();
        this._zipOutputStream.write(binary.toByteArray());
    }

    @SmartScriptableObject.FunctionTag
    public void writeFromBlob(BlobField field) throws Exception {
        if (field == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f!");
        }
        this.writeFromBinary(field.getAsBinary());
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(DatasourceField field) throws Exception {
        if (this._memoryOutputStream == null) {
            throw new InformException("ZipWriter \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0432 \u043f\u0430\u043c\u044f\u0442\u0438");
        }
        if (field == null) {
            throw new InformException("saveToBlob \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u043e\u043b\u0435");
        }
        this.close();
        BinaryObject bin = new BinaryObject(this._memoryOutputStream.toByteArray());
        field.setAsBinary(bin);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject toBinary() throws Exception {
        if (this._memoryOutputStream == null) {
            throw new InformException("ZipWriter \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0432 \u043f\u0430\u043c\u044f\u0442\u0438");
        }
        this.close();
        return new BinaryObject(this._memoryOutputStream.toByteArray());
    }

    private void putEntry() throws IOException {
        if (this._entry != null && this._entry._canModified) {
            this._zipOutputStream.putNextEntry(this._entry.getEntry());
            this._entry._canModified = false;
        }
    }
}

