/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.spell;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;

public class SpellChecker {
    private final int spells_count;
    private final Set<String> system_words;
    private static final String SYSTEM_DICTIONARY_RESOURCE = "/resources/dictionary/system.words";

    private SpellChecker() {
        block13: {
            this.spells_count = SpellChecker.hunspell_initialize();
            this.system_words = new HashSet<String>();
            try (InputStream is = SpellChecker.class.getResourceAsStream(SYSTEM_DICTIONARY_RESOURCE);){
                if (is == null) break block13;
                Core.logger.info("\nSpellChecker: Load dictionary system words resource: /resources/dictionary/system.words");
                try (BufferedReader br = new BufferedReader(new InputStreamReader(is, TaggedWriter.UTF8));){
                    br.lines().forEach(s -> {
                        if (!s.isEmpty()) {
                            this.system_words.add(s.toLowerCase());
                        }
                    });
                }
            }
            catch (IOException ex) {
                Core.logger.error("\nSpellChecker: Error load resource", ex);
            }
        }
    }

    public static SpellChecker getInstance() {
        return SpellCheckerHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spell(String word) {
        if (this.spells_count <= 0) {
            return true;
        }
        if (this.system_words.contains(word.toLowerCase())) {
            return true;
        }
        SpellChecker spellChecker = this;
        synchronized (spellChecker) {
            return SpellChecker.hunspell_spell(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String suggest(String word) throws UnsupportedEncodingException {
        if (this.spells_count <= 0) {
            return null;
        }
        SpellChecker spellChecker = this;
        synchronized (spellChecker) {
            return SpellChecker.hunspell_suggest(word);
        }
    }

    private static native int hunspell_initialize();

    private static native void hunspell_uninitialize();

    private static native boolean hunspell_spell(String var0);

    private static native String hunspell_suggest(String var0);

    private static class SpellCheckerHolder {
        public static final SpellChecker INSTANCE = new SpellChecker();

        private SpellCheckerHolder() {
        }
    }
}

