/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.srv;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.mtd.request.ConversionService;
import inform.agent.net.AgentConnection;
import inform.agent.net.ClientProtocol;
import java.io.IOException;

public class ProxyConverterService {
    public static byte[] convertVsdToVsdx(ServerSideHost ssHost, byte[] vsd) throws IOException {
        return ProxyConverterService.convertVsdToVsdx(Ini.conversionServiceHost, Ini.conversionServicePort, Ini.conversionServiceAgent, ssHost, vsd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertVsdToVsdx(String server, int port, String agent, ServerSideHost ssHost, byte[] vsd) throws IOException {
        try (AgentConnection connection = new AgentConnection(ClientProtocol.ClientType.Service, ssHost, server, port, agent, "built-in-service-user-name", "built-in-service-user-name", 0.0);){
            AgentConnection.PlainRequest request = new AgentConnection.PlainRequest(567);
            connection.request(request);
            ByteArrayOutputStream requestParams = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(requestParams);
            out.putInt32(1, 1);
            int position = 0;
            while (position < vsd.length) {
                if ((position = ProxyConverterService.putChunk(vsd, position, out)) >= vsd.length) {
                    out.putEmpty(3);
                }
                out.flush();
                connection.sendChunk(requestParams.internalBuffer(), requestParams.size());
                requestParams.reset();
                out.reset(requestParams);
                ssHost.idle();
            }
            connection.sendEndOfChunks();
            ssHost.idle();
            connection.waitForResult();
            byte[] byArray = request.getResult();
            return byArray;
        }
    }

    public static byte[] convertVSDXtoVSD(ServerSideHost ssHost, byte[] vsd) throws IOException {
        return ProxyConverterService.convertVSDXtoVSD(Ini.conversionServiceHost, Ini.conversionServicePort, Ini.conversionServiceAgent, ssHost, vsd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertVSDXtoVSD(String server, int port, String agent, ServerSideHost ssHost, byte[] vsdx) throws IOException {
        try (AgentConnection connection = new AgentConnection(ClientProtocol.ClientType.Service, ssHost, server, port, agent, "built-in-service-user-name", "built-in-service-user-name", 0.0);){
            AgentConnection.PlainRequest request = new AgentConnection.PlainRequest(567);
            connection.request(request);
            ByteArrayOutputStream requestParams = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(requestParams);
            out.putInt32(1, 2);
            int position = 0;
            while (position < vsdx.length) {
                if ((position = ProxyConverterService.putChunk(vsdx, position, out)) >= vsdx.length) {
                    out.putEmpty(3);
                }
                out.flush();
                connection.sendChunk(requestParams.internalBuffer(), requestParams.size());
                requestParams.reset();
                out.reset(requestParams);
                ssHost.idle();
            }
            connection.sendEndOfChunks();
            ssHost.idle();
            connection.waitForResult();
            byte[] byArray = request.getResult();
            return byArray;
        }
    }

    private static int putChunk(byte[] data, int position, TaggedWriter out) throws IOException {
        assert (position < data.length);
        int nextPosition = position + ConversionService.CHUNK_SIZE;
        if (nextPosition > data.length) {
            nextPosition = data.length;
        }
        out.putRaw(2, data, position, nextPosition - position);
        return nextPosition;
    }
}

