/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.Core;
import inform.agent.PhaThread;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor {
    private static final ExecutorService executor = PhaThread.newFixedThreadPool(2, 4, "ae");

    public static <T> Future<T> submit(Callable<T> callable) {
        return executor.submit(callable);
    }

    public static void shutdown() {
        executor.shutdownNow();
    }

    public static void awaitTermination() throws InterruptedException {
        if (!executor.awaitTermination(2L, TimeUnit.SECONDS)) {
            Core.logger.warn("long(>2s) termination of AsyncExecutor");
            if (!executor.awaitTermination(1L, TimeUnit.DAYS)) {
                Core.logger.error("the termination wasn't finished");
            }
        }
    }
}

