/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.JWT;
import inform.agent.web.Session;
import io.jsonwebtoken.JwtException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JWTServlet
extends AsmoServlet {
    static final String AUTHORIZATION_PREFIX = "Bearer ";

    public JWTServlet() {
        super(AsmoServlet.Type.JSON);
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Session session = (Session)request.getSession(true);
        response.setHeader("Set-Cookie", response.getHeader("Set-Cookie") + ";Max-Age=0");
        if ("OPTIONS".equals(request.getMethod())) {
            this.doOptions(request, response);
            return;
        }
        if (!this.processCORSHeaders(request, response)) {
            return;
        }
        String pathInfo = request.getPathInfo();
        boolean respondWithOneTimeToken = null != pathInfo && pathInfo.startsWith("/ott");
        response.setHeader("Cache-Control", "no-store");
        String authorization = request.getHeader("Authorization");
        if (Strings.isVoid(authorization) || !authorization.startsWith(AUTHORIZATION_PREFIX)) {
            this.sendUnauthorizedError(response, "bad Authorization header");
            return;
        }
        String encodedJWT = authorization.substring(AUTHORIZATION_PREFIX.length());
        String origin = request.getHeader("Origin");
        if (Strings.isVoid(origin)) {
            origin = "^__UNKNOWN-IMPOSSIBLE-ORIGIN__^";
        }
        JWT jwt = null;
        try {
            jwt = new JWT(encodedJWT, origin);
        }
        catch (JwtException e) {
            String errorMsg = e.getMessage();
            Core.logger.warn("JWT login: error while validating JWT: {} ", (Object)errorMsg);
            this.sendUnauthorizedError(response, errorMsg);
            return;
        }
        Session.User sessionUser = session.processAuthentification(request, response);
        if (null == sessionUser) {
            this.sendUnauthorizedError(response, response.getHeader("X-Asmo-JWT-Error"));
            return;
        }
        UserNode node = MtdEngine.getUserNodeByName(jwt.username);
        if (null == node) {
            String errorMsg = "no such user \"" + jwt.username + "\"";
            Core.logger.warn("JWT login: {}", (Object)errorMsg);
            this.sendUnauthorizedError(response, errorMsg);
            return;
        }
        if (node.isActiveDirectoryAuthorization()) {
            String errorMsg = "It is prohibited to authorize ActiveDirectory users with JWT";
            Core.logger.warn("JWT login: {}", (Object)errorMsg);
            this.sendUnauthorizedError(response, errorMsg);
            return;
        }
        if (respondWithOneTimeToken) {
            session.setAttribute("__asmo_encoded_jwt", encodedJWT);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String ott = Base64.getUrlEncoder().withoutPadding().encodeToString(session.getId().getBytes());
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding()), true);
            out.append("{\"ott\":\"").append(ott).append("\"}");
            out.flush();
        } else {
            this.setJWTCookie(response, encodedJWT, jwt.secondsToLive());
        }
    }

    private void setJWTCookie(HttpServletResponse response, String encodedJWT, long timeToLive) {
        response.setHeader("Set-Cookie", "ASMOJWT=" + encodedJWT + ";Path=/;SameSite=None;Secure;HttpOnly;Max-Age=" + timeToLive);
    }

    private void sendError(HttpServletResponse resp, int status_code, String message) throws Throwable {
        this.setJWTCookie(resp, "none", 0L);
        resp.setStatus(status_code >= 400 && status_code < 600 ? status_code : 500);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
        out.append("{\"error\":").append(JSON.toString(message != null ? message : "Unknown error"));
        out.append('}');
        out.flush();
    }

    private void sendUnauthorizedError(HttpServletResponse resp, String message) throws Throwable {
        this.sendError(resp, 401, message != null ? message : "Unauthorized");
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        response.setHeader("Allow", "GET, POST, OPTIONS");
        this.processCORSHeaders(request, response);
    }

    protected boolean processCORSHeaders(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String origin = request.getHeader("Origin");
        if (Strings.isVoid(origin) || !JWT.isSourceTrusted(origin)) {
            this.sendError(response, 403, "untrusted origin");
            return false;
        }
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Vary", "Origin");
        response.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        return true;
    }
}

