/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ModuleServlet
extends AsmoServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        resp.setHeader("Cache-Control", "no-cache");
        resp.addDateHeader("Last-Modified", AgentJARVersion.BUILD_DATE);
        if (AgentJARVersion.BUILD_DATE <= req.getDateHeader("If-Modified-Since") + 1000L) {
            resp.setStatus(304);
            return;
        }
        Object path = req.getPathInfo();
        if (path != null) {
            InputStream in;
            String name;
            boolean css = ((String)path).startsWith("/css!");
            if (css) {
                name = ((String)path).substring(5);
                path = "/" + name.replace('.', '/') + ".css";
            } else {
                name = ((String)path).substring(1);
                path = ((String)path).replace('.', '/') + ".js";
            }
            path = ((String)path).replace("/static", "/WEB-ROOT");
            String mime = req.getServletContext().getMimeType((String)path);
            if (mime != null) {
                resp.setHeader("Content-Type", mime + "; charset=windows-1251");
            }
            if ((in = ModuleServlet.class.getResourceAsStream((String)path)) != null) {
                try {
                    ServletOutputStream out = resp.getOutputStream();
                    if (css) {
                        this.transfer(in, (OutputStream)out);
                        return;
                    }
                    out.write("(function(define){define.amd={};\t".getBytes(TaggedWriter.ANSI));
                    this.transfer(in, (OutputStream)out);
                    out.write(("\n})(function(){\n\tvar name = " + JSON.toString(name) + ";\n\tvar args = Array.prototype.slice.call( arguments );\n\tif ( (typeof args[0]) !== \"string\" )\n\t\targs.unshift( name );\n\telse if ( args[0] !== name )\n\t\tthrow \"module name mismatch\";\n\tdefine.apply( null, args );\n});").getBytes(TaggedWriter.ANSI));
                    return;
                }
                finally {
                    in.close();
                }
            }
        }
        resp.setStatus(404);
    }

    private void transfer(InputStream from, OutputStream to) throws IOException {
        int l;
        int b = from.read();
        if (b == -1) {
            return;
        }
        if (b == 239) {
            from.skip(2L);
            ModuleServlet.transferTranscoded(from, to);
            return;
        }
        to.write(b);
        byte[] buff = new byte[4096];
        while ((l = from.read(buff)) >= 0) {
            to.write(buff, 0, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferTranscoded(InputStream from, OutputStream to) throws IOException {
        OutputStreamWriter writer = null;
        InputStreamReader reader = new InputStreamReader(from, TaggedWriter.UTF8);
        try {
            int l;
            writer = new OutputStreamWriter((OutputStream)new NonClosableOutputStream(to), TaggedWriter.ANSI);
            char[] buff = new char[4096];
            while ((l = reader.read(buff)) >= 0) {
                writer.write(buff, 0, l);
            }
        }
        finally {
            reader.close();
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static class NonClosableOutputStream
    extends FilterOutputStream {
        NonClosableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }
    }
}

