/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.TicketEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ExtFilesNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.Session;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OpenNodeServlet
extends AsmoServlet.WithSession {
    public OpenNodeServlet() {
        super(AsmoServlet.Type.HTML);
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ArrayList<Double> params;
        Session session = (Session)request.getSession(true);
        if (session.user() != null || request.getQueryString() == null) {
            super.execute(request, response);
            return;
        }
        String id = null;
        try {
            String[] path = request.getPathInfo().split("/");
            id = path[1];
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return;
        }
        if (id == null) {
            return;
        }
        String decodeQuery = URLDecoder.decode(request.getQueryString(), "UTF-8");
        String key = null;
        String[] decodeParams = decodeQuery.split("&");
        if (decodeParams[0] != null && decodeParams[0].startsWith("k=")) {
            key = decodeParams[0].substring(2);
        }
        if ((params = TicketEngine.findTicket(Double.parseDouble(id), 1, key)).isEmpty()) {
            Core.logger.info("\u0414\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f OpenNode \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0431\u0438\u043b\u0435\u0442.");
            super.execute(request, response);
            return;
        }
        double pid = params.get(0);
        double userId = params.get(1);
        TicketEngine.deleteExpireAndObsoleteTickets(pid);
        Session.User user = session.processAuthentification(userId, request, response);
        if (user == null) {
            this.type.sendInsufficientPrivilegies(request, response, session, this.root());
            return;
        }
        user.revalidateNode();
        try {
            this.execute(request, response, session);
        }
        catch (AsmoServlet.WithSession.InsufficientPrivilegiesException e) {
            Core.logger.error(null, e);
            this.type.sendInsufficientPrivilegies(request, response, session, this.root());
        }
    }

    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        Acl acl;
        Node nod;
        String sPath = req.getPathInfo();
        if (null == sPath) {
            throw new InformException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 id \u0443\u0437\u043b\u0430 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435");
        }
        String[] path = sPath.split("/");
        if (path.length < 2) {
            throw new InformException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 id \u0443\u0437\u043b\u0430 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435");
        }
        String id = path[1];
        Node node = nod = Character.isDigit(id.charAt(0)) ? MtdEngine.getNode(Long.parseLong(id)) : MtdEngine.getNodeByIdent(id);
        if (nod == null) {
            throw new InformException("\u0423\u0437\u0435\u043b [" + id + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        double nodeId = nod.getId();
        BasicNode node2 = nod.getRealNode();
        Session.User user = session.user();
        if ((user.accessMask(acl = Security.acl(node2)) & 0x8000000) == 0) {
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        byte[] content = null;
        StringBuilder filePath = new StringBuilder();
        for (int j = 2; j < path.length; ++j) {
            if (j != 2) {
                filePath.append('/');
            }
            filePath.append(path[j]);
        }
        switch (node2.getType()) {
            case 25: {
                assert (node2 instanceof ExtFilesNode);
                content = ExtFilesNode.getFileContentRel((ExtFilesNode)node2, filePath.toString());
                resp.setStatus(200);
                resp.getOutputStream().write(content);
                break;
            }
            case 12: {
                String rid = req.getParameter("rid");
                String fid = req.getParameter("fid");
                if (Strings.isVoid(rid) || Strings.isVoid(fid)) {
                    content = ExtFilesNode.getFileContentRelBlob(String.valueOf(nodeId), filePath.toString());
                    resp.setStatus(200);
                    resp.getOutputStream().write(content);
                    break;
                }
                ExtFilesNode.getFileContentFromBlob(String.valueOf(nodeId), rid, fid, resp, req, session);
                break;
            }
            default: {
                throw new InformException("OpenNode [" + id + "] \u0442\u0438\u043f \u0443\u0437\u043b\u0430 (" + node2.getType() + ") \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
            }
        }
    }
}

