/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActiveDirectory;
import inform.agent.AgentJARVersion;
import inform.agent.ClientUpdateInfo;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ProductInfo;
import inform.agent.VersionInfo;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.PersistentSessionEngine;
import inform.agent.mtd.TicketEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JWT;
import inform.agent.web.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WasmServlet
extends AsmoServlet {
    private static final long UPDATE_CACHE_MAX_AGE = 20000L;
    private long mt_cachedWasmUpdateInfoTime = 0L;
    private UpdateInfo mt_cachedWasmUpdateInfo;
    private static final ProductInfo product = new ProductInfo("asmo-re", "web", "wasm32", AgentJARVersion.CHANNEL, 0);
    private static VersionInfo minVersion = null;
    private static VersionInfo maxVersion = null;
    private static final String[] emptyPathInfo = new String[0];
    static final String[] mobileTemplates = new String[]{"mobile", "android", "webos", "iphone", "ipad", "ipod", "blackberry", "tablet", "macintosh"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo getUpdateInfo() throws Throwable {
        UpdateInfo result = null;
        Object object = WasmServlet.class;
        synchronized (WasmServlet.class) {
            long cacheTime;
            if (minVersion == null) {
                minVersion = VersionInfo.parseRange(Ini.wasmVer, 0, 0, 0, product.channel(), 0);
                maxVersion = VersionInfo.parseRange(Ini.wasmVer, 255, 0, Short.MAX_VALUE, product.channel(), Integer.MAX_VALUE);
                product.setChannel(minVersion.getChannel());
            }
            // ** MonitorExit[var4_2 /* !! */ ] (shouldn't be in output)
            object = this;
            synchronized (object) {
                result = this.mt_cachedWasmUpdateInfo;
                cacheTime = this.mt_cachedWasmUpdateInfoTime;
            }
            long cacheAge = System.currentTimeMillis() - cacheTime;
            if (cacheAge > 20000L || result == null || result.file == null) {
                result = new UpdateInfo();
                result.version = new VersionInfo(0L, 0L, 0L);
                ArrayList<VersionInfo> badVersions = ClientUpdateInfo.getBadVersions(product);
                result.file = ClientUpdateInfo.getMaxVersion(null, badVersions, result.version, product, minVersion, maxVersion);
                cacheTime = System.currentTimeMillis();
                WasmServlet wasmServlet = this;
                synchronized (wasmServlet) {
                    this.mt_cachedWasmUpdateInfo = result;
                    this.mt_cachedWasmUpdateInfoTime = cacheTime;
                }
            }
            return result;
        }
    }

    private boolean isMobile(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String userAgent = request.getHeader("User-Agent");
        if (Strings.isVoid(userAgent)) {
            return false;
        }
        userAgent = userAgent.toLowerCase();
        for (String s : mobileTemplates) {
            if (!userAgent.contains(s)) continue;
            return true;
        }
        return false;
    }

    private static double getPersistentSessionIdFromCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        Optional<Cookie> persistentSessionCookie = cookies == null ? Optional.empty() : Arrays.stream(cookies).filter(cookie -> "ASMOPERS".equals(cookie.getName())).findFirst();
        String encodedSessionId = persistentSessionCookie.map(Cookie::getValue).orElse(null);
        if (null == encodedSessionId) {
            return 0.0;
        }
        double persistentSessionIdValue = 0.0;
        try {
            String persistentSessionId = new String(Base64.getUrlDecoder().decode(encodedSessionId));
            persistentSessionIdValue = Double.parseDouble(persistentSessionId);
        }
        catch (IllegalArgumentException ignored) {
            response.setHeader("Set-Cookie", "ASMOPERS=;Path=/;SameSite=Strict;HttpOnly;Max-Age=0");
        }
        return persistentSessionIdValue;
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String cmd;
        UpdateInfo wasmUpdate = this.getUpdateInfo();
        if (wasmUpdate.file == null) {
            response.setStatus(404);
            return;
        }
        String encodedJWT = JWT.getEncodedJwtOrNullFrom(request);
        boolean haveJWT = !Strings.isVoid(encodedJWT);
        Session session = (Session)request.getSession(true);
        String path = request.getPathInfo();
        String[] pathInfo = path != null ? path.split("/") : emptyPathInfo;
        String string = cmd = pathInfo.length > 1 ? pathInfo[1].toLowerCase() : "";
        if (path == null || path.equals("/") || path.endsWith("index.html") || WasmServlet.checkRunNodePath(pathInfo, cmd) || WasmServlet.checkRunExtAppPath(pathInfo, cmd)) {
            String asmoWasmArgsHeader;
            StringBuilder html;
            Map parameters;
            boolean useExtAppParams;
            String sessionId = session.getId();
            String sessionUserName = null;
            boolean isNtlm = false;
            boolean isRunNodeId = useExtAppParams = pathInfo.length > 2 && cmd.equals("runextapp");
            boolean useCmdRunNode = pathInfo.length > 2 && cmd.equals("runnode");
            boolean useCmdRunNewNode = pathInfo.length > 2 && cmd.equals("runnewnode");
            boolean useCmdRunClientNode = pathInfo.length > 2 && cmd.equals("runclientnode");
            boolean isAnonymousLogin = false;
            Session.User sessionUser = null;
            String strNodeId = "";
            if (useCmdRunNode && (sessionUser = session.anonWasmUser(strNodeId = pathInfo[2].split("&")[0])) != null) {
                sessionUser.revalidateNode();
                sessionUserName = sessionUser.name();
                session.setAttribute("__asmo_wasm", sessionId);
                isAnonymousLogin = sessionUser.anonymous();
            }
            if (haveJWT && !isAnonymousLogin) {
                sessionUser = session.processAuthentification(request, response);
                if (null == sessionUser) {
                    haveJWT = false;
                } else {
                    sessionUserName = sessionUser.name();
                    sessionUser.revalidateNode();
                    if (null == sessionUser.node()) {
                        Core.logger.error("JWT Auth: UserNode is absent for user " + sessionUserName);
                        session.requestAuthentification(request, response, false, this.root());
                        return;
                    }
                    session.setAttribute("__asmo_encoded_jwt", encodedJWT);
                }
            }
            if (!(isAnonymousLogin || Ini.WasmNoAD || haveJWT || (parameters = request.getParameterMap()).containsKey("no_ad"))) {
                ServerNode.Descriptor sd = MtdEngine.serverNode().descriptor();
                if (sd.ntlm) {
                    isNtlm = true;
                    String hha = request.getHeader("Authorization");
                    if (hha == null || !hha.startsWith(Ini.WWW_AUTHORIZATION_TYPE)) {
                        session.removeAttribute("__asmo_active_directory");
                    }
                    try {
                        Session.User user = null;
                        try {
                            user = session.processAuthentification(request, response);
                        }
                        catch (AsmoServlet.WithSession.InsufficientPrivilegiesException insufficientPrivilegiesException) {
                            // empty catch block
                        }
                        if (user == null) {
                            session.requestAuthentification(request, response, false, this.root());
                            return;
                        }
                        user.revalidateNode();
                        if (user.node() != null && !user.node().isActiveDirectoryAuthorization()) {
                            session.requestAuthentification(request, response, false, this.root());
                            return;
                        }
                        sessionUserName = user.name();
                        session.setAttribute("__asmo_wasm", sessionId);
                    }
                    catch (ActiveDirectory.Error e) {
                        Core.logger.error(null, e);
                        response.setStatus(500);
                        response.setHeader("Content-disposition", "");
                        response.setContentType("text/html");
                        response.setCharacterEncoding("UTF-8");
                        PrintWriter w = response.getWriter();
                        w.append("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                        session.removeAttribute("__asmo_active_directory");
                        return;
                    }
                    catch (Session.UserNotFoundException e) {
                        Core.logger.error(null, e);
                        response.setStatus(500);
                        response.setHeader("Cache-Control", "no-store");
                        response.setContentType("text/html");
                        response.setCharacterEncoding("UTF-8");
                        PrintWriter w = response.getWriter();
                        w.append("<!doctype html><html lang=\"ru\"><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"><title>\u0410\u0421\u041c\u041e</title></head><body><div><h1>\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.<br>\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.</h1></div></body></html>");
                        session.removeAttribute("__asmo_active_directory");
                        return;
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                        this.type.sendServerError(response, e);
                        return;
                    }
                }
            }
            if (!isNtlm) {
                String renewSessionIDParam = request.getParameter("__touch");
                if (null != renewSessionIDParam) {
                    int padIndx;
                    boolean hasPersistentSessionIdValue;
                    Double persistentSessionIdValue = (Double)session.getAttribute("__asmo_persistent_session");
                    boolean bl = hasPersistentSessionIdValue = null != persistentSessionIdValue;
                    if ("goodbye".equals(renewSessionIDParam)) {
                        session.removeAttribute("__asmo_persistent_session");
                        double persistentSessionIdFromCookie = WasmServlet.getPersistentSessionIdFromCookie(request, response);
                        if (hasPersistentSessionIdValue && 0.0 != persistentSessionIdFromCookie && persistentSessionIdFromCookie == persistentSessionIdValue) {
                            PersistentSessionEngine.removePersistentSession(persistentSessionIdFromCookie);
                            response.setHeader("Set-Cookie", "ASMOPERS= ;SameSite=Strict;HttpOnly;Max-Age=-1");
                        }
                        return;
                    }
                    String encodedPersistentSessionId = "";
                    if (hasPersistentSessionIdValue && -1 != (padIndx = (encodedPersistentSessionId = new String(Base64.getUrlEncoder().encode(Double.toHexString(persistentSessionIdValue).getBytes()), StandardCharsets.UTF_8)).lastIndexOf(61, encodedPersistentSessionId.length() - 2))) {
                        encodedPersistentSessionId = encodedPersistentSessionId.substring(0, padIndx);
                    }
                    response.setHeader("Set-Cookie", "ASMOPERS=" + encodedPersistentSessionId + ";SameSite=Strict;HttpOnly;Max-Age=" + (Serializable)(encodedPersistentSessionId.isEmpty() ? "-1" : Integer.valueOf(34560000)));
                    return;
                }
                double persistentSessionId = WasmServlet.getPersistentSessionIdFromCookie(request, response);
                if (0.0 != persistentSessionId) {
                    session.setAttribute("__asmo_persistent_session", persistentSessionId);
                }
            }
            if ((html = WasmServlet.getFileAsString(wasmUpdate.file, "index.html")) == null) {
                response.setStatus(404);
                return;
            }
            String wasmVer = wasmUpdate.version.toString();
            WasmServlet.replaceText(html, "${VERSION}", wasmVer);
            WasmServlet.replaceText(html, product.name() + ".js", "wasm/" + wasmVer + "/" + product.name() + ".js");
            String extraArgs = "";
            boolean isMobile = this.isMobile(request);
            if (isMobile || !Strings.isVoid(Ini.WasmArgs)) {
                StringBuilder extra = new StringBuilder();
                if (isMobile) {
                    extra.append(", \"--mobile\"");
                }
                if (!Strings.isVoid(Ini.WasmArgs)) {
                    String decodeArgs = Ini.WasmArgs.replace("\\", "\\\\");
                    if ((decodeArgs = decodeArgs.replace("\"", "\\\"")) != null) {
                        String[] params = decodeArgs.split("&");
                        for (int i = 0; i < params.length; ++i) {
                            extra.append(", \"").append(params[i]).append('\"');
                        }
                    }
                }
                extraArgs = extra.toString();
            }
            if (!Ini.WasmDebug) {
                if (!Strings.isVoid(Ini.AgentWelcome)) {
                    String welcome = Ini.AgentWelcome;
                    welcome = welcome.replaceAll("\"", "\\\\\"");
                    welcome = welcome.replaceAll("\r", "");
                    welcome = welcome.replaceAll("\n", "\\\\n");
                    welcome = welcome.replaceAll("\t", "\\\\t");
                    WasmServlet.replaceText(html, "--debug-connections", "--welcome=" + welcome);
                } else {
                    WasmServlet.replaceText(html, ", \"--debug-connections\"", "");
                }
            }
            if (!useExtAppParams) {
                WasmServlet.replaceText(html, "\"-p6006\"", "\"-p" + Ini.ClientConnectionPort + "\"" + extraArgs);
                if (!Strings.isVoid(Ini.AgentName)) {
                    WasmServlet.replaceText(html, "ASMO", Ini.AgentName);
                    WasmServlet.replaceText(html, "-n\u0410\u0421\u041c\u041e", "-n" + Ini.AgentName);
                }
                if (!Strings.isVoid(sessionId)) {
                    if (isNtlm || isAnonymousLogin) {
                        WasmServlet.replaceText(html, "\"-l0\"", "\"-l" + sessionId + "\"");
                    } else {
                        WasmServlet.replaceText(html, "\"-l0\"", "\"--hsession=" + sessionId + "\"");
                    }
                } else if (haveJWT && !isAnonymousLogin) {
                    WasmServlet.replaceText(html, "\"-l0\"", "\"--jwt=" + encodedJWT + "\"");
                }
                if (!Strings.isVoid(sessionUserName)) {
                    WasmServlet.replaceText(html, "\"-u\"", "\"-u" + sessionUserName + "\"");
                } else if (!Strings.isVoid(Ini.WasmLogin)) {
                    WasmServlet.replaceText(html, "\"-u\"", "\"-u" + Ini.WasmLogin + "\"");
                }
            } else {
                String serverName = request.getParameter("s");
                String port = request.getParameter("p");
                String agentName = request.getParameter("n");
                String userName = request.getParameter("u");
                String key = request.getParameter("k");
                double nodeid = Double.parseDouble(strNodeId);
                if (!Strings.isVoid(key)) {
                    ArrayList<Double> params = TicketEngine.findTicket(nodeid, 1, key);
                    if (params.isEmpty()) {
                        Core.logger.info("\u0414\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0431\u0438\u043b\u0435\u0442.");
                        return;
                    }
                    double pid = params.get(0);
                    double userId = params.get(1);
                    TicketEngine.deleteExpireAndObsoleteTickets(pid);
                    try {
                        Session.User user = session.processAuthentification(userId, request, response);
                        if (user == null) {
                            this.type.sendInsufficientPrivilegies(request, response, session, this.root());
                            return;
                        }
                        user.revalidateNode();
                        sessionUserName = user.name();
                        session.setAttribute("__asmo_wasm", sessionId);
                        agentName = Ini.AgentName;
                        serverName = null;
                        userName = null;
                        port = null;
                        isNtlm = true;
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                        this.type.sendServerError(response, e);
                        return;
                    }
                }
                if (!Strings.isVoid(serverName)) {
                    WasmServlet.replaceText(html, "\"-s\" + window.location.host", "\"-s" + serverName + "\"");
                }
                if (!Strings.isVoid(port)) {
                    WasmServlet.replaceText(html, "\"-p6006\"", "\"-p" + port + "\"" + extraArgs);
                } else {
                    WasmServlet.replaceText(html, "\"-p6006\"", "\"-p" + Ini.ClientConnectionPort + "\"" + extraArgs);
                }
                if (!Strings.isVoid(agentName)) {
                    WasmServlet.replaceText(html, "ASMO", agentName);
                    WasmServlet.replaceText(html, "-n\u0410\u0421\u041c\u041e", "-n" + agentName);
                }
                if (!Strings.isVoid(userName)) {
                    WasmServlet.replaceText(html, "\"-u\"", "\"-u" + userName + "\"");
                } else if (!Strings.isVoid(sessionUserName)) {
                    WasmServlet.replaceText(html, "\"-u\"", "\"-u" + sessionUserName + "\"");
                } else if (!Strings.isVoid(Ini.WasmLogin)) {
                    WasmServlet.replaceText(html, "\"-u\"", "\"-u" + Ini.WasmLogin + "\"");
                }
                if (isNtlm && !Strings.isVoid(sessionId)) {
                    WasmServlet.replaceText(html, "\"-l0\"", "\"-l" + sessionId + "\"");
                }
                try {
                    Double.valueOf(strNodeId);
                    WasmServlet.replaceText(html, "\"--runNodeId\"", "\"--runNodeId=" + strNodeId + "\"");
                    WasmServlet.replaceText(html, "\"--runNewNodeId\"", "\"\"");
                }
                catch (NumberFormatException e) {
                    Core.logger.error(null, e);
                    isRunNodeId = false;
                }
            }
            if (!isRunNodeId && (useCmdRunNode || useCmdRunNewNode || useCmdRunClientNode)) {
                try {
                    Double.valueOf(strNodeId);
                    if (useCmdRunNewNode) {
                        WasmServlet.replaceText(html, "\"--runNodeId\"", "\"\"");
                        WasmServlet.replaceText(html, "\"--runNewNodeId\"", "\"--runNewNodeId=" + strNodeId + "\"");
                    } else {
                        WasmServlet.replaceText(html, "\"--runNodeId\"", "\"--runNodeId=" + strNodeId + "\"");
                        WasmServlet.replaceText(html, "\"--runNewNodeId\"", "\"\"");
                    }
                    if (pathInfo.length > 3) {
                        WasmServlet.replaceText(html, "\"--runActivateFunc\"", "\"--runActivateFunc=" + pathInfo[3] + "\"");
                    }
                    isRunNodeId = true;
                }
                catch (NumberFormatException e) {
                    Core.logger.error(null, e);
                    isRunNodeId = false;
                }
            }
            if (!isRunNodeId) {
                if (pathInfo.length > 2 && cmd.equals("gotonode")) {
                    try {
                        Double.valueOf(strNodeId);
                        WasmServlet.replaceText(html, "\"--runNodeId\"", "\"--goto-node=" + strNodeId + "\"");
                        WasmServlet.replaceText(html, "\"--runNewNodeId\"", "\"\"");
                        isRunNodeId = true;
                    }
                    catch (NumberFormatException e) {
                        Core.logger.error(null, e);
                        isRunNodeId = false;
                    }
                }
                if (!isRunNodeId) {
                    WasmServlet.replaceText(html, "\"--runNodeId\"", "\"\"");
                    WasmServlet.replaceText(html, "\"--runNewNodeId\"", "\"\"");
                }
            }
            StringBuilder ownParams = null;
            if (request.getQueryString() != null && !useExtAppParams) {
                ownParams = WasmServlet.contsructExtraArguments(URLDecoder.decode(request.getQueryString(), "UTF-8"), ownParams);
            }
            if (!Strings.isVoid(asmoWasmArgsHeader = request.getHeader("X-Asmo-Wasm-Args"))) {
                ownParams = WasmServlet.contsructExtraArguments(URLDecoder.decode(asmoWasmArgsHeader, "UTF-8"), ownParams);
            }
            if (ownParams != null) {
                WasmServlet.replaceText(html, "\"--getOwnParams\"", ownParams.toString());
            }
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Content-Type", "text/html");
            response.setCharacterEncoding("UTF-8");
            PrintWriter w = response.getWriter();
            w.append(html);
            return;
        }
        long lastModified = wasmUpdate.file.lastModified();
        long length = wasmUpdate.file.length();
        String eTag = wasmUpdate.version + "_" + length + "_" + lastModified;
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null && eTag.equals(ifNoneMatch) && WasmServlet.isCachedPath(path)) {
            response.setHeader("ETag", eTag);
            response.setStatus(304);
            return;
        }
        if (path.endsWith(product.name() + ".js")) {
            response.setCharacterEncoding("UTF-8");
            WasmServlet.sendFile(wasmUpdate.file, product.name() + ".js", "text/javascript", eTag, response);
            return;
        }
        if (path.endsWith(product.name() + ".js.map")) {
            response.setCharacterEncoding("UTF-8");
            WasmServlet.sendFile(wasmUpdate.file, product.name() + ".js.map", "text/javascript", eTag, response);
            return;
        }
        if (path.endsWith(product.name() + ".wasm")) {
            WasmServlet.sendFile(wasmUpdate.file, product.name() + ".wasm", "application/wasm", eTag, response);
            return;
        }
        if (path.endsWith(product.name() + ".data")) {
            WasmServlet.sendFile(wasmUpdate.file, product.name() + ".data", "application/octet-stream", eTag, response);
            return;
        }
        response.setStatus(404);
    }

    private static StringBuilder contsructExtraArguments(String decodeQuery, StringBuilder ownParams) {
        decodeQuery = decodeQuery.replace("\\", "\\\\");
        if ((decodeQuery = decodeQuery.replace("\"", "\\\"")) != null) {
            String[] params = decodeQuery.split("&");
            for (int i = 0; i < params.length; ++i) {
                if (ownParams == null) {
                    ownParams = new StringBuilder();
                } else {
                    ownParams.append(", ");
                }
                ownParams.append('\"').append(params[i]).append('\"');
            }
        }
        return ownParams;
    }

    private static boolean isCachedPath(String path) {
        return path.endsWith(product.name() + ".js") || path.endsWith(product.name() + ".js.map") || path.endsWith(product.name() + ".wasm") || path.endsWith(product.name() + ".data");
    }

    private static void replaceText(StringBuilder text, String fromStr, String toStr) {
        int index = text.indexOf(fromStr);
        if (index >= 0) {
            text.replace(index, index + fromStr.length(), toStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendFile(File wasmFile, String fileName, String mime, String eTag, HttpServletResponse response) throws IOException {
        try (ZipFile zip = new ZipFile(wasmFile);){
            ZipEntry entry = zip.getEntry(fileName);
            if (entry == null) {
                response.setStatus(404);
                return;
            }
            long entrySize = entry.getSize();
            try (InputStream stream = zip.getInputStream(entry);){
                int l;
                byte[] buffer = new byte[0x100000];
                response.setHeader("Cache-Control", "max-age=72000");
                response.setHeader("Content-Type", mime);
                response.setHeader("ETag", eTag);
                if (entrySize < Integer.MAX_VALUE) {
                    response.setContentLength((int)entrySize);
                }
                ServletOutputStream out = response.getOutputStream();
                while ((l = stream.read(buffer)) >= 0) {
                    out.write(buffer, 0, l);
                    if ((entrySize -= (long)l) > 0L) continue;
                }
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder getFileAsString(File wasmFile, String fileName) throws IOException {
        try (ZipFile zip = new ZipFile(wasmFile);){
            ZipEntry indexHtml = zip.getEntry(fileName);
            if (indexHtml == null) {
                StringBuilder stringBuilder = null;
                return stringBuilder;
            }
            StringBuilder stringBuilder = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(zip.getInputStream(indexHtml), TaggedWriter.UTF8);){
                int rsz;
                char[] buffer = new char[0x100000];
                while ((rsz = reader.read(buffer, 0, buffer.length)) >= 0) {
                    stringBuilder.append(buffer, 0, rsz);
                }
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
    }

    private static boolean checkRunNodePath(String[] pathInfo, String cmd) {
        if (pathInfo.length != 3 && pathInfo.length != 4) {
            return false;
        }
        if (cmd.equals("runnode") || cmd.equals("runnewnode") || cmd.equals("gotonode") || cmd.equals("runclientnode")) {
            try {
                String[] args = pathInfo[2].split("&");
                if (0 == args.length) {
                    return false;
                }
                String strNodeId = args[0];
                double nodeid = Double.parseDouble(strNodeId);
                return nodeid > 0.0;
            }
            catch (NumberFormatException nfe) {
                Core.logger.error(null, nfe);
                return false;
            }
        }
        return false;
    }

    private static boolean checkRunExtAppPath(String[] pathInfo, String cmd) {
        if (pathInfo.length != 3) {
            return false;
        }
        if (cmd.equals("runextapp")) {
            try {
                String[] parts = pathInfo[2].split("&");
                if (parts.length == 0) {
                    return false;
                }
                String strNodeId = parts[0];
                double nodeid = Double.parseDouble(strNodeId);
                return nodeid > 0.0;
            }
            catch (NumberFormatException nfe) {
                Core.logger.error(null, nfe);
                return false;
            }
        }
        return false;
    }

    private static class UpdateInfo {
        public VersionInfo version;
        public File file;

        private UpdateInfo() {
        }
    }
}

