/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr;

import inform.agent.expr.Expression;
import inform.agent.expr.FieldTerm;
import inform.agent.expr.Term;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.expr.WebExpression;

public class WebFieldTerm
extends FieldTerm {
    private final Task task;
    private Dataset datasource = null;
    private DatasetField field = null;

    public WebFieldTerm(Task task, Expression expr) {
        super(expr);
        this.task = task;
    }

    @Override
    public Term createClone(Expression ex) {
        WebExpression e = (WebExpression)ex;
        WebFieldTerm o = new WebFieldTerm(e.getTask(), e);
        o.datasourceId = this.datasourceId;
        o.fieldIdPath = this.fieldIdPath;
        o.datasource = this.datasource;
        o.field = this.field;
        return o;
    }

    @Override
    public void afterLoad() {
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
    }

    public void setField(Dataset dataset, DatasetField field) {
        this.datasource = dataset;
        this.field = field;
    }

    public void setupDatamodel(Datamodel datamodel) {
        if (this.datasource != null) {
            datamodel.add(this.datasource);
        }
    }

    public boolean select() throws Exception {
        if (this.datasource == null) {
            return false;
        }
        if (!this.datasource.isSelected()) {
            this.datasource.executeSelect();
        }
        return this.datasource.isCurrentRowAvailable() || this.datasource.next();
    }

    public DatasetField getField() {
        return this.field;
    }
}

