/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.func;

import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.expr.eval.func.WebFunctionEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebWhenEvaluator
extends WebFunctionEvaluator {
    public WebWhenEvaluator(Term term) {
        super(term);
    }

    @Override
    public TypedValue evaluate() throws Exception {
        if (this.arguments.size() < 2) {
            return null;
        }
        WebEvaluator condition = (WebEvaluator)this.arguments.get(0);
        if (condition == null) {
            return null;
        }
        TypedValue c = condition.evaluate();
        if (c == null) {
            return null;
        }
        if (!ValueCaster.toBoolean(c.getValue()).booleanValue()) {
            return null;
        }
        WebEvaluator result = (WebEvaluator)this.arguments.get(1);
        if (result == null) {
            return null;
        }
        return result.evaluate();
    }

    @Override
    public boolean isStringType() throws Exception {
        if (this.arguments.size() < 2) {
            return false;
        }
        for (WebEvaluator arg : this.arguments) {
            TypedValue v;
            if (arg == null || arg.isIgnored() || (v = arg.evaluate()) == null || !arg.isStringType()) continue;
            return true;
        }
        return false;
    }
}

