/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.op;

import inform.agent.db.types.DataType;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebNegEvaluator
extends WebEvaluator {
    private final WebEvaluator evaluator;

    public WebNegEvaluator(Term term, WebEvaluator evaluator) {
        super(term);
        this.evaluator = evaluator;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.evaluator.isIgnored();
    }

    @Override
    public TypedValue evaluate() throws Exception {
        if (this.evaluator == null) {
            return null;
        }
        TypedValue value = this.evaluator.evaluate();
        if (value == null) {
            return null;
        }
        return new TypedValue(DataType.FLOAT, WebNegEvaluator.toNumberSilent(value.getValue()));
    }

    @Override
    public boolean isStringType() throws Exception {
        return false;
    }
}

