/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.agent.web.utils.HtmlUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class HtmlWriter {
    private static final String[] FULLTAGS = new String[]{"script", "style", "div", "span", "textarea", "table"};
    private final Appendable out;
    private final Deque<String> tags = new ArrayDeque<String>();
    private final StringBuilder style = new StringBuilder();
    private boolean head;

    public HtmlWriter(Appendable out) {
        this.out = out;
    }

    public HtmlWriter tag(String name) throws IOException {
        if (this.head) {
            this.closeHead();
        }
        this.out.append('<').append(name);
        this.tags.push(name);
        this.head = true;
        this.style.setLength(0);
        return this;
    }

    public HtmlWriter attr(String name) throws IOException {
        this.checkHead();
        this.out.append(' ').append(name);
        return this;
    }

    public HtmlWriter attr(String name, Object value) throws IOException {
        this.checkHead();
        String val = String.valueOf(value);
        this.out.append(' ').append(name).append("='");
        HtmlUtils.enquoteAttribute(val, '\'', this.out);
        this.out.append('\'');
        return this;
    }

    public HtmlWriter style(String name, Object value) throws IOException {
        this.checkHead();
        this.style.append(name).append(':').append(value).append(';');
        return this;
    }

    public HtmlWriter style(String name, Object value, String unit) throws IOException {
        this.checkHead();
        this.style.append(name).append(':').append(value).append(unit).append(';');
        return this;
    }

    public HtmlWriter text(Object value) throws IOException {
        return this.html(String.valueOf(value).replace("&", "&amp;").replace("<", "&lt;"));
    }

    public HtmlWriter html(Object value) throws IOException {
        if (this.head) {
            this.closeHead();
        }
        this.out.append(String.valueOf(value));
        return this;
    }

    public HtmlWriter end() throws IOException {
        String tag = this.tags.pop();
        if (this.head) {
            if (this.style.length() > 0) {
                this.attr("style", this.style);
            }
            this.head = false;
            for (String s : FULLTAGS) {
                if (!s.equals(tag)) continue;
                this.out.append(">");
                this.out.append("</").append(tag).append('>');
                return this;
            }
            this.out.append("/>");
        } else {
            this.out.append("</").append(tag).append('>');
        }
        return this;
    }

    private void checkHead() {
        if (!this.head) {
            throw new IllegalStateException("not in head");
        }
    }

    private void closeHead() throws IOException {
        if (this.style.length() > 0) {
            this.attr("style", this.style);
        }
        this.out.append('>');
        this.head = false;
    }
}

