/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebScript;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.HashSet;

@JSRequire(value={"WebButton", "static.wcl.controls.Button"})
public class WebButton
extends WebControl
implements WebScript.EventHolder {
    private static final int TAG_WEB_BUTTON_ON_CLICK = 41;
    private static final int TAG_WEB_BUTTON_EVENT = 42;
    private static final int TAG_WEB_BUTTON_CAPTION = 43;
    private static final int TAG_WEB_BUTTON_IMAGE_ID = 60;
    private static final int TAG_WEB_BUTTON_AUTOSAVE = 61;
    private static final int TAG_WEB_BUTTON_EDITMODEONLY = 62;
    protected String text;
    protected WebControl.WebEvent event;
    private int imageId;
    private String onClick;
    private boolean autosave = false;
    private boolean isEditModeOnly = false;

    public WebButton(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @SmartScriptableObject.PropertyTag
    public String getText() {
        return this.text;
    }

    public void setText(String v) {
        this.text = v;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 61: {
                this.autosave = true;
                break;
            }
            case 62: {
                this.isEditModeOnly = true;
                break;
            }
            case 41: {
                this.onClick = reader.getAnsi();
                break;
            }
            case 42: {
                this.event = new WebControl.WebEvent(reader.getRaw());
                break;
            }
            case 43: {
                this.text = reader.getString();
                break;
            }
            case 60: {
                this.imageId = reader.getInt();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("button").attr("id", this.id);
        if (this.font != null) {
            this.font.appendCssTo(writer);
        }
        if (this.width > 0.0) {
            writer.style("width", this.width, "mm");
        }
        this.appendAttributes(writer, resolver);
        Object cap = this.text;
        if (this.event != null) {
            writer.attr("data-action", this.event.toValue());
            if (this.event.isDropdown(resolver)) {
                if (cap == null) {
                    cap = "";
                }
                cap = (String)cap + "<span class='dd'>&#9660;</span>";
            }
        }
        writer.html(cap).end();
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object();
        json.underscore("Button", this);
        boolean enabled = this.isEnabled();
        if (!enabled) {
            json.prop("enabled").val(enabled);
        }
        json.prop("tag").val(this.getTag());
        if (this.isEditModeOnly) {
            json.prop("editmodeonly").val(true);
        }
        if (!this.visible) {
            json.prop("display").val("none");
        }
        this.addScriptProp(json, resolver);
        Object cap = this.text;
        if (!Strings.isVoid(this.onClick) && resolver.hasFormScript) {
            json.prop("scriptclick").js("formScript." + this.onClick);
        } else if (this.event != null && !this.autosave) {
            json.prop("onclick").js("cact(new WF.ActionList(").val(this.event.toValue()).js(",components))");
            if (this.event.isDropdown(resolver)) {
                if (cap == null) {
                    cap = "";
                }
                cap = (String)cap + " &#9660;";
            }
        } else if (this.autosave) {
            json.prop("onclick").js("cact(datamodel,1)");
        }
        json.prop("text").val(cap);
        if (this.imageId != 0) {
            json.prop("icon").val(this.imageId);
        }
        json.end();
    }

    @Override
    public HashSet<String> getScriptEvents(HashSet<String> events) {
        return WebButton.addScriptEvent(events, this.onClick);
    }
}

