/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.components.WebBlobManager;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebDatasource;
import inform.agent.web.forms.components.WebFolder;
import inform.agent.web.forms.components.WebFormLauncher;
import inform.agent.web.forms.components.WebMenu;
import inform.agent.web.forms.components.WebQueryLauncher;
import inform.agent.web.forms.components.WebReportLauncher;
import inform.agent.web.forms.components.WebScriptLauncher;
import inform.agent.web.forms.components.WebUnknownComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class WebComponentContainer
extends WebComponent {
    private static final int TAG_WEB_COMPONENT_ID = 1;
    private static final int TAG_WEB_COMPONENT_TYPE = 2;
    private static final int TAG_WEB_COMPONENT_OPTIONS = 3;
    private static final int COMPONENT_WC_FORM_MENU = 1601;
    private static final int COMPONENT_WC_FORM_LAUNCHER = 1602;
    private static final int COMPONENT_WC_BLOB_MANAGER = 1604;
    private static final int COMPONENT_WC_REPORT_LAUNCHER = 1605;
    private static final int COMPONENT_WC_QUERY_LAUNCHER = 1606;
    public final Collection<WebComponent> components = new ArrayList<WebComponent>();

    public WebComponentContainer(int id, WebComponentContainer parent, boolean isSubComponent) {
        super(id, parent, isSubComponent);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 1: 
            case 2: {
                this.components.add(this.loadTypedComponent(reader));
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    protected WebComponent loadTypedComponent(TaggedReader reader) throws IOException {
        int options;
        int type;
        int cid;
        if (reader.getCurrentTag() == 1) {
            cid = reader.getInt();
            type = reader.getInt();
            options = reader.getInt();
        } else {
            int[] header = LittleEndian.toIntArray(reader.getRaw());
            type = header[0];
            cid = header[1];
            options = header[6];
        }
        WebComponent c = this.createTypedComponent(type, cid, options);
        c.load(reader.getSubStreamReader());
        return c;
    }

    protected WebComponent createTypedComponent(int type, int id, int options) {
        switch (type) {
            case 1101: {
                return new WebFolder(id, options, this);
            }
            case 1102: {
                return new WebDatasource(id, options, this);
            }
            case 1103: {
                return new WebScriptLauncher(id, options, this);
            }
            case 1601: {
                return new WebMenu(id, options, this);
            }
            case 1602: {
                return new WebFormLauncher(id, options, this);
            }
            case 1604: {
                return new WebBlobManager(id, options, this);
            }
            case 1605: {
                return new WebReportLauncher(id, options, this);
            }
            case 1606: {
                return new WebQueryLauncher(id, options, this);
            }
        }
        return new WebUnknownComponent(id, options, this, type);
    }
}

