/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ParametersList;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.ParameterSyncs;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;
import java.util.Collections;

@JSRequire(value={"WebLauncher"})
public class WebLauncher
extends WebComponent
implements DatasourceUsage {
    private static final int TAG_WEB_FORM_LAUNCHER_NODE_ID = 40;
    private static final int TAG_WEB_FORM_LAUNCHER_PARAMS = 41;
    private static final int TAG_WEB_FORM_LAUNCHER_PARAM_SYNC = 42;
    private static final int TAG_WEB_LAUNCHER_DONT_ASK_PARAMS = 47;
    protected WebForm.NodeData<byte[], IOException> node;
    private byte[] pbindings;
    private Iterable<ParameterSyncs.Entry> syncs = Collections.emptyList();
    private boolean dontAskParams;

    public WebLauncher(int id, WebComponentContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.node = new WebForm.NodeData<byte[], IOException>(reader.getNodeID()){

                    @Override
                    protected byte[] read(Node node) throws IOException {
                        byte[] result = null;
                        TaggedReader reader = new TaggedReader(((BasicNode)node).getContent());
                        block0: while (reader.next()) {
                            if (reader.getCurrentTag() != 152) continue;
                            TaggedReader r = reader.getSubStreamReader();
                            while (r.next()) {
                                if (r.getCurrentTag() != 153) continue;
                                result = r.getSubStreamData();
                                continue block0;
                            }
                        }
                        return result;
                    }
                };
                break;
            }
            case 41: {
                reader.skip();
                this.pbindings = reader.getSubStreamData();
                break;
            }
            case 42: {
                this.syncs = new ParameterSyncs(reader.getSubStreamReader());
                break;
            }
            case 47: {
                this.dontAskParams = true;
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
        StringBuilder params = new StringBuilder();
        StringBuilder pbinds = new StringBuilder();
        byte[] parameters = this.node.fetch();
        if (parameters != null) {
            ParametersList plist = new ParametersList();
            plist.load(task.getConstants(), new TaggedReader(parameters), task.getHost());
            if (this.pbindings != null) {
                plist.loadParametersBindings(task.getParameters(), task.getConstants(), new TaggedReader(this.pbindings));
            }
            WebLauncher.generateParametersTo(this.getOwnerId(), params, plist, "\n\t\t" + pad);
            WebLauncher.generateParametersBindingsTo(pbinds, plist, "datamodel._datasources", "\n\t\t" + pad, this.needAllParameterValues(), null);
        }
        StringBuilder psyncs = new StringBuilder();
        boolean nc = false;
        for (ParameterSyncs.Entry p : this.syncs) {
            if (nc) {
                psyncs.append(',');
            }
            psyncs.append("\n\t\t").append(pad).append(JSON.toString(p.name)).append(':');
            psyncs.append("datamodel._datasources[").append(p.dsid).append("]._fbyid[").append(p.fpath[0]).append(']');
            nc = true;
        }
        out.append(pad).append("components[").append(Integer.toString(this.id)).append("] = new WebLauncher({dmodel:datamodel,node:").append(Long.toString((long)this.node.id));
        Node n = MtdEngine.getNode(this.node.id);
        out.append(",caption:").append(JSON.toString(n != null ? n.getName() : String.format("?%.0f", this.node.id)));
        if (this.dontAskParams) {
            out.append('\n').append(pad).append("\t,dontAskParams:true");
        }
        if (params.length() > 0) {
            out.append('\n').append(pad).append("\t,parameters:{").append(params).append('\n').append(pad).append("\t}");
        }
        if (pbinds.length() > 0) {
            out.append('\n').append(pad).append("\t,p_bindings:{").append(pbinds).append('\n').append(pad).append("\t}");
        }
        if (psyncs.length() > 0) {
            out.append('\n').append(pad).append("\t,paramsyncs:{").append(psyncs).append('\n').append(pad).append("\t}");
        }
        this.appendExtraProperties(out, pad);
        out.append('\n').append(pad).append("});\n");
    }

    protected boolean needAllParameterValues() {
        return true;
    }

    protected void appendExtraProperties(Appendable out, String pad) throws IOException {
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        for (ParameterSyncs.Entry p : this.syncs) {
            out.append((Object)this, p.dsid, p.fpath);
        }
        if (this.pbindings != null) {
            out.appendPBindings(this, new TaggedReader(this.pbindings));
        }
    }
}

