/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;
import java.util.Arrays;

@JSRequire(value={"WebMenu", "css!WebMenu"})
public class WebMenu
extends WebComponentContainer {
    private static final int COMPONENT_WC_FORM_MENU_ITEM = 1601;

    public WebMenu(int id, int options, WebComponentContainer parent) {
        super(id, parent, false);
    }

    @Override
    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
        out.append(pad).append("components[").append(Integer.toString(this.id)).append("] = new WebMenu({id:").append(Integer.toString(this.id)).append(",coms:components,items:[");
        boolean nc = false;
        for (WebComponent i : this.components) {
            if (nc) {
                out.append(',');
            }
            nc = true;
            ((Item)i).generate(out, pad);
        }
        out.append('\n').append(pad).append("]});\n");
    }

    @Override
    protected WebComponent createTypedComponent(int type, int id, int options) {
        if (type == 1601) {
            return new Item(id, options, this);
        }
        return super.createTypedComponent(type, id, options);
    }

    protected static class Item
    extends WebComponentContainer
    implements DatasourceUsage {
        static final int TAG_WEB_TOOLBUTTON_CAPTION = 40;
        static final int TAG_WEB_TOOLBUTTON_HINT = 41;
        static final int TAG_WEB_TOOLBUTTON_IMAGE_ID = 42;
        static final int TAG_WEB_TOOLBUTTON_SEPARATOR = 47;
        static final int TAG_WEB_TOOLBUTTON_DATASOURCE = 48;
        static final int TAG_WEB_TOOLBUTTON_CAPTION_FIELD = 49;
        static final int TAG_WEB_TOOLBUTTON_IMAGE_FIELD = 50;
        static final int TAG_WEB_TOOLBUTTON_EVENT = 53;
        String caption;
        String hint;
        int imageId;
        boolean separator;
        int dsid;
        int[] fcap;
        int[] fimg;
        int[] event;

        Item(int id, int options, WebComponentContainer parent) {
            super(id, parent, true);
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 40: {
                    this.caption = reader.getString();
                    break;
                }
                case 41: {
                    this.hint = reader.getString();
                    break;
                }
                case 42: {
                    this.imageId = reader.getInt();
                    break;
                }
                case 47: {
                    this.separator = true;
                    break;
                }
                case 48: {
                    this.dsid = reader.getInt();
                    break;
                }
                case 49: {
                    this.fcap = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                case 50: {
                    this.fimg = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                case 53: {
                    this.event = LittleEndian.toIntArray(reader.getRaw());
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }

        @Override
        public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
            out.append((Object)this, this.dsid, this.fcap);
            out.append((Object)this, this.dsid, this.fimg);
        }

        @Override
        protected WebComponent createTypedComponent(int type, int id, int options) {
            return ((WebMenu)this.parent).createTypedComponent(type, id, options);
        }

        public void generate(Appendable out, String pad) throws IOException {
            out.append('\n').append(pad).append("\t{caption:").append(JSON.toString(this.caption));
            if (!Strings.isVoid(this.hint)) {
                out.append(",hint:").append(JSON.toString(this.hint));
            }
            if (this.imageId != 0) {
                out.append(",image:").append(Integer.toString(this.imageId));
            }
            if (this.dsid != 0) {
                out.append(",ds:datamodel._datasources[").append(Integer.toString(this.dsid)).append(']');
            }
            if (this.fcap != null) {
                out.append(",fc:").append(Arrays.toString(this.fcap));
            }
            if (this.fimg != null) {
                out.append(",fi:").append(Arrays.toString(this.fimg));
            }
            if (this.event != null) {
                out.append(",event:[");
                boolean ncc = false;
                for (int ei = 0; ei < this.event.length / 2; ++ei) {
                    if (ncc) {
                        out.append(',');
                    }
                    ncc = true;
                    out.append('[').append(Integer.toString(this.event[ei * 2 + 0]));
                    out.append(',').append(Integer.toString(this.event[ei * 2 + 1])).append(']');
                }
                out.append(']');
            }
            if (!this.components.isEmpty()) {
                out.append(",items:[");
                boolean nc = false;
                for (WebComponent i : this.components) {
                    if (nc) {
                        out.append(',');
                    }
                    nc = true;
                    ((Item)i).generate(out, pad + "\t");
                }
                out.append('\n').append(pad).append("\t]");
            }
            out.append('}');
        }
    }
}

