/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports;

import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ParametersList;
import inform.agent.web.JSON;
import inform.agent.web.Resource;
import inform.agent.web.forms.components.WebComponent;
import java.io.IOException;
import java.io.Writer;

public class AsyncReport {
    public static void response(Writer w, Node node, String id, int rom, ParametersList parameters, String root) throws IOException {
        String hrefPart = root + "/node/" + (long)node.getId() + "/async/" + id + "/" + node.getName();
        StringBuilder saveAs = new StringBuilder();
        if (rom != 0) {
            if ((rom & 2) != 0) {
                saveAs.append(saveAs.length() > 0 ? (char)',' : ' ').append("{\"c\":\"Web-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\",\"h\":").append(JSON.toString(hrefPart + ".html")).append('}');
            }
            if ((rom & 8) != 0) {
                saveAs.append(saveAs.length() > 0 ? (char)',' : ' ').append("{\"c\":\"MS Word (docx)\",\"h\":").append(JSON.toString(hrefPart + ".docx")).append('}');
            }
            if ((rom & 4) != 0) {
                saveAs.append(saveAs.length() > 0 ? (char)',' : ' ').append("{\"c\":\"MS Excel2007 (xlsx)\",\"h\":").append(JSON.toString(hrefPart + ".xlsx")).append('}');
            }
            if ((rom & 0x10) != 0) {
                saveAs.append(saveAs.length() > 0 ? (char)',' : ' ').append("{\"c\":\"\u0422\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\",\"h\":").append(JSON.toString(hrefPart + ".txt")).append('}');
            }
            if ((rom & 0x20) != 0) {
                saveAs.append(saveAs.length() > 0 ? (char)',' : ' ').append("{\"c\":\"PDF\",\"h\":").append(JSON.toString(hrefPart + ".pdf")).append('}');
            }
        }
        StringBuilder prms = new StringBuilder();
        StringBuilder pbnd = new StringBuilder();
        WebComponent.generateParametersTo(node.getId(), prms, parameters, "\n\t\t\t\t\t");
        WebComponent.generateParametersBindingsTo(pbnd, parameters, null, "\n\t\t\t\t\t", true, null);
        String html = Resource.asString(AsyncReport.class, AsyncReport.class.getSimpleName() + ".html", root);
        html = html.replace("\"{ROM}\"", saveAs.toString());
        html = html.replace("{NODE}", Long.toString((long)node.getId()));
        html = html.replace("{ASYNC}", id);
        html = html.replace("{{TITLE}}", node.getName());
        html = html.replace("\"{TITLE}\"", JSON.toString(node.getName()));
        html = html.replace("/*PARAMETERS*/", prms);
        html = html.replace("/*P_BINDINGS*/", pbnd);
        w.append(html);
    }
}

