/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerTask;
import inform.agent.scripts.Task;
import inform.agent.web.reports.ReportTask;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.generators.DocxGenerator;
import inform.agent.web.reports.generators.HtmlGenerator;
import inform.agent.web.reports.generators.ODSGenerator;
import inform.agent.web.reports.generators.ODTGenerator;
import inform.agent.web.reports.generators.PdfGenerator;
import inform.agent.web.reports.generators.TxtGenerator;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.reports.generators.XlsxGenerator;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class GenerateReportRequest
extends Request {
    private static final int TAG_MODIFIED_CONSTANTS = 1;
    private static final int TAG_NODE_CONTENT = 2;
    private static final int TAG_GENERATE_FILE = 3;
    private static final int TAG_CLIENT_REPORT = 4;
    private static final int TAG_POSTPROCESSING_MODULE_ID = 5;
    private static final int TAG_POSTPROCESSING_PARAM_SCRIPT_NAME = 6;
    private static final int TAG_RESULT = 1;

    public GenerateReportRequest(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] modifiedConstantsContent = null;
        byte[] inputParametersContent = null;
        byte[] webReportContent = null;
        boolean generateFile = false;
        int reportOutputFile = 1;
        TaggedReader reader = this.createRequestContentReader();
        boolean isClientReport = false;
        double postProcessingModuleId = 0.0;
        String blobParamScriptName = null;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    modifiedConstantsContent = reader.getRaw();
                    break;
                }
                case 2: {
                    webReportContent = reader.getRaw();
                    break;
                }
                case 3: {
                    generateFile = true;
                    reportOutputFile = reader.getInt();
                    break;
                }
                case 153: {
                    inputParametersContent = reader.getSubStreamData();
                    break;
                }
                case 4: {
                    isClientReport = true;
                    break;
                }
                case 5: {
                    postProcessingModuleId = reader.getDouble();
                    break;
                }
                case 6: {
                    blobParamScriptName = reader.getAnsi();
                }
            }
        }
        double nodeId = this.getNodeID();
        BasicNode node = (BasicNode)MtdEngine.getValidNode(nodeId);
        if (webReportContent == null) {
            webReportContent = node.getContent();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try (ReportTask task = new ReportTask(this, node, webReportContent, modifiedConstantsContent, null, isClientReport);){
            Document document;
            if (inputParametersContent != null) {
                task.getParameters().loadParametersValues(task.getConstants(), new TaggedReader(inputParametersContent), task.getHost());
            }
            if ((document = task.generate()) != null) {
                if (generateFile) {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(content);
                    WebReportGenerator generator = null;
                    switch (reportOutputFile) {
                        case 1: {
                            generator = new HtmlGenerator(document);
                            break;
                        }
                        case 2: {
                            generator = new XlsxGenerator(document, node.getName());
                            break;
                        }
                        case 3: {
                            generator = new DocxGenerator(document, node.getName());
                            break;
                        }
                        case 4: {
                            generator = new TxtGenerator(document, node.getName(), "cp1251");
                            break;
                        }
                        case 5: {
                            generator = new PdfGenerator(document, node.getName());
                            break;
                        }
                        case 6: {
                            generator = new ODTGenerator(document, node.getName());
                            break;
                        }
                        case 7: {
                            generator = new ODSGenerator(document, node.getName());
                        }
                    }
                    if (generator == null) {
                        document.store(out);
                    } else {
                        if (isClientReport) {
                            document.beginProfile(3);
                        }
                        generator.generateBody(stream, "cp1251");
                        if (isClientReport) {
                            document.endProfile(3);
                            document.endProfile(0);
                        }
                        stream.close();
                        if (isClientReport && (reportOutputFile == 5 || reportOutputFile == 2) && postProcessingModuleId != 0.0 && !Strings.isVoid(blobParamScriptName)) {
                            ByteArrayOutputStream paramContent = new ByteArrayOutputStream();
                            TaggedWriter out1 = new TaggedWriter(paramContent);
                            out1.putString(14, blobParamScriptName);
                            out1.putRaw(10, content.internalBuffer());
                            out1.flush();
                            byte[] res = this.executeServerTask(postProcessingModuleId, task, blobParamScriptName, paramContent.toByteArray());
                            out.putRaw(140, res, res == null ? 0 : res.length);
                        } else {
                            out.putRaw(140, content.internalBuffer(), content.size());
                        }
                        if (reportOutputFile == 1) {
                            for (int i = 0; i <= document.getLastImageId(); ++i) {
                                out.putRaw(141, document.getImageContent(i));
                            }
                        }
                        if (isClientReport) {
                            out.putAnsi(142, document.getServerProfilerInfo());
                        }
                    }
                } else {
                    document.store(out);
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] executeServerTask(double postProcessingModuleId, ReportTask parentTask, String blobParamScriptName, byte[] inputParametersContent) throws Throwable {
        byte[] result = null;
        Context cx = Core.asmoJsContextFactory.enterContext();
        cx.setLanguageVersion(200);
        ConnectionManager dbManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ServerTaskRequest");
        try {
            Node nodeInfo = postProcessingModuleId == 0.0 ? null : MtdEngine.getValidNode(postProcessingModuleId);
            try (ServerTask node = new ServerTask((SSContext)this.ssContext, postProcessingModuleId, this, dbManager, (Task)parentTask);){
                if (nodeInfo != null) {
                    node.load();
                }
                if (inputParametersContent != null) {
                    node.getParameters().loadParametersValues(node.getConstants(), new TaggedReader(inputParametersContent), this);
                }
                node.setParentScope(ScriptableRequest.createTopLevelScope(cx, node, this, dbManager));
                node.executeScript(cx);
                if (node.getOnExecute() == null || node.getOnExecute().length() <= 0) {
                    throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onExecute%s", nodeInfo == null ? "" : " \u0434\u043b\u044f " + nodeInfo.toLogString()));
                }
                ScriptableObject.callMethod(node, node.getOnExecute(), null);
                if (dbManager.hasModifications()) {
                    StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                    if (nodeInfo != null) {
                        message.append(nodeInfo.toLogString());
                    }
                    HashSet<Double> dsIds = new HashSet<Double>();
                    String delimiter = "";
                    for (Row r : dbManager.getModifiedRows()) {
                        dsIds.add(r.getTableDescriptor().getNodeId());
                    }
                    if (dsIds.size() > 1) {
                        message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                    } else {
                        message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                    }
                    for (Double dsId : dsIds) {
                        message.append(String.format("%s%s", delimiter, NumberConverter.doubleToString(dsId)));
                        delimiter = ", ";
                    }
                    throw new InformException(message.toString());
                }
                dbManager.commit();
                for (Parameter p : node.getParameters().values()) {
                    if (!p.getName().equals(blobParamScriptName) || !p.returnValue()) continue;
                    result = p.getBinaryBlob();
                    break;
                }
            }
        }
        finally {
            try {
                ((AbstractConnectionManager)dbManager).release();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            try {
                Context.exit();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
        return result;
    }
}

