/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.ReportBarCode;
import inform.agent.web.reports.controls.ReportDocument;
import inform.agent.web.reports.controls.ReportField;
import inform.agent.web.reports.controls.ReportImage;
import inform.agent.web.reports.controls.ReportLabel;
import inform.agent.web.reports.controls.ReportPageBreak;
import inform.agent.web.reports.controls.ReportParagraph;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.controls.WebControl;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class ReportControlFactory {
    public static final int CT_LINE = 1;
    public static final int CT_LABEL = 9;
    public static final int CT_TABLE = 3;
    public static final int CT_IMAGE = 6;
    public static final int CT_BARCODE = 7;
    public static final int CT_PAGEBREAK = 8;
    public static final int CT_FIELD = 2;
    public static final int CT_PARAMFIELD = 10;
    public static final int CT_DOCUMENT = 11;

    public static WebControl createControl(Task task, Scriptable scope, ComponentHeader header) throws IOException, TaggedReaderException, InformException {
        switch (header.getTypeID()) {
            case 1: {
                return new ReportParagraph(task, scope, header);
            }
            case 9: {
                return new ReportLabel(task, scope, header);
            }
            case 2: {
                return new ReportField(task, scope, header);
            }
            case 10: {
                return new ReportField(task, scope, header);
            }
            case 3: {
                return new ReportTable(task, scope, header);
            }
            case 6: {
                return new ReportImage(task, scope, header);
            }
            case 7: {
                return new ReportBarCode(task, scope, header);
            }
            case 8: {
                return new ReportPageBreak(task, scope, header);
            }
            case 11: {
                return new ReportDocument(task, scope, header);
            }
        }
        return null;
    }
}

