/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.controls.BandItem;
import inform.agent.web.reports.controls.Control;
import inform.agent.web.reports.controls.ReportBand;
import inform.agent.web.reports.controls.ReportControlFactory;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.Font;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportParagraph
extends WebControlContainer<WebControl>
implements BandItem {
    public static final int TAG_WR_LINE_ON_GENERATE = 41;
    public static final int TAG_WR_LINE_OUTPUT_REGION = 42;
    private int outputRegion = 0;
    private int outputRegionPages = 0;
    private String onGenerate = null;
    private final Borders borders = new Borders(null);

    public ReportParagraph(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportParagraph(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof ReportBand);
        return this.createClone(task, (ReportBand)scope);
    }

    public WebControl createClone(Task task, ReportBand band) {
        ReportParagraph paragraph = new ReportParagraph(task, null, task.generateId(), ReportParagraph.cloneName(band, this.getName()));
        paragraph.assignProps(this);
        paragraph.outputRegion = this.outputRegion;
        paragraph.outputRegionPages = this.outputRegionPages;
        paragraph.onGenerate = this.onGenerate;
        paragraph.borders.assignCopy(this.borders);
        return paragraph;
    }

    @Override
    public DocSection generate(Document document, DocSection section) throws Exception {
        if (this.onGenerate != null) {
            return section;
        }
        Datamodel datamodel = new Datamodel();
        this.setupDatamodel(datamodel);
        datamodel.first();
        DocParagraph paragraph = null;
        if (section != null && this.getVisible()) {
            int color = this.getColor();
            Font font = this.getFont();
            if (document.getUseBlackAndWhite()) {
                color = 0x1FFFFFFF;
                font.setColor(0);
            }
            paragraph = section.appendParagraph();
            paragraph.setVisible(this.isVisible());
            paragraph.setFont(font);
            paragraph.setColor(color);
            paragraph.setWidth(this.getWidth());
            paragraph.align(this.align);
            paragraph.marginBottom(this.marginBottom);
            paragraph.marginTop(this.marginTop);
            paragraph.setBorders(this.borders);
        }
        for (WebControl c : this.controls) {
            if (!c.isGenerated() || !(c instanceof Control)) continue;
            ((Control)((Object)c)).generate(document, paragraph);
        }
        if (paragraph != null) {
            paragraph.prepareStore();
        }
        return section;
    }

    public Borders getBorders() {
        return this.borders;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException {
        switch (tag) {
            case 41: {
                this.onGenerate = in.getAnsi();
                break;
            }
            case 42: {
                TaggedReader reader = in.getSubStreamReader();
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            this.outputRegion = reader.getInt();
                            break;
                        }
                        case 2: {
                            this.outputRegionPages = reader.getInt();
                        }
                    }
                }
                reader = null;
                break;
            }
            case 11: {
                this.borders.load(in.getSubStreamReader());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public int getOutputRegion() {
        return this.outputRegion;
    }

    public void setOutputRegion(int outputRegion) {
        this.outputRegion = outputRegion;
    }

    @Override
    public int getOutputRegionPages() {
        return this.outputRegionPages;
    }

    public void setOutputRegionPages(int outputRegionPages) {
        this.outputRegionPages = outputRegionPages;
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append("<p>");
        for (WebControl c : this.controls) {
            c.print(out);
        }
        out.append("</p>");
    }

    @Override
    protected WebControl createElementControl(ComponentHeader header) throws IOException, TaggedReaderException, InformException {
        return ReportControlFactory.createControl(this.task, null, header);
    }

    @Override
    public String getClassName() {
        return "Line";
    }
}

