/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.data.DatamodelCallback;
import inform.agent.web.reports.controls.ReportCell;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.KeySet;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public class ReportRow
extends WebControlContainer<ReportCell>
implements DatamodelCallback {
    private static final int TAG_WEB_TABLE_ROW_DEF_MARGINS = 41;
    private static final int TAG_WEB_TABLE_ROW_ATTACHEDTOROW = 42;
    private static final int TAG_WEB_TABLE_ROW_SUPPRESSION = 43;
    private static final int TAG_WEB_TABLE_ROW_AUTOFILTER = 44;
    private static final int TAG_WEB_TABLE_ROW_HIDE_KIND = 45;
    private static final int TAG_REPORT_ROW_KEY = 81;
    private static final int TAG_REPORT_ROW_TYPE = 82;
    private static final int TAG_REPORT_ROW_ON_AFTERGENERATE = 83;
    private static final int TAG_WEB_LEVEL_KEY = 84;
    final ReportTable table;
    public int rowType = 0;
    public int hide_kind = 0;
    private final Borders borders;
    final TableMargins cellMargins;
    private int attachedToRowId = 0;
    private boolean autoFilter = false;
    private ReportRow unionRow = null;
    private final ArrayList<ReportRow> union = new ArrayList();
    private KeySet groupKey = null;
    private KeySet levelKey = null;
    private String onGetData = null;
    private String onAfterGenerate = null;
    ReportCell[] sourceCells = null;
    private DocRow docRow = null;
    private DocRow gdRow = null;
    private DocRow lastDocRow = null;
    int rowIndex = -1;
    boolean suppress = false;
    private static final int KEY_TYPE_GROUP = 0;
    public static final int ROW_TYPE_DATA = 0;
    public static final int ROW_TYPE_HEADER = 1;
    public static final int rhkNone = 0;
    public static final int rhkExpanded = 1;
    public static final int rhkCollapsed = 2;

    public ReportRow(Task task, ReportTable table, ComponentHeader header) {
        super(task, null, header);
        this.borders = new Borders(null);
        this.cellMargins = new TableMargins(null);
        this.table = table;
    }

    public ReportRow(Task task, ReportTable table, int id, String name) {
        super(task, null, id, name);
        this.borders = new Borders(null);
        this.cellMargins = new TableMargins(null);
        this.table = table;
    }

    public void updateCellMargins(TableMargins margins) {
        margins.updateTop(this.cellMargins.getTop());
        margins.updateBottom(this.cellMargins.getBottom());
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 11: {
                this.borders.load(in.getSubStreamReader());
                break;
            }
            case 12: {
                this.onGetData = in.getAnsi();
                break;
            }
            case 83: {
                this.onAfterGenerate = in.getAnsi();
                break;
            }
            case 41: {
                this.cellMargins.load(in.getSubStreamReader());
                break;
            }
            case 81: {
                int mergeType = in.getInt();
                KeySet set = null;
                switch (mergeType) {
                    case 0: {
                        set = this.groupKey = new KeySet(this.task, null);
                    }
                }
                if (set == null) break;
                set.load(in.getSubStreamReader());
                break;
            }
            case 84: {
                int keyType = in.getInt();
                KeySet levelSet = null;
                switch (keyType) {
                    case 0: {
                        levelSet = this.levelKey = new KeySet(this.task, null);
                    }
                }
                if (levelSet == null) break;
                levelSet.load(in.getSubStreamReader());
                break;
            }
            case 42: {
                this.attachedToRowId = in.getInt();
                break;
            }
            case 44: {
                this.autoFilter = in.getBoolean();
                break;
            }
            case 45: {
                this.hide_kind = in.getInt();
                break;
            }
            case 43: {
                this.suppress = true;
                break;
            }
            case 82: {
                this.rowType = in.getInt();
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        super.afterLoad();
    }

    public boolean isDependent() {
        return this.unionRow != null;
    }

    @Override
    protected ReportCell createElementControl(ComponentHeader header) throws IOException, TaggedReaderException, InformException {
        return new ReportCell(this.task, this, header);
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append("<tr>");
        for (ReportCell c : this.controls) {
            c.print(out);
        }
        out.append("</tr>");
    }

    @Override
    public String getClassName() {
        return "ReportRow";
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    private void attachRow(ReportRow row) throws InformException {
        this.union.add(row);
    }

    @Override
    public void beforeGenerate() {
        this.docRow = null;
        this.lastDocRow = null;
        this.hasBindedData = false;
        for (ReportCell cell : this.controls) {
            if (!cell.isGenerated()) continue;
            cell.beforeGenerate();
            if (!cell.hasBindedData) continue;
            this.hasBindedData = true;
        }
    }

    public void beginGenerate(Document document, DocTable table) throws InformException {
        if (this.unionRow != null) {
            ArrayList<ReportRow> processed = new ArrayList<ReportRow>();
            ReportRow row = this;
            while (row != null) {
                for (ReportRow r : processed) {
                    if (row != r) continue;
                    throw new InformException("\u0426\u0438\u043a\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0441\u0442\u0440\u043e\u043a");
                }
                processed.add(row);
                row = row.unionRow;
            }
            this.unionRow.attachRow(this);
        }
        if (this.isGenerated()) {
            for (ReportCell cell : this.controls) {
                cell.beginGenerate(document, table);
            }
        }
    }

    public void doAfterGenerate(Document document, DocTable docTable, DocRow docRow) {
        if (this.onAfterGenerate == null || this.onAfterGenerate.isEmpty()) {
            return;
        }
    }

    private DocRow generateRows(Document document, DocTable table, int level) throws Exception {
        return null;
    }

    private void generateDataRow(Document document, DocTable table) throws Exception {
        Datamodel datamodel = new Datamodel();
        this.setupDatamodel(datamodel);
        datamodel.enumerate(this);
    }

    public DocRow doGenerate(Document document, DocTable table, int level) throws Exception {
        if (!this.isGenerated()) {
            return null;
        }
        if (this.hasBindedData) {
            this.generateDataRow(document, table);
            return null;
        }
        return this.generateRows(document, table, level);
    }

    public void endGenerate(Document document, DocTable table) {
        for (ReportCell cell : this.controls) {
            cell.endGenerate(document, table);
        }
        this.docRow = null;
    }

    @Override
    public void datamodelStep() throws Exception {
        Document document = this.getDocument();
        DocTable docTable = this.table.docTable;
        this.generateRows(document, docTable, 0);
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        super.setupDatamodel(datamodel);
        for (ReportRow row : this.union) {
            row.setupDatamodel(datamodel);
        }
        if (this.groupKey != null) {
            this.groupKey.setupDatamodel(datamodel);
        }
        if (this.levelKey != null) {
            this.levelKey.setupDatamodel(datamodel);
        }
    }

    public DocRow generate(int level) throws Exception {
        Document document = this.getDocument();
        DocTable docTable = this.table.docTable;
        return this.doGenerate(document, docTable, level);
    }

    public Borders getBorders() {
        return this.borders;
    }

    public TableMargins getMargins() {
        return this.cellMargins;
    }

    public KeySet getGroupKey() {
        if (this.groupKey == null) {
            this.groupKey = new KeySet(this.task, null);
        }
        return this.groupKey;
    }

    public KeySet getLevelKey() {
        if (this.levelKey == null) {
            this.levelKey = new KeySet(this.task, null);
        }
        return this.levelKey;
    }

    public TableMargins getCellMargins() {
        return this.cellMargins;
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) throws InformException {
        assert (scope instanceof ReportTable);
        return this.createRowClone(task, (ReportTable)scope, true);
    }

    public ReportRow createRowClone(Task task, ReportTable table, boolean cloneCell) throws InformException {
        ReportRow row = new ReportRow(task, table, task.generateId(), ReportRow.cloneName(table, this.getName()));
        return row;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public DocRow getDocRow() {
        return this.docRow;
    }

    @Override
    public Font getFont() {
        if (this.gdRow != null) {
            return this.gdRow.getFont();
        }
        return super.getFont();
    }

    @Override
    public int getColor() {
        if (this.gdRow != null) {
            return this.gdRow.getColor();
        }
        return super.getColor();
    }

    @Override
    public void setColor(int color) {
        if (this.gdRow != null) {
            this.gdRow.setColor(color);
        } else {
            super.setColor(color);
        }
    }

    public int getHideKind() {
        return this.hide_kind;
    }

    public void setHideKind(int val) {
        this.hide_kind = val;
    }

    public boolean getAutoFilter() {
        return this.autoFilter;
    }

    public void setAutoFilter(boolean val) {
        this.autoFilter = val;
    }
}

