/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.document.DocColumns;
import inform.agent.web.reports.document.DocTable;

public class DocColumn {
    double redefined_width = -1.0;
    DocColumns columns = null;
    final ReportColumn control;
    final DocTable table;
    private boolean visible = true;
    private boolean grouped = false;
    private boolean suppressBlank = false;
    private boolean suppressedBlank = false;
    private int color = 0x1FFFFFFF;
    int columnIndex = -1;

    public DocColumn(DocTable table, ReportColumn column, boolean grouped, boolean visible, int color, boolean suppressBlank) {
        this.table = table;
        this.control = column;
        this.grouped = grouped;
        this.visible = visible;
        this.color = color;
        this.suppressBlank = suppressBlank;
    }

    public DocColumn(DocTable table) {
        this(table, null, false, true, 0x1FFFFFFF, false);
    }

    public int getIndex() {
        if (this.columns == null) {
            return -1;
        }
        this.columns.update();
        return this.columnIndex;
    }

    public String getClassName() {
        return "Column";
    }

    public boolean isVisible() {
        return this.visible && (this.control == null || this.control.isVisible()) && !this.isSuppressedBlank();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public boolean getSuppressBlank() {
        return this.suppressBlank;
    }

    public void setSuppressBlank(boolean suppressBlank) {
        this.suppressBlank = suppressBlank;
    }

    public boolean isSuppressedBlank() {
        if (!this.suppressBlank) {
            return false;
        }
        return this.suppressedBlank;
    }

    public void setSupressedBlank(boolean suppressedBlank) {
        this.suppressedBlank = suppressedBlank;
    }

    public boolean getSuppressedBlank() {
        return this.suppressedBlank;
    }

    public ReportColumn getControl() {
        return this.control;
    }

    public double getWidth() {
        if (this.redefined_width >= 0.0) {
            return this.redefined_width;
        }
        if (this.control != null) {
            return this.control.getWidth();
        }
        return 0.0;
    }

    public void setWidth(double width) {
        this.redefined_width = width;
    }

    public int getEffectiveColor() {
        if (this.color == 0x1FFFFFFF) {
            return this.table.getEffectiveColor();
        }
        return this.color;
    }
}

