/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.reports.controls.ReportRow;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocElement;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.Type;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.KeyValues;
import inform.agent.web.utils.RowKeyValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class DocRow
extends DocComponent {
    private boolean isEmpty = true;
    private final ReportRow control;
    final DocTable table;
    final ArrayList<DocCell> cells = new ArrayList();
    private final Borders borders;
    final Borders calculatedBorders;
    boolean isBottom = false;
    private RowKeyValues groupKey = null;
    int docRowIndex = -1;
    private boolean suppress = false;
    HashMap<ReportRow, DocRow> attachedRowMap = null;
    HashMap<RowKeyValues, DocRow> gropedRows = null;
    private final RowKeyValues rowKeyValues = new RowKeyValues();
    public int rowType = 0;
    public boolean autoFilter = false;
    public int level = 0;
    public int hide_kind = 0;
    public boolean unbreakable = false;
    public int unbreakableRowCount = 0;
    private boolean isBegin;

    public DocRow(DocTable table, ReportRow control, int rowType, boolean autoFilter) {
        super(table.document);
        this.borders = new Borders(null);
        this.calculatedBorders = new Borders(null);
        this.control = control;
        this.table = table;
        this.rowType = rowType;
        this.autoFilter = autoFilter;
        this.constructCells();
    }

    public DocRow(DocTable table) {
        this(table, null, 0, false);
    }

    public DocRow(DocTable table, boolean useConstructCells) {
        super(table.document);
        this.borders = new Borders(null);
        this.calculatedBorders = new Borders(null);
        this.control = null;
        this.table = table;
        this.rowType = 0;
        this.autoFilter = false;
        if (useConstructCells) {
            this.constructCells();
        }
    }

    public DocTable getTable() {
        return this.table;
    }

    public ArrayList<DocCell> getCells() {
        return this.cells;
    }

    @Override
    public Type getType() {
        return Type.ROW;
    }

    @Override
    public DocElement getParent() {
        return this.table;
    }

    public Borders effectiveBorders() {
        if (this.borders.isInherited() && this.control != null) {
            return this.control.getBorders();
        }
        return this.borders;
    }

    public void setGroupKey(KeyValues groupKey, ReportRow unionRow) {
        if (this.control == null || this.groupKey != null) {
            return;
        }
        this.groupKey = new RowKeyValues(this.control, groupKey);
        if (unionRow != null && unionRow.getDocRow() != null) {
            unionRow.getDocRow().gropedRows.put(this.groupKey, this);
        } else {
            this.table.gropedRows.put(this.groupKey, this);
        }
    }

    public DocRow getGroupRow(ReportRow row, KeyValues groupKey) {
        if (this.gropedRows == null) {
            return this.table.getGroupRow(row, groupKey);
        }
        this.rowKeyValues.set(row, groupKey);
        return this.gropedRows.get(this.rowKeyValues);
    }

    public void beginCalculation(int rowIndex) {
    }

    boolean calculateIsCellGenerated(int colIndex) {
        return false;
    }

    public void calculate(int rowIndex) {
    }

    public void endCalculation(int rowIndex) {
    }

    @Override
    public void prepareStore() {
        super.prepareStore();
        for (DocCell cell : this.cells) {
            cell.prepareStore();
        }
    }

    @Override
    public void finalizeDocument() {
    }

    @Override
    public void store(TaggedWriter out) throws InformException, IOException {
        if (!this.isVisible()) {
            return;
        }
        super.store(out);
        out.putEmpty(39);
        for (DocCell cell : this.cells) {
            if (!cell.isVisible()) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(stream);
            cell.store(writer);
            writer.flush();
            if (stream.size() == 0) continue;
            out.putRaw(40, stream);
        }
    }

    @Override
    public void beforeLoad() throws InformException, IOException {
        super.beforeLoad();
        this.isBegin = false;
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 41: {
                this.height = in.getDouble();
                break;
            }
            case 42: {
                this.rowType = 1;
                break;
            }
            case 43: {
                this.hide_kind = in.getInt();
                break;
            }
            case 44: {
                this.autoFilter = true;
                break;
            }
            case 46: {
                this.level = in.getInt();
                break;
            }
            case 45: {
                this.unbreakable = true;
                break;
            }
            case 47: {
                this.unbreakableRowCount = in.getInt();
                break;
            }
            case 39: {
                this.isBegin = true;
                this.isEmpty = false;
                break;
            }
            case 40: {
                if (!this.isBegin) break;
                DocCell cell = new DocCell(null, this);
                cell.load(in.getStreamReader());
                this.cells.set(cell.getColIdx(), cell);
                this.isBegin = false;
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    public String getClassName() {
        return "ReportRow";
    }

    public int size() {
        return this.cells.size();
    }

    public Object get(int index, Scriptable start) {
        return this.cells.get(index);
    }

    public final void constructCells() {
        if (this.cells.isEmpty()) {
            for (DocColumn column : this.table.columns.values()) {
                this.cells.add(new DocCell(column, this));
            }
        }
    }

    void appendColumn(DocColumn column) {
        DocCell cell = new DocCell(column, this);
        this.cells.add(cell);
    }

    void insertColumn(DocColumn column, DocColumn before) {
        int index = 0;
        for (DocCell cell : this.cells) {
            if (cell.column == before) break;
            ++index;
        }
        if (++index == this.cells.size()) {
            this.appendColumn(column);
        } else {
            DocCell cell = new DocCell(column, this);
            this.cells.add(index, cell);
        }
    }

    public void setGenerated() {
        this.isEmpty = false;
    }

    public boolean isGenerated() {
        return !this.isEmpty;
    }

    public boolean isSuppress() {
        return this.suppress;
    }

    public void setSuppress(boolean suppress) {
        this.suppress = suppress;
    }

    public boolean isSuppressed() {
        return true;
    }

    public void setAttachedRows(ArrayList<ReportRow> attachedRows, int rowType, boolean autoFilter) {
        if (attachedRows == null || attachedRows.isEmpty()) {
            return;
        }
        this.attachedRowMap = new HashMap();
        this.gropedRows = new HashMap();
        int index = -1;
        if (this.control != null) {
            index = this.control.getRowIndex();
        }
        DocRow lastRow = this;
        int lastIndex = index;
        for (ReportRow row : attachedRows) {
            int rowIndex = row.getRowIndex();
            if (lastIndex < index && index < rowIndex) {
                lastRow = this;
                lastIndex = index;
            }
            DocRow docRow = this.table.insertRow(lastRow, row, lastIndex < rowIndex, rowType, autoFilter);
            this.attachedRowMap.put(row, docRow);
            lastRow = docRow;
            lastIndex = rowIndex;
        }
    }

    public DocRow getAttachedRow(ReportRow row) {
        if (this.attachedRowMap != null) {
            return this.attachedRowMap.get(row);
        }
        return null;
    }

    public void updateAttachedRow(ReportRow row, DocRow docRow) {
        if (this.attachedRowMap != null && this.attachedRowMap.containsKey(row)) {
            this.attachedRowMap.put(row, docRow);
        }
    }

    public int getDocRowIndex() {
        return this.docRowIndex;
    }

    public double height() {
        return this.height;
    }

    public void height(double h) {
        this.height = h;
    }

    public ReportRow getControl() {
        return this.control;
    }

    @Override
    public int getEffectiveColor() {
        int color = this.getColor();
        if (color == 0x1FFFFFFF) {
            return this.table.getEffectiveColor();
        }
        return color;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
    }
}

