/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Ini;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.TextOrientation;
import inform.agent.web.utils.VerticalAlign;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.util.Matrix;

public class PdfGenerator
implements WebReportGenerator {
    private final Document _doc;
    private PDDocument _pdf;
    private PDPage _page;
    PDPageContentStream _contentStream = null;
    private final String _caption;
    private PDFont _arial = null;
    private PDFont _arialbd = null;
    private PDFont _arialbi = null;
    private PDFont _ariali = null;
    private PDFont _cour = null;
    private PDFont _courbd = null;
    private PDFont _courbi = null;
    private PDFont _couri = null;
    private PDFont _tahoma = null;
    private PDFont _tahomabd = null;
    private PDFont _times = null;
    private PDFont _timesbd = null;
    private PDFont _timesbi = null;
    private PDFont _timesi = null;
    private PDFont _defaultFont = null;
    private boolean _iniNotFound = false;
    private IniFile _ini = null;
    private int _imageIndex = 1;
    private int _bgImageCount = 0;
    private DocSection _currentSection = null;
    private DocSection _firstSection = null;
    private DocTable _currentTable = null;
    private boolean _sectionStarted = false;
    private boolean _bodyParagStarted = false;
    private boolean _tableStarted = false;
    private boolean _tablePlaceCompletely = false;
    private boolean _tableRowStarted = false;
    private boolean _tableCellStarted = false;
    private int _cellTextOrient = TextOrientation.LEFT_RIGHT.value();
    private boolean _headerStarted = false;
    private boolean _footerStarted = false;
    private ImageItem _headerImage = null;
    private ImageItem _footerImage = null;
    private RowParams _rowParams;
    private ParagraphParams _paragraphParams;
    int _pageNum = 0;
    int _absolutePageNum = 0;
    double _pageHeight = 0.0;
    double _pageWidth = 0.0;
    int _col = 0;
    int _row = 0;
    double _x = 0.0;
    double _y = 0.0;
    int _maxCol = 0;
    int _headerRowsCount = 0;
    double _rowHeight = 0.0;
    ArrayList<Item> _paragraphItems;
    ArrayList<ArrayList<Cell>> _table = new ArrayList();
    ArrayList<ArrayList<Cell>> _header = new ArrayList();
    ArrayList<Boolean> _curPrintPageHeader = null;
    ArrayList<Boolean> _printPageHeader = null;
    ArrayList<ArrayList<LinesGroup>> _outputArray = null;
    private static final double DEFAULT_ROW_HEIGHT = 4.0;
    private static final double LEADING = 0.19;
    private static final int IS_BOTTOM_CELL = 1;
    private static final int IS_TOP_CELL = 2;
    private static final int IS_MIDDLE_CELL = 4;

    public PdfGenerator(Document doc, String caption) throws Exception {
        this._doc = doc;
        this._caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
        this.checkFontIniExists();
    }

    private void checkFontIniExists() {
        this._iniNotFound = true;
        String dirPath = Ini.HomePath + File.separator + "fonts";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        File fontFile = new File(dir, "fonts.ini");
        if (fontFile.exists()) {
            this._iniNotFound = false;
        } else {
            for (String fileName : dir.list()) {
                if (fileName == null || !fileName.endsWith(".ini") || !(fontFile = new File(dir, fileName)).exists()) continue;
                this._iniNotFound = false;
            }
        }
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/pdf");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.pdf\"", this._caption.isEmpty() ? "noname" : this._caption));
    }

    String getFontFileNameFromINI(String fontName, boolean isBold, boolean isItalic) throws Exception {
        if (this._ini == null) {
            this._ini = new IniFile();
        }
        return this._ini.getFontFileNameFromINI(fontName, isBold, isItalic);
    }

    private PDFont getPDFont(Font f) throws Exception {
        PDFont font;
        String fontName = f.getName();
        int fontStyle = f.getStyle();
        boolean isBold = (fontStyle & 1) != 0;
        boolean isItalic = (fontStyle & 2) != 0;
        boolean isArial = false;
        boolean isArialbd = false;
        boolean isArialbi = false;
        boolean isAriali = false;
        boolean isCour = false;
        boolean isCourbd = false;
        boolean isCourbi = false;
        boolean isCouri = false;
        boolean isTahoma = false;
        boolean isTahomabd = false;
        boolean isTimes = false;
        boolean isTimesbd = false;
        boolean isTimesbi = false;
        boolean isTimesi = false;
        if (fontName.equalsIgnoreCase("Arial")) {
            if (isBold && isItalic) {
                font = this._arialbi;
                isArialbi = true;
            } else if (isBold && !isItalic) {
                font = this._arialbd;
                isArialbd = true;
            } else if (!isBold && isItalic) {
                font = this._ariali;
                isAriali = true;
            } else {
                font = this._arial;
                isArial = true;
            }
        } else if (fontName.equalsIgnoreCase("Tahoma")) {
            if (isBold) {
                font = this._tahomabd;
                isTahomabd = true;
            } else {
                font = this._tahoma;
                isTahoma = true;
            }
        } else if (fontName.equalsIgnoreCase("Courier New")) {
            if (isBold && isItalic) {
                font = this._courbi;
                isCourbi = true;
            } else if (isBold && !isItalic) {
                font = this._courbd;
                isCourbd = true;
            } else if (!isBold && isItalic) {
                font = this._couri;
                isCouri = true;
            } else {
                font = this._cour;
                isCour = true;
            }
        } else if (isBold && isItalic) {
            font = this._timesbi;
            isTimesbi = true;
        } else if (isBold && !isItalic) {
            font = this._timesbd;
            isTimesbd = true;
        } else if (!isBold && isItalic) {
            font = this._timesi;
            isTimesi = true;
        } else {
            font = this._times;
            isTimes = true;
        }
        if (font == null) {
            if (this._iniNotFound) {
                if (this._defaultFont != null) {
                    return this._defaultFont;
                }
                try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                    this._defaultFont = PDType0Font.load((PDDocument)this._pdf, (InputStream)in);
                }
                return this._defaultFont;
            }
            String fileName = this.getFontFileNameFromINI(fontName, isBold, isItalic);
            File file = new File(fileName);
            if (!file.exists()) {
                if (this._defaultFont != null) {
                    return this._defaultFont;
                }
                try (InputStream in = this._pdf.getClass().getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");){
                    this._defaultFont = PDType0Font.load((PDDocument)this._pdf, (InputStream)in);
                }
                return this._defaultFont;
            }
            try (FileInputStream fin = new FileInputStream(file);){
                font = PDType0Font.load((PDDocument)this._pdf, (InputStream)fin);
                if (isArial) {
                    this._arial = font;
                }
                if (isArialbd) {
                    this._arialbd = font;
                }
                if (isArialbi) {
                    this._arialbi = font;
                }
                if (isAriali) {
                    this._ariali = font;
                }
                if (isCour) {
                    this._cour = font;
                }
                if (isCourbd) {
                    this._courbd = font;
                }
                if (isCourbi) {
                    this._courbi = font;
                }
                if (isCouri) {
                    this._couri = font;
                }
                if (isTahoma) {
                    this._tahoma = font;
                }
                if (isTahomabd) {
                    this._tahomabd = font;
                }
                if (isTimes) {
                    this._times = font;
                }
                if (isTimesbd) {
                    this._timesbd = font;
                }
                if (isTimesbi) {
                    this._timesbi = font;
                }
                if (isTimesi) {
                    this._timesi = font;
                }
            }
        }
        return font;
    }

    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        this._pdf = new PDDocument();
        Iterator<DocSection> iterator = this._doc.sections().iterator();
        while (iterator.hasNext()) {
            DocSection s;
            this._currentSection = s = iterator.next();
            this.beginSectionHeader();
            if (s.getAllPagesHeader() != null) {
                this.generateComponents(s.getAllPagesHeader().elements());
            }
            this.endSectionHeader();
            this.beginSectionFooter();
            if (s.getAllPagesFooter() != null) {
                this.generateComponents(s.getAllPagesFooter().elements());
            }
            this.endSectionFooter();
        }
        for (DocSection s : this._doc.sections()) {
            this.beginSection(s);
            this.beginSectionBody();
            this.generateComponents(s.elements());
            this.endSectionBody();
            this.endSection();
        }
        this._pdf.save(out);
        this._pdf.close();
    }

    private void addPage() throws Exception {
        if (this._contentStream != null) {
            this._contentStream.close();
            this._contentStream = null;
        }
        this._page = new PDPage(new PDRectangle((float)((int)PdfGenerator.mmTo1_72inch(this._currentSection.getPageWidth())), (float)((int)PdfGenerator.mmTo1_72inch(this._currentSection.getPageHeight()))));
        this._pdf.addPage(this._page);
        PDRectangle vRect = this._page.getMediaBox();
        vRect.setLowerLeftX((float)PdfGenerator.mmTo1_72inch(this._currentSection.margins().getLeft()));
        vRect.setUpperRightX((float)PdfGenerator.mmTo1_72inch(this._currentSection.getPageWidth() - this._currentSection.margins().getRight()));
        vRect.setLowerLeftY((float)PdfGenerator.mmTo1_72inch(this._currentSection.margins().getTop()));
        vRect.setUpperRightY((float)PdfGenerator.mmTo1_72inch(this._currentSection.getPageHeight() - this._currentSection.margins().getBottom()));
        this._contentStream = new PDPageContentStream(this._pdf, this._page);
        this._x = this._currentSection.margins().getLeft();
        ++this._pageNum;
        ++this._absolutePageNum;
        this.printHeaderFooter();
        this.printPageNumber();
    }

    private void printPageNumber() throws Exception {
        double x;
        boolean specialEnum;
        PageNumbers pn = this._firstSection.getPageNumbers();
        if (!pn.enabled && (this._absolutePageNum > 1 || pn.fromFirstPage)) {
            return;
        }
        boolean bl = specialEnum = pn.enumSection >= 0;
        if (specialEnum && pn.enumSection > this._absolutePageNum) {
            return;
        }
        Font font = this._firstSection.getFont();
        this._contentStream.beginText();
        this._contentStream.setFont(this.getPDFont(font), (float)font.getSize());
        String text = String.valueOf(specialEnum ? this._absolutePageNum - pn.enumSection + 1 : this._absolutePageNum);
        double w = (double)(this.getPDFont(font).getStringWidth(text) / 1000.0f * (float)font.getSize()) * 25.4 / 72.0;
        double h = (double)font.getSize() * 25.4 / 72.0;
        double y = pn.location == 0 ? this._currentSection.margins().getTop() / 2.0 + 2.0 : this._currentSection.getPageHeight() - (this._currentSection.margins().getBottom() / 2.0 - h / 2.0) - 1.0;
        switch (pn.align) {
            case 1: {
                x = this._currentSection.getPageWidth() / 2.0 - w / 2.0;
                break;
            }
            case 2: {
                x = this._currentSection.getPageWidth() - this._currentSection.margins().getRight() - w - 7.0;
                break;
            }
            default: {
                x = this._currentSection.margins().getLeft();
            }
        }
        Point2D vPoint = this.getTranslatedCoord(x, y, this._currentSection.getPageHeight());
        this._contentStream.newLineAtOffset((float)vPoint.getX(), (float)vPoint.getY());
        this._contentStream.showText(text);
        this._contentStream.endText();
    }

    private void printHeaderFooter() throws Exception {
        double y;
        double x;
        if (this._headerImage == null && this._footerImage == null) {
            return;
        }
        if (this._headerImage != null) {
            switch (this._headerImage.headerFooterAlign) {
                case 2: {
                    x = this._currentSection.getPageWidth() / 2.0 - this._headerImage.w / 2.0;
                    break;
                }
                case 3: {
                    x = this._currentSection.getPageWidth() - this._headerImage.w;
                    break;
                }
                default: {
                    x = 0.0;
                }
            }
            y = this._headerImage.h;
            this._headerImage.x = x;
            this._headerImage.y = y;
            this._headerImage.paint();
        }
        if (this._footerImage != null) {
            switch (this._footerImage.headerFooterAlign) {
                case 2: {
                    x = this._currentSection.getPageWidth() / 2.0 - this._footerImage.w / 2.0;
                    break;
                }
                case 3: {
                    x = this._currentSection.getPageWidth() - this._footerImage.w;
                    break;
                }
                default: {
                    x = 0.0;
                }
            }
            y = this._currentSection.getPageHeight();
            this._footerImage.x = x;
            this._footerImage.y = y;
            this._footerImage.paint();
        }
    }

    private void beginSection(DocSection section) throws Exception {
        if (this._sectionStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u0430 \u0431\u0435\u0437 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e");
        }
        this._currentSection = section;
        if (this._firstSection == null) {
            this._firstSection = section;
        }
        this._y = 0.0;
        this._pageNum = 0;
        this._pageHeight = section.getPageHeight() - section.margins().getTop() - section.margins().getBottom();
        this._pageWidth = section.getPageWidth() - section.margins().getLeft() - section.margins().getRight();
        this.addPage();
        this._sectionStarted = true;
        this.writeBGImage(section);
    }

    private void beginSectionBody() {
    }

    private void beginSectionFooter() throws Exception {
        this._footerStarted = true;
    }

    private void beginSectionHeader() throws Exception {
        this._headerStarted = true;
    }

    private void endSection() throws Exception {
        if (!this._sectionStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u0430 \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0440\u0430\u0437\u0434\u0435\u043b\u043e\u0432");
        }
        if (this._contentStream != null) {
            this._contentStream.close();
            this._contentStream = null;
        }
        this._sectionStarted = false;
    }

    private void endSectionBody() {
    }

    private void endSectionFooter() throws Exception {
        this._footerStarted = false;
    }

    private void endSectionHeader() throws Exception {
        this._headerStarted = false;
    }

    private void generateComponents(Iterable<? extends DocComponent> components) throws Exception {
        for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    this.generateParagraph((DocParagraph)docComponent);
                    break;
                }
                case TABLE: {
                    this.generateTable((DocTable)docComponent);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
            }
        }
    }

    private void printLinesGroup(LinesGroup linesGroup) throws Exception {
        double mt;
        Point2D vPoint;
        double vX = 0.0;
        double vY = 0.0;
        double sT = this._currentSection.margins().getTop();
        double sY = this._currentSection.getPageHeight();
        double vDeltaY = (double)(linesGroup.pageNum - 1) * this._pageHeight - sT;
        if (!Strings.isVoid(linesGroup.urlLink)) {
            PDAnnotationLink link = new PDAnnotationLink();
            PDActionURI actionURI = new PDActionURI();
            actionURI.setURI(linesGroup.urlLink);
            link.setAction((PDAction)actionURI);
            PDRectangle pdRectangle = new PDRectangle();
            vPoint = this.getTranslatedCoord(linesGroup.left, linesGroup.top - vDeltaY, sY);
            pdRectangle.setLowerLeftX((float)vPoint.getX());
            pdRectangle.setLowerLeftY((float)vPoint.getY());
            vPoint = this.getTranslatedCoord(linesGroup.right, linesGroup.bottom - vDeltaY, sY);
            pdRectangle.setUpperRightX((float)vPoint.getX());
            pdRectangle.setUpperRightY((float)vPoint.getY());
            link.setRectangle(pdRectangle);
            this._page.getAnnotations().add(link);
        }
        if (linesGroup.color != 0x1FFFFFFF) {
            int c = linesGroup.color;
            this._contentStream.setNonStrokingColor(new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF));
            vPoint = this.getTranslatedCoord(linesGroup.left, linesGroup.top - vDeltaY, sY);
            this._contentStream.moveTo((float)vPoint.getX(), (float)vPoint.getY());
            vPoint = this.getTranslatedCoord(linesGroup.left, linesGroup.bottom - vDeltaY, sY);
            this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
            vPoint = this.getTranslatedCoord(linesGroup.right, linesGroup.bottom - vDeltaY, sY);
            this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
            vPoint = this.getTranslatedCoord(linesGroup.right, linesGroup.top - vDeltaY, sY);
            this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
            this._contentStream.closePath();
            this._contentStream.fill();
        }
        this._contentStream.saveGraphicsState();
        vPoint = this.getTranslatedCoord(linesGroup.left, linesGroup.top - vDeltaY + linesGroup.margins.getTop(), sY);
        this._contentStream.moveTo((float)vPoint.getX(), (float)vPoint.getY());
        vPoint = this.getTranslatedCoord(linesGroup.left, linesGroup.bottom - vDeltaY - linesGroup.margins.getBottom(), sY);
        this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
        vPoint = this.getTranslatedCoord(linesGroup.right, linesGroup.bottom - vDeltaY - linesGroup.margins.getBottom(), sY);
        this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
        vPoint = this.getTranslatedCoord(linesGroup.right, linesGroup.top - vDeltaY + linesGroup.margins.getTop(), sY);
        this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
        this._contentStream.closePath();
        this._contentStream.clip();
        double ml = linesGroup.margins != null ? linesGroup.margins.getLeft() : 0.0;
        double mr = linesGroup.margins != null ? linesGroup.margins.getRight() : 0.0;
        double mb = linesGroup.margins != null ? linesGroup.margins.getBottom() : 0.0;
        double d = mt = linesGroup.margins != null ? linesGroup.margins.getTop() : 0.0;
        if (linesGroup.orientation == TextOrientation.LEFT_RIGHT.value()) {
            int i;
            double xEffectiveHeight;
            vY = linesGroup.top + linesGroup.margins.getTop();
            double xRest = xEffectiveHeight = linesGroup.bottom - linesGroup.top - mt - mb;
            int iCount = linesGroup.itemsLines.size();
            for (i = 0; i < iCount; ++i) {
                xRest -= linesGroup.itemsLines.get((int)i).height + linesGroup.itemsLines.get((int)i).textLeading;
            }
            if (xRest < 0.0) {
                xRest = 0.0;
            }
            iCount = linesGroup.itemsLines.size();
            for (i = 0; i < iCount; ++i) {
                ItemsLine ili = linesGroup.itemsLines.get(i);
                double xEffectiveWidth = 0.0;
                switch (HorizontalAlign.create(linesGroup.align)) {
                    case CENTER: {
                        vX = linesGroup.left + ml + (linesGroup.right - mr - linesGroup.left - ml - ili.width) / 2.0;
                        break;
                    }
                    case RIGHT: {
                        vX = linesGroup.right - ili.width - mr;
                        break;
                    }
                    case WIDTH: {
                        vX = linesGroup.left + ml;
                        xEffectiveWidth = PdfGenerator.mmTo1_72inch(linesGroup.right - mr - linesGroup.left - ml);
                        if (i != linesGroup.itemsLines.size() - 1 && ili.items.size() <= 1) break;
                        xEffectiveWidth = 0.0;
                        break;
                    }
                    default: {
                        vX = linesGroup.left + ml;
                    }
                }
                int jCount = ili.items.size();
                for (int j = 0; j < jCount; ++j) {
                    Item it = ili.items.get(j);
                    it.x = vX;
                    it.y = vY + sT - (double)(linesGroup.pageNum - 1) * this._pageHeight;
                    switch (VerticalAlign.create(linesGroup.vertAlign)) {
                        case DEFAULT: 
                        case MIDDLE: {
                            it.y += xRest * 0.5 + it.getHeight();
                            break;
                        }
                        case BOTTOM: {
                            it.y += xRest + it.getHeight() - mb;
                            break;
                        }
                        default: {
                            it.y += it.getHeight();
                        }
                    }
                    if (it.isTextItem && xEffectiveWidth > 0.0) {
                        float nullWidth;
                        TextItem tit = (TextItem)it;
                        PDFont font = this.getPDFont(tit.font);
                        float free = (float)xEffectiveWidth - font.getStringWidth(tit.text) / 1000.0f * (float)tit.font.getSize();
                        if (free > 0.0f && (nullWidth = font.getStringWidth(" ") / 1000.0f * (float)tit.font.getSize()) != 0.0f) {
                            tit.remakeText((int)(free / nullWidth));
                        }
                    }
                    it.paint();
                    vX += it.getWidth();
                }
                vY += ili.height + ili.textLeading;
            }
        } else {
            Item it;
            int j;
            int jCount;
            ItemsLine ili;
            int i;
            int iCount;
            if (linesGroup.orientation == TextOrientation.BOTTOM_TOP.value()) {
                vX = linesGroup.left + ml;
                iCount = linesGroup.itemsLines.size();
                for (i = 0; i < iCount; ++i) {
                    vY = linesGroup.bottom - mb - vDeltaY;
                    ili = linesGroup.itemsLines.get(i);
                    jCount = ili.items.size();
                    for (j = 0; j < jCount; ++j) {
                        it = ili.items.get(j);
                        if (i == 0 && j == 0 && it.isTextItem) {
                            vX += it.getWidth();
                        }
                        it.x = vX;
                        it.y = vY;
                        it.paint();
                        vY -= it.getHeight();
                    }
                    vX += ili.width + ili.textLeading;
                }
            }
            if (linesGroup.orientation == TextOrientation.TOP_BOTTOM.value()) {
                vX = linesGroup.right - mr;
                iCount = linesGroup.itemsLines.size();
                for (i = 0; i < iCount; ++i) {
                    vY = linesGroup.top + mt - vDeltaY;
                    ili = linesGroup.itemsLines.get(i);
                    jCount = ili.items.size();
                    for (j = 0; j < jCount; ++j) {
                        it = ili.items.get(j);
                        if (i == 0 && j == 0 && it.isTextItem) {
                            vX -= it.getWidth();
                        }
                        it.x = vX;
                        it.y = vY;
                        it.paint();
                        vY += it.getHeight();
                    }
                    vX -= ili.width + ili.textLeading;
                }
            }
        }
        this._contentStream.restoreGraphicsState();
        if (DocBorders.top(linesGroup.borders) != 0) {
            this.paintLine(linesGroup.left, linesGroup.top - vDeltaY, linesGroup.right, linesGroup.top - vDeltaY, DocBorders.topStyle(linesGroup.borders), DocBorders.topColor(this._doc, linesGroup.borders));
        }
        if (DocBorders.bottom(linesGroup.borders) != 0) {
            this.paintLine(linesGroup.left, linesGroup.bottom - vDeltaY, linesGroup.right, linesGroup.bottom - vDeltaY, DocBorders.bottomStyle(linesGroup.borders), DocBorders.bottomColor(this._doc, linesGroup.borders));
        }
        if (DocBorders.left(linesGroup.borders) != 0) {
            this.paintLine(linesGroup.left, linesGroup.top - vDeltaY, linesGroup.left, linesGroup.bottom - vDeltaY, DocBorders.leftStyle(linesGroup.borders), DocBorders.leftColor(this._doc, linesGroup.borders));
        }
        if (DocBorders.right(linesGroup.borders) != 0) {
            this.paintLine(linesGroup.right, linesGroup.top - vDeltaY, linesGroup.right, linesGroup.bottom - vDeltaY, DocBorders.rightStyle(linesGroup.borders), DocBorders.rightColor(this._doc, linesGroup.borders));
        }
    }

    private void paintLine(double x1, double y1, double x2, double y2, int style, int color) throws Exception {
        int vDeltaX = 0;
        int vDeltaY = 0;
        switch (style) {
            case 0: {
                return;
            }
            case 1: {
                this._contentStream.setLineWidth(0.15f);
                this._contentStream.setLineDashPattern(new float[]{2.0f, 2.0f}, 0.0f);
                break;
            }
            case 2: {
                this._contentStream.setLineWidth(0.15f);
                this._contentStream.setLineDashPattern(new float[0], 0.0f);
                break;
            }
            case 3: {
                this._contentStream.setLineWidth(1.0f);
                this._contentStream.setLineDashPattern(new float[0], 0.0f);
                break;
            }
            case 4: {
                this._contentStream.setLineWidth(2.0f);
                this._contentStream.setLineDashPattern(new float[0], 0.0f);
                break;
            }
            case 5: {
                this._contentStream.setLineWidth(0.15f);
                this._contentStream.setLineDashPattern(new float[0], 0.0f);
                if (x1 == x2) {
                    vDeltaX = -1;
                }
                if (y1 == y2) {
                    vDeltaY = -1;
                }
                for (int i = 1; i <= 3; ++i) {
                    int c = i == 2 ? 0x1FFFFFFF : color;
                    this._contentStream.setStrokingColor(new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF));
                    Point2D vPoint = this.getTranslatedCoord(x1, y1, this._currentSection.getPageHeight());
                    this._contentStream.moveTo((float)(vPoint.getX() + (double)vDeltaX), (float)(vPoint.getY() + (double)vDeltaY));
                    vPoint = this.getTranslatedCoord(x2, y2, this._currentSection.getPageHeight());
                    this._contentStream.lineTo((float)(vPoint.getX() + (double)vDeltaX), (float)(vPoint.getY() + (double)vDeltaY));
                    this._contentStream.closeAndStroke();
                    if (x1 == x2) {
                        ++vDeltaX;
                    }
                    if (y1 != y2) continue;
                    ++vDeltaY;
                }
                return;
            }
        }
        int c = color;
        this._contentStream.setStrokingColor(new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF));
        Point2D vPoint = this.getTranslatedCoord(x1, y1, this._currentSection.getPageHeight());
        this._contentStream.moveTo((float)vPoint.getX(), (float)vPoint.getY());
        vPoint = this.getTranslatedCoord(x2, y2, this._currentSection.getPageHeight());
        this._contentStream.lineTo((float)vPoint.getX(), (float)vPoint.getY());
        this._contentStream.closeAndStroke();
    }

    private void beginParagraph(DocParagraph p) throws Exception {
        if (this._headerStarted || this._footerStarted) {
            this._paragraphParams = new ParagraphParams(p);
            return;
        }
        if (this._bodyParagStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0431\u0435\u0437 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e");
        }
        if (this._y > (double)this._pageNum * this._pageHeight) {
            this.addPage();
        }
        this._x = this._currentSection.margins().getLeft();
        this._paragraphItems = new ArrayList();
        this._paragraphParams = new ParagraphParams(p);
        this._bodyParagStarted = true;
    }

    private void endParagraph() throws Exception {
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        if (!this._bodyParagStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u043e\u0432");
        }
        double vParMarginsLeft = this._paragraphParams.leftMargin;
        double vParMarginsRight = this._paragraphParams.rightMargin;
        double vParMarginsTop = this._paragraphParams.topMargin;
        double vParMarginsBottom = this._paragraphParams.bottomMargin;
        double vParHeaderHeight = 0.0;
        this._curPrintPageHeader = null;
        if (this.isNeedStartNewPage(this._paragraphItems, this._x, this._x + this._pageWidth, this._y, vParMarginsLeft, vParMarginsRight, vParMarginsTop, vParMarginsBottom, this._pageNum, 0.0)) {
            this._y = (double)this._pageNum * this._pageHeight;
            this.addPage();
        }
        ArrayList<LinesGroup> vLinesGroups = this.makeLinesGroups(this._paragraphItems, this._x, this._x + this._pageWidth, this._y, vParMarginsLeft, vParMarginsRight, vParMarginsTop, vParMarginsBottom, vParHeaderHeight, this._pageNum, 0.0, 0);
        for (int i = 0; i < vLinesGroups.size(); ++i) {
            LinesGroup buff = vLinesGroups.get(i);
            buff.borders = this._paragraphParams.borders;
            buff.align = this._paragraphParams.align;
            buff.vertAlign = this._paragraphParams.vAlign;
            buff.color = this._paragraphParams.color;
            this.printLinesGroup(buff);
            if (i == vLinesGroups.size() - 1) continue;
            this.addPage();
        }
        if (this._y > (double)this._pageNum * this._pageHeight) {
            this._y = (double)this._pageNum * this._pageHeight;
        }
        this._bodyParagStarted = false;
    }

    private boolean isNeedStartNewPage(ArrayList<Item> items, double xMin, double xMax, double y, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int pageNum, double startHeight) throws Exception {
        double vCurWidth = 0.0;
        double vAriaWidth = xMax - xMin - leftMargin - rightMargin;
        double vMaxHeight = 0.0;
        double vTextMargin = 0.0;
        double xRowHeight = 0.0;
        double xTextMargin = 0.0;
        int i = 0;
        while (items != null && i < items.size()) {
            Item item = items.get(i);
            if (vCurWidth + item.getWidth() <= vAriaWidth) {
                vCurWidth += item.getWidth();
                if (vMaxHeight < item.getHeight()) {
                    vMaxHeight = item.getHeight();
                }
                if (item.isTextItem && vTextMargin < item.getHeight() * 0.19) {
                    vTextMargin = item.getHeight() * 0.19;
                }
                if (++i != items.size() && (!item.isTextItem || !item.lastInLine)) continue;
                xRowHeight += vMaxHeight;
                xTextMargin += vTextMargin;
                if (!item.isTextItem || !item.lastInLine) continue;
                vCurWidth = 0.0;
                continue;
            }
            vCurWidth = 0.0;
            if (item.isTextItem) {
                String xText = ((TextItem)item).split(vAriaWidth - vCurWidth, vAriaWidth);
                if (!xText.isEmpty()) {
                    TextItem vTmpItem = new TextItem();
                    vTmpItem.assign((TextItem)item);
                    vTmpItem.text = xText;
                    item.lastInLine = true;
                    items.add(i + 1, vTmpItem);
                    if (item.getHeight() > vMaxHeight) {
                        vMaxHeight = item.getHeight();
                    }
                    if (vTextMargin < item.getHeight() * 0.19) {
                        vTextMargin = item.getHeight() * 0.19;
                    }
                    xRowHeight += vMaxHeight;
                    xTextMargin += vTextMargin;
                }
            } else if (i == 0) {
                xRowHeight = vMaxHeight = item.getHeight();
                xTextMargin = 0.0;
                break;
            }
            ++i;
        }
        this._rowHeight = xRowHeight + xTextMargin;
        if (this._rowHeight < startHeight) {
            this._rowHeight = startHeight;
        }
        if (this._rowHeight + topMargin + bottomMargin >= this._pageHeight) {
            return y + this._pageHeight > (double)pageNum * this._pageHeight;
        }
        return y + this._rowHeight + topMargin + bottomMargin > (double)pageNum * this._pageHeight;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<LinesGroup> makeLinesGroups(ArrayList<Item> items, double xMin, double xMax, double y, double leftMargin, double rightMargin, double topMargin, double bottomMargin, double headerHeight, int pageNum, double rowHeight, int textOrient) throws Exception {
        xAriaWidth = xMax - xMin - leftMargin - rightMargin;
        xY = y;
        xPageNum = pageNum;
        xLinesGroups = new ArrayList<LinesGroup>();
        xLinesGroups.add(new LinesGroup());
        if (this._curPrintPageHeader == null || this._curPrintPageHeader.isEmpty()) {
            this._curPrintPageHeader = new ArrayList<E>();
            this._curPrintPageHeader.add(headerHeight != 0.0);
        }
        if (this._curPrintPageHeader.get(0).booleanValue() && xY == (double)(xPageNum - 1) * this._pageHeight) {
            if (textOrient == TextOrientation.LEFT_RIGHT.value()) {
                if (this.isNeedStartNewPage(items, xMin, xMax, xY + headerHeight, leftMargin, rightMargin, topMargin, bottomMargin, xPageNum, 0.0)) {
                    this._curPrintPageHeader.set(0, false);
                } else {
                    xY += headerHeight;
                }
            } else if (rowHeight >= this._pageHeight ? xY + headerHeight + this._pageHeight > (double)pageNum * this._pageHeight : xY + headerHeight + rowHeight > (double)pageNum * this._pageHeight) {
                this._curPrintPageHeader.set(0, false);
            } else {
                xY += headerHeight;
            }
        }
        lgrh = (LinesGroup)xLinesGroups.get(0);
        lgrh.top = xY;
        lgrh.bottom = (double)xPageNum * this._pageHeight;
        lgrh.height = topMargin + bottomMargin;
        lgrh.left = xMin;
        lgrh.right = xMax;
        lgrh.itemsLines.clear();
        lgrh.margins.setLeft(leftMargin);
        lgrh.margins.setRight(rightMargin);
        lgrh.margins.setTop(topMargin);
        lgrh.margins.setBottom(bottomMargin);
        lgrh.pageNum = xPageNum;
        xY += lgrh.height;
        isHeight = false;
        i = 0;
        while (i < items.size()) {
            block40: {
                block41: {
                    xFakeCurWidth = 0.0;
                    xCurWidth = 0.0;
                    xCurHeight = 0.0;
                    j = i;
                    xTextMargin = 0.0;
                    if (textOrient != TextOrientation.LEFT_RIGHT.value()) break block41;
                    while (i < items.size() && xFakeCurWidth <= xAriaWidth) {
                        block42: {
                            block43: {
                                item = items.get(i);
                                if (i < items.size() - 1 && items.get((int)(i + 1)).isLineBreakElement) {
                                    xFakeCurWidth = xAriaWidth - item.getWidth();
                                }
                                if (!(xFakeCurWidth + item.getWidth() > xAriaWidth)) break block42;
                                if (!item.isTextItem) break block43;
                                textItem = (TextItem)item;
                                xTmpText = textItem.split(xAriaWidth - xFakeCurWidth, xAriaWidth);
                                if (xTmpText.isEmpty()) ** GOTO lbl63
                                if (textItem.text.isEmpty()) {
                                    textItem.text = xTmpText;
                                } else {
                                    textItem.lastInLine = true;
                                    xTmpTextItem = new TextItem();
                                    xTmpTextItem.assign(textItem);
                                    xTmpTextItem.text = xTmpText;
                                    items.add(i + 1, xTmpTextItem);
lbl63:
                                    // 2 sources

                                    xFakeCurWidth += item.getWidth();
                                    if (xCurHeight < item.getHeight()) {
                                        xCurHeight = item.getHeight();
                                    }
                                    if (xTextMargin < 0.19 * item.getHeight()) {
                                        xTextMargin = 0.19 * item.getHeight();
                                    }
                                    ++i;
                                }
                                break block40;
                            }
                            if (xFakeCurWidth != 0.0) break block40;
                        }
                        xFakeCurWidth += item.getWidth();
                        xCurWidth += item.getWidth();
                        if (xCurHeight < item.getHeight()) {
                            xCurHeight = item.getHeight();
                        }
                        if (item.isTextItem && xTextMargin < 0.19 * item.getHeight()) {
                            xTextMargin = 0.19 * item.getHeight();
                        }
                        ++i;
                        if (!item.lastInLine) continue;
                        item.lastInLine = false;
                        break block40;
                    }
                    break block40;
                }
                while (i < items.size() && xCurHeight <= rowHeight) {
                    block44: {
                        block45: {
                            item = items.get(i);
                            if (!(xCurHeight + item.getHeight() > rowHeight)) break block44;
                            if (!item.isTextItem) break block45;
                            textItem = (TextItem)item;
                            xTmpText = textItem.split(rowHeight - xCurHeight, rowHeight);
                            if (xTmpText.isEmpty()) ** GOTO lbl100
                            if (textItem.text.isEmpty()) {
                                textItem.text = xTmpText;
                            } else {
                                textItem.lastInLine = true;
                                xTmpTextItem = new TextItem();
                                xTmpTextItem.assign(textItem);
                                xTmpTextItem.text = xTmpText;
                                items.add(i + 1, xTmpTextItem);
lbl100:
                                // 2 sources

                                xCurHeight += item.getHeight();
                                if (xFakeCurWidth < item.getWidth()) {
                                    xFakeCurWidth = item.getWidth();
                                }
                                xCurWidth = xFakeCurWidth;
                                ++i;
                            }
                            break;
                        }
                        if (xCurHeight != 0.0) break block40;
                    }
                    xCurHeight += item.getHeight();
                    if (xFakeCurWidth < item.getWidth()) {
                        xFakeCurWidth = item.getWidth();
                    }
                    xCurWidth = xFakeCurWidth;
                    ++i;
                    if (!item.lastInLine) continue;
                    item.lastInLine = false;
                    break;
                }
            }
            if (xCurHeight + topMargin + bottomMargin + xTextMargin > this._pageHeight) {
                xCurHeight = this._pageHeight - topMargin - bottomMargin - xTextMargin;
            }
            if (xFakeCurWidth > xAriaWidth) {
                xFakeCurWidth = xAriaWidth;
            }
            if (xCurWidth > xAriaWidth) {
                xCurWidth = xAriaWidth;
            }
            lgrh = xLinesGroups.get(xLinesGroups.size() - 1);
            if (xY + xCurHeight + xTextMargin > lgrh.bottom) {
                if (xY > lgrh.bottom) {
                    throw new InformException("\u042f\u0447\u0435\u0439\u043a\u0430 \u043d\u0435 \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u043b\u0430\u0441\u044c \u043d\u0430 \u043d\u043e\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443");
                }
                xY = (double)xPageNum * this._pageHeight;
                xLinesGroups.add(new LinesGroup());
                lgrh = xLinesGroups.get(xLinesGroups.size() - 1);
                ++xPageNum;
                while (this._curPrintPageHeader.size() - 1 < xPageNum - this._pageNum) {
                    this._curPrintPageHeader.add(headerHeight != 0.0);
                }
                if (this._curPrintPageHeader.get(xPageNum - this._pageNum).booleanValue()) {
                    if (textOrient == TextOrientation.LEFT_RIGHT.value()) {
                        if (this.isNeedStartNewPage(items, this._x, this._x + this._pageWidth, xY + headerHeight, leftMargin, rightMargin, topMargin, bottomMargin, xPageNum, 0.0)) {
                            this._curPrintPageHeader.set(xPageNum - this._pageNum, false);
                        } else {
                            xY += headerHeight;
                        }
                    } else if (rowHeight >= this._pageHeight ? xY + headerHeight + this._pageHeight > (double)pageNum * this._pageHeight : xY + headerHeight + rowHeight > (double)pageNum * this._pageHeight) {
                        this._curPrintPageHeader.set(xPageNum - this._pageNum, false);
                    } else {
                        xY += headerHeight;
                    }
                }
                lgrh.top = xY;
                lgrh.bottom = (double)xPageNum * this._pageHeight;
                lgrh.height = topMargin + bottomMargin;
                lgrh.left = xMin;
                lgrh.right = xMax;
                lgrh.margins.setLeft(leftMargin);
                lgrh.margins.setRight(rightMargin);
                lgrh.margins.setTop(topMargin);
                lgrh.margins.setBottom(bottomMargin);
                lgrh.itemsLines.clear();
                lgrh.pageNum = xPageNum;
                xY += lgrh.height;
            }
            xY += xCurHeight + xTextMargin;
            lgrh.height += xCurHeight + xTextMargin;
            lgrh.itemsLines.add(new ItemsLine());
            itl = lgrh.itemsLines.get(lgrh.itemsLines.size() - 1);
            itl.height = xCurHeight;
            itl.textLeading = xTextMargin;
            itl.width = Math.min(xFakeCurWidth, xCurWidth);
            itl.items.clear();
            for (k = j; k <= i - 1; ++k) {
                itl.items.add(items.get(k));
            }
            if (xFakeCurWidth <= 0.0) {
                ++i;
            }
            isHeight = true;
        }
        if (this._tableStarted && rowHeight != 0.0) {
            if (lgrh.height < rowHeight) {
                lgrh.height = rowHeight;
            }
            isHeight = true;
        }
        if (!isHeight) {
            lgrh.height = 4.0;
        }
        lgrh.orientation = textOrient;
        this._y = lgrh.bottom = lgrh.top + lgrh.height;
        return xLinesGroups;
    }

    private void writeTextEx(DocText text) throws Exception {
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        Pattern pattern = Pattern.compile("(?:(?:https?|ftp):\\/\\/)[\\w\\/\\-?=%.]+\\.[\\w\\/\\-&?=%.]+", 10);
        Matcher matcher = pattern.matcher(text.getText());
        int prev = 0;
        boolean isMatch = false;
        String source = text.getText();
        while (matcher.find()) {
            int idx = matcher.start();
            int len = matcher.end() - matcher.start();
            String buff = source.substring(prev, idx);
            prev = idx + len;
            if (buff.length() > 0) {
                this.writeText(text, buff, "");
            }
            buff = source.substring(matcher.start(), matcher.end());
            this.writeText(text, buff, buff);
            isMatch = true;
        }
        if (isMatch) {
            if (prev < source.length()) {
                this.writeText(text, source.substring(prev), "");
            }
            return;
        }
        this.writeText(text, text.getText(), text.getUrlLink());
    }

    private void writeText(DocText text, String textSource, String textUrl) throws Exception {
        String[] words;
        if (!this._paragraphItems.isEmpty()) {
            Item item = this._paragraphItems.get(this._paragraphItems.size() - 1);
            if (item.isTextItem) {
                ((TextItem)item).lastInLine = false;
            }
        }
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        boolean xLineBreak = false;
        String source = textSource.replaceAll("\\r|\\t", "");
        for (String word : words = source.split("\\n|\\r\\n")) {
            TextItem item = new TextItem();
            if (this._tableCellStarted) {
                item.textOrient = this._cellTextOrient;
            }
            item.urlLink = textUrl;
            item.font.assign(text.getFont());
            item.bgColor = text.getColor();
            item.text = word;
            if (this._tableStarted) {
                item.wordWrap = this._table.get((int)this._row).get((int)(this._col - 1)).cellParams.wordWrap;
            }
            item.lastInLine = true;
            item.isLineBreakElement = xLineBreak;
            xLineBreak = true;
            this._paragraphItems.add(item);
        }
    }

    private void writeBGImage(DocSection section) throws Exception {
        if (section.getBGImageID() == 0.0 || section.getBGImageContent().length == 0) {
            return;
        }
        ++this._bgImageCount;
        if (this._bgImageCount > 1 && section.getBGOnlyFirstPage()) {
            return;
        }
        double x = section.getBGLeft();
        double y = section.getBGTop();
        double h = section.getBGHeight();
        double w = section.getBGWidth();
        if (w == 0.0) {
            return;
        }
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)this._pdf, (byte[])section.getBGImageContent(), (String)("img" + this._imageIndex++));
        if (h == 0.0) {
            double imgH = pdImage.getHeight();
            double imgW = pdImage.getWidth();
            if (imgH == 0.0 || imgW == 0.0) {
                return;
            }
            h = imgH / imgW * w;
        }
        Point2D point = this.getTranslatedCoord(x, y + h, section.getPageHeight());
        this._contentStream.drawImage(pdImage, (float)point.getX(), (float)point.getY(), (float)PdfGenerator.mmTo1_72inch(w), (float)PdfGenerator.mmTo1_72inch(h));
    }

    private void insertPicture(DocImage im) throws Exception {
        double pageWidth;
        if (this._headerStarted && this._headerImage != null || this._footerStarted && this._footerImage != null) {
            return;
        }
        if (im == null) {
            return;
        }
        byte[] imageContent = im.getImageContent();
        if (imageContent == null || imageContent.length == 0) {
            return;
        }
        if (im.getHeight() == 0.0 || im.getWidth() == 0.0) {
            return;
        }
        ImageItem item = new ImageItem();
        item.h = im.getHeight();
        item.w = im.getWidth();
        item.urlLink = im.getUrlLink();
        double pageHeight = this._headerStarted || this._footerStarted ? this._currentSection.getPageHeight() : this._pageHeight;
        double d = pageWidth = this._headerStarted || this._footerStarted ? this._currentSection.getPageWidth() : this._pageWidth;
        if (pageHeight > pageWidth && item.w > pageWidth) {
            item.h *= pageWidth / item.w;
            item.w = pageWidth;
        } else if (pageHeight <= pageWidth && item.h > pageHeight) {
            item.w *= pageHeight / item.h;
            item.h = pageHeight;
        }
        item.pdImage = PDImageXObject.createFromByteArray((PDDocument)this._pdf, (byte[])imageContent, (String)("img" + this._imageIndex++));
        if (!this._headerStarted && !this._footerStarted) {
            this._paragraphItems.add(item);
        } else {
            item.headerFooterAlign = this._paragraphParams.align;
            if (this._headerStarted) {
                this._headerImage = item;
            }
            if (this._footerStarted) {
                this._footerImage = item;
            }
        }
    }

    private void generateParagraph(DocParagraph p) throws Exception {
        this.beginParagraph(p);
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    this.writeTextEx((DocText)cm);
                    break;
                }
                case IMAGE: {
                    this.insertPicture((DocImage)cm);
                }
            }
        }
        this.endParagraph();
    }

    private void generateTable(DocTable table) throws Exception {
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        this.beginTable(table);
        for (DocRow row : table.rows()) {
            this.beginRow(row);
            for (DocCell cell : row.getCells()) {
                if (cell.getColIdx() == -1) continue;
                this.beginCell(cell);
                for (DocComponent cm : cell.components()) {
                    switch (cm.getType()) {
                        case PARAGRAPH: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TABLE: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TEXT: {
                            this.writeTextEx((DocText)cm);
                            break;
                        }
                        case IMAGE: {
                            this.insertPicture((DocImage)cm);
                        }
                    }
                }
                this.endCell();
            }
            this.endRow();
        }
        this.endTable();
    }

    private void beginTable(DocTable table) throws Exception {
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        if (!this._sectionStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0440\u0430\u0437\u0434\u0435\u043b\u043e\u0432");
        }
        if (this._bodyParagStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
        }
        if (this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        this._row = 0;
        this._maxCol = 0;
        double w = table.getTableWidth();
        switch (table.align()) {
            case CENTER: {
                this._x = (this._currentSection.getPageWidth() - w) / 2.0;
                break;
            }
            case RIGHT: {
                this._x = this._currentSection.getPageWidth() - this._currentSection.margins().getRight() - w;
                break;
            }
            default: {
                this._x = this._currentSection.margins().getLeft();
            }
        }
        if (this._y >= (double)this._pageNum * this._pageHeight) {
            this.addPage();
        }
        this._table.add(new ArrayList());
        this._header.add(new ArrayList());
        this._headerRowsCount = 0;
        this._maxCol = 0;
        this._currentTable = table;
        this._tableStarted = true;
        this._tablePlaceCompletely = table.place_completely;
    }

    private void endTable() throws Exception {
        if (this._headerStarted || this._footerStarted) {
            return;
        }
        if (this._tableRowStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0442\u0440\u043e\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        if (this._tableCellStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u044f\u0447\u0435\u0439\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        if (!this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        }
        this._outputArray = new ArrayList();
        int vPageNum = this._pageNum;
        this._printPageHeader = new ArrayList();
        this._printPageHeader.clear();
        double vHeaderHeight = this.makeTable(this._header, 0.0, 1, this._headerRowsCount, 0.0);
        if (vHeaderHeight >= this._pageHeight) {
            vHeaderHeight = 0.0;
        }
        this._printPageHeader.clear();
        this._y = this.makeTable(this._table, this._y, vPageNum, this._headerRowsCount, vHeaderHeight);
        this.makeOutputArray();
        int hoa = this._outputArray.size() - 1;
        if (vHeaderHeight != 0.0) {
            int m = this._headerRowsCount + 1;
            while (m < this._header.size()) {
                this._header.remove(m);
            }
            for (int p = this._header.size(); p < m; ++p) {
                this._header.add(new ArrayList());
            }
            for (int l = 1; l <= hoa; ++l) {
                if (l >= this._printPageHeader.size() || !this._printPageHeader.get(l).booleanValue()) continue;
                for (int i = 1; i <= this._headerRowsCount; ++i) {
                    int cc = this._header.get(i).size();
                    for (int j = 0; j < cc; ++j) {
                        Cell c = this._header.get(i).get(j);
                        if ((c.cellProperties & 2) == 0) continue;
                        int lgc = c.linesGroups.size();
                        for (int k = 0; k < lgc; ++k) {
                            LinesGroup vLinesGroup = c.linesGroups.get(k).clone();
                            vLinesGroup.bottom += (double)(l - 1) * this._pageHeight;
                            vLinesGroup.top += (double)(l - 1) * this._pageHeight;
                            vLinesGroup.pageNum = l;
                            this._outputArray.get(l).add(vLinesGroup);
                        }
                    }
                }
            }
        }
        for (int i = this._pageNum; i <= hoa; ++i) {
            int jCount = this._outputArray.get(i).size();
            for (int j = 0; j < jCount; ++j) {
                if (this._outputArray.get(i) == null || this._outputArray.get(i).get(j) == null) continue;
                this.printLinesGroup(this._outputArray.get(i).get(j));
            }
            if (i == hoa) continue;
            this.addPage();
        }
        this._pageNum = Math.max(hoa, vPageNum);
        this._y += this._currentTable.bottomMargin();
        if (this._y > (double)this._pageNum * this._pageHeight) {
            this._y = (double)this._pageNum * this._pageHeight;
        }
        this._table.clear();
        this._header.clear();
        this._tableStarted = false;
        this._tablePlaceCompletely = false;
    }

    private double makeTable(ArrayList<ArrayList<Cell>> table, double y, int pageNum, int headerLinesCount, double headerRowsHeight) throws Exception {
        boolean vNewPage;
        double vCurRowTop;
        double vY = y;
        int count = table.get(0).size();
        for (int j = 0; j < count; ++j) {
            Cell buffCell = table.get(0).get(j);
            buffCell.bottom = vY;
            buffCell.pageNum = pageNum;
        }
        double[] vCurTableHeight = new double[table.size()];
        vCurTableHeight[0] = vY;
        boolean vNewLoop = false;
        int i = 1;
        double result = y;
        if (this._tablePlaceCompletely) {
            vCurRowTop = vCurTableHeight[0];
            double xSumRowHeight = 0.0;
            int xMaxRowCount = table.size() - 1;
            boolean xIsBreak = false;
            for (int r = 1; r <= xMaxRowCount; ++r) {
                double xMaxRowHeight = 0.0;
                int cc = table.get(r).size();
                for (int c = 0; c < cc; ++c) {
                    Cell cell = table.get(r).get(c);
                    cell.pageNum = table.get((int)(r - 1)).get((int)c).pageNum;
                    if (cell.cellParams == null) continue;
                    this._rowHeight = 0.0;
                    vNewPage = this.isNeedStartNewPage(cell.items, cell.left, cell.right, vCurRowTop + xSumRowHeight, cell.cellParams.margins.getLeft(), cell.cellParams.margins.getRight(), cell.cellParams.margins.getTop(), cell.cellParams.margins.getBottom(), cell.pageNum, cell.height);
                    if (vNewPage) {
                        vCurTableHeight[0] = vCurRowTop = (double)cell.pageNum * this._pageHeight;
                        int jc = table.get(0).size();
                        for (int j = 0; j < jc; ++j) {
                            ++table.get((int)0).get((int)j).pageNum;
                        }
                        xIsBreak = true;
                        break;
                    }
                    if (!(xMaxRowHeight < this._rowHeight)) continue;
                    xMaxRowHeight = this._rowHeight;
                }
                xSumRowHeight += xMaxRowHeight;
                if (xIsBreak) break;
            }
        }
        while (i < table.size()) {
            int p;
            int vOldHigh;
            int j;
            int j2;
            double vHeaderRowsHeight = i <= headerLinesCount ? 0.0 : headerRowsHeight;
            vCurTableHeight[i] = vCurTableHeight[i - 1];
            vCurRowTop = vCurTableHeight[i - 1];
            int vMaxPageNum = 0;
            boolean xIsUnbreakable = false;
            int cc = table.get(i).size();
            for (int c = 0; c < cc; ++c) {
                if (!table.get((int)i).get((int)c).isUnbreakable && table.get((int)i).get((int)c).unbreakableRowCount <= 0) continue;
                xIsUnbreakable = true;
                break;
            }
            if (xIsUnbreakable) {
                double xSumRowHeight = 0.0;
                int xMaxRowCount = 1;
                int count2 = table.get(i).size();
                for (int c = 0; c < count2; ++c) {
                    Cell cell = table.get(i).get(c);
                    if (cell.cellParams == null) continue;
                    if (xMaxRowCount < cell.cellParams.rowSpan) {
                        xMaxRowCount = cell.cellParams.rowSpan;
                    }
                    if (xMaxRowCount >= cell.unbreakableRowCount) continue;
                    xMaxRowCount = cell.unbreakableRowCount;
                }
                boolean xIsBreak = false;
                int rc = i + xMaxRowCount;
                for (int r = i; r < rc; ++r) {
                    double xMaxRowHeight = 0.0;
                    int cc2 = table.get(r).size();
                    for (int c = 0; c < cc2; ++c) {
                        Cell cell = table.get(r).get(c);
                        cell.pageNum = table.get((int)(r - 1)).get((int)c).pageNum;
                        if (cell.cellParams == null) continue;
                        this._rowHeight = 0.0;
                        vNewPage = this.isNeedStartNewPage(cell.items, cell.left, cell.right, vCurRowTop + xSumRowHeight, cell.cellParams.margins.getLeft(), cell.cellParams.margins.getRight(), cell.cellParams.margins.getTop(), cell.cellParams.margins.getBottom(), cell.pageNum, cell.height);
                        if (vNewPage) {
                            vCurRowTop = (double)cell.pageNum * this._pageHeight;
                            xIsBreak = true;
                            break;
                        }
                        if (!(xMaxRowHeight < this._rowHeight)) continue;
                        xMaxRowHeight = this._rowHeight;
                    }
                    xSumRowHeight += xMaxRowHeight;
                    if (xIsBreak) break;
                }
            }
            vNewPage = false;
            int count3 = table.get(i).size();
            for (int j3 = 0; j3 < count3; ++j3) {
                Cell c = table.get(i).get(j3);
                if ((c.cellProperties & 2) == 0) continue;
                c.pageNum = table.get((int)(i - 1)).get((int)j3).pageNum;
                if (c.cellParams.textOrientation == TextOrientation.LEFT_RIGHT.value()) {
                    vNewPage = this.isNeedStartNewPage(c.items, c.left, c.right, vCurRowTop, c.cellParams.margins.getLeft(), c.cellParams.margins.getRight(), c.cellParams.margins.getTop(), c.cellParams.margins.getBottom(), c.pageNum, c.height);
                } else {
                    boolean bl = c.height >= this._pageHeight ? vCurRowTop + this._pageHeight > (double)c.pageNum * this._pageHeight : (vNewPage = vCurRowTop + c.height > (double)c.pageNum * this._pageHeight);
                }
                if (!vNewPage) continue;
                vCurRowTop = (double)c.pageNum * this._pageHeight;
            }
            int k = table.get(i - 1).size();
            if (vNewPage && i > 1) {
                ArrayList<Cell> tim1 = table.get(i - 1);
                int count4 = tim1.size();
                for (j2 = 0; j2 < count4; ++j2) {
                    Cell c = tim1.get(j2);
                    if ((c.cellProperties & 1) == 0) continue;
                    k -= table.get((int)c.topRowNum).get((int)j2).cellParams.colSpan;
                }
            }
            if (k > 0 && k < table.get(i - 1).size()) {
                ArrayList<Cell> tim1 = table.get(i - 1);
                int count5 = tim1.size();
                for (j2 = 0; j2 < count5; ++j2) {
                    Cell c = tim1.get(j2);
                    if ((c.cellProperties & 1) == 0) continue;
                    Cell c2 = table.get(c.topRowNum).get(j2);
                    LinesGroup lg = c2.linesGroups.get(c2.linesGroups.size() - 1);
                    c2.bottom = lg.bottom = this._pageHeight * (double)lg.pageNum;
                }
            }
            int jCount = table.get(i).size();
            for (j = 0; j < jCount; ++j) {
                Cell cij = table.get(i).get(j);
                if ((cij.cellProperties & 2) != 0) {
                    cij.top = vCurRowTop;
                    if (vNewPage) {
                        // empty if block
                    }
                    this._curPrintPageHeader = new ArrayList();
                    int pc = this._printPageHeader.size();
                    for (int p2 = ++cij.pageNum; p2 < pc; ++p2) {
                        this._curPrintPageHeader.add(this._printPageHeader.get(p2));
                    }
                    vOldHigh = this._curPrintPageHeader.size() - 1;
                    double by = this._y;
                    cij.linesGroups = this.makeLinesGroups(cij.items, cij.left, cij.right, cij.top, cij.cellParams.margins.getLeft(), cij.cellParams.margins.getRight(), cij.cellParams.margins.getTop(), cij.cellParams.margins.getBottom(), vHeaderRowsHeight, cij.pageNum, cij.height, cij.cellParams.textOrientation);
                    cij.bottom = this._y;
                    this._y = by;
                    if (result < cij.bottom) {
                        result = cij.bottom;
                    }
                    cij.top = cij.linesGroups.get((int)0).top;
                    int pCount = this._printPageHeader.size();
                    for (p = cij.pageNum; p < pCount; ++p) {
                        if (this._printPageHeader.get(p).equals(this._curPrintPageHeader.get(p - cij.pageNum))) continue;
                        this._printPageHeader.set(p, false);
                        block15: for (int l = 1; l <= i; ++l) {
                            int vMaxM = l < i ? table.get(l).size() - 1 : j - 1;
                            for (int m = 0; m <= vMaxM; ++m) {
                                Cell clm = table.get(l).get(m);
                                if ((clm.cellProperties & 2) == 0 || clm.linesGroups.get((int)(clm.linesGroups.size() - 1)).pageNum < p) continue;
                                while (this._printPageHeader.size() > p + 1) {
                                    this._printPageHeader.remove(this._printPageHeader.size() - 1);
                                }
                                while (this._printPageHeader.size() < p + 1) {
                                    this._printPageHeader.add(false);
                                }
                                i = l;
                                result = y;
                                vNewLoop = true;
                                continue block15;
                            }
                        }
                        if (vNewLoop) break;
                    }
                    int n = pCount = this._curPrintPageHeader == null ? -1 : this._curPrintPageHeader.size() - 1;
                    for (p = vOldHigh + 1; p <= pCount; ++p) {
                        this._printPageHeader.add(this._curPrintPageHeader.get(p));
                    }
                    pCount = cij.linesGroups.size();
                    for (p = 0; p < pCount; ++p) {
                        LinesGroup lg = cij.linesGroups.get(p);
                        lg.borders = cij.cellParams.borders;
                        lg.align = cij.cellParams.align;
                        lg.vertAlign = cij.cellParams.vertAlign;
                        lg.color = cij.cellParams.color;
                        if (!lg.urlLink.isEmpty()) continue;
                        lg.urlLink = cij.cellParams.urlLink;
                    }
                }
                if (vNewLoop) break;
                if ((cij.cellProperties & 1) == 0) continue;
                Cell ctj = table.get(cij.topRowNum).get(j);
                if (ctj.bottom > vCurTableHeight[i]) {
                    vCurTableHeight[i] = ctj.bottom;
                }
                LinesGroup lgh = ctj.linesGroups.get(ctj.linesGroups.size() - 1);
                if (vMaxPageNum >= lgh.pageNum) continue;
                vMaxPageNum = lgh.pageNum;
            }
            if (vNewLoop) {
                vNewLoop = false;
                continue;
            }
            jCount = table.get(i).size();
            for (j = 0; j < jCount; ++j) {
                Cell cij = table.get(i).get(j);
                if ((cij.cellProperties & 1) == 0) continue;
                Cell ctj = table.get(cij.topRowNum).get(j);
                ctj.bottom = vCurTableHeight[i];
                vOldHigh = ctj.linesGroups.size() - 1;
                LinesGroup lgoh = ctj.linesGroups.get(vOldHigh);
                int vCurPageNum = lgoh.pageNum;
                lgoh.bottom = vCurTableHeight[i];
                if (vCurPageNum < vMaxPageNum) {
                    lgoh.bottom = (double)vCurPageNum * this._pageHeight;
                    LinesGroup plg = lgoh;
                    int pCount = ctj.linesGroups.size() + vMaxPageNum - vCurPageNum;
                    for (int p3 = vOldHigh + 1; p3 < pCount; ++p3) {
                        LinesGroup clg = new LinesGroup();
                        ctj.linesGroups.add(clg);
                        clg.assign(plg);
                        clg.itemsLines.clear();
                        clg.top = this._printPageHeader.get(++vCurPageNum) != false ? (double)(vCurPageNum - 1) * this._pageHeight + headerRowsHeight : (double)(vCurPageNum - 1) * this._pageHeight;
                        clg.bottom = p3 < pCount - 1 ? (double)vCurPageNum * this._pageHeight : vCurTableHeight[i];
                        clg.pageNum = vCurPageNum;
                        plg = clg;
                    }
                }
                for (p = j; p < j + ctj.cellParams.colSpan; ++p) {
                    if (i >= table.size() || p >= table.get(i).size()) continue;
                    Cell cip = table.get(i).get(p);
                    cip.bottom = vCurTableHeight[i];
                    cip.pageNum = ctj.linesGroups.get((int)(ctj.linesGroups.size() - 1)).pageNum;
                }
            }
            ++i;
        }
        return result;
    }

    private void makeOutputArray() throws Exception {
        for (int i = 1; i < this._table.size(); ++i) {
            int jCount = this._table.get(i).size();
            for (int j = 0; j < jCount; ++j) {
                Cell buffCell = this._table.get(i).get(j);
                if (buffCell == null || buffCell.linesGroups == null || (2 & buffCell.cellProperties) == 0) continue;
                for (int k = 0; k < buffCell.linesGroups.size(); ++k) {
                    int vOldHigh = this._outputArray.size() - 1;
                    LinesGroup lgrk = buffCell.linesGroups.get(k);
                    if (lgrk.pageNum > vOldHigh) {
                        for (int m = vOldHigh + 1; m < lgrk.pageNum + 1; ++m) {
                            this._outputArray.add(new ArrayList());
                        }
                    }
                    this._outputArray.get(lgrk.pageNum).add(lgrk);
                }
            }
        }
    }

    private void beginRow(DocRow row) throws Exception {
        if (!this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        }
        if (this._tableRowStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0442\u0440\u043e\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        this._rowParams = new RowParams(row);
        if (this._rowParams.header) {
            ++this._headerRowsCount;
        }
        this._col = 0;
        this._maxCol = 0;
        ++this._row;
        this._tableRowStarted = true;
    }

    private void endRow() throws Exception {
        if (!this._tableRowStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0441\u0442\u0440\u043e\u043a");
        }
        if (!this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        }
        this._tableRowStarted = false;
    }

    private void beginCell(DocCell cell) throws Exception {
        int j;
        int i;
        if (!this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        }
        if (!this._tableRowStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0441\u0442\u0440\u043e\u043a");
        }
        if (this._tableCellStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u044f\u0447\u0435\u0439\u043a\u0438");
        }
        this._paragraphItems = new ArrayList();
        int oldTableLength = this._table.size();
        if (oldTableLength < this._row + cell.rowSpan()) {
            for (int i2 = oldTableLength; i2 < this._row + cell.rowSpan(); ++i2) {
                this._table.add(new ArrayList());
            }
        }
        this._maxCol += cell.colSpan();
        int count = Math.max(cell.rowSpan(), this._table.size() - 1);
        for (i = 0; i <= count; ++i) {
            ArrayList<Cell> tbli = this._table.get(i);
            for (j = tbli.size(); j < this._maxCol; ++j) {
                tbli.add(new Cell());
            }
        }
        if (this._rowParams.header) {
            int rc = this._table.size();
            for (i = this._header.size(); i < rc; ++i) {
                this._header.add(new ArrayList());
            }
            rc = this._table.size();
            for (i = 0; i < rc; ++i) {
                int cc = this._table.get(0).size();
                for (j = this._header.get(i).size(); j < cc; ++j) {
                    ArrayList<Cell> ti = this._header.get(i);
                    ti.add(new Cell());
                }
            }
        }
        ++this._col;
        while (this._table.get((int)this._row).get((int)(this._col - 1)).cellProperties != 0) {
            ++this._col;
        }
        Cell buffCell = this._table.get(this._row).get(this._col - 1);
        buffCell.cellParams = new CellParams(cell);
        buffCell.isUnbreakable = this._rowParams.unbreakable;
        buffCell.unbreakableRowCount = this._rowParams.unbreakableRowCount;
        if (buffCell.cellParams.color == 0x1FFFFFFF && this._rowParams.color != 0x1FFFFFFF) {
            buffCell.cellParams.color = this._rowParams.color;
        }
        if (buffCell.cellParams.color == 0x1FFFFFFF) {
            buffCell.cellParams.color = this._currentTable.getColor();
        }
        buffCell.height = this._rowParams.height;
        for (int i3 = this._row; i3 < this._row + cell.rowSpan() && i3 < this._table.size(); ++i3) {
            for (j = this._col - 1; j < this._col + cell.colSpan() - 1; ++j) {
                if (j >= this._table.get(i3).size()) continue;
                this._table.get((int)i3).get((int)j).cellProperties = 4;
                if (!this._rowParams.header) continue;
                this._header.get((int)i3).get((int)j).cellProperties = 4;
            }
        }
        buffCell.cellProperties = 2;
        buffCell.left = cell.left() + this._x;
        buffCell.right = buffCell.left + buffCell.cellParams.width;
        Cell buffCell2 = this._table.get(this._row + cell.rowSpan() - 1).get(this._col - 1);
        buffCell2.cellProperties |= 1;
        buffCell2.topRowNum = this._row;
        if (this._rowParams.header) {
            this._header.get(this._row).set(this._col - 1, this._table.get(this._row).get(this._col - 1).clone());
            this._header.get(this._row + cell.rowSpan() - 1).set(this._col - 1, this._table.get(this._row + cell.rowSpan() - 1).get(this._col - 1).clone());
        }
        this._tableCellStarted = true;
        this._cellTextOrient = cell.getTextOrientation();
    }

    private void endCell() throws Exception {
        if (!this._tableStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        }
        if (!this._tableRowStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0441\u0442\u0440\u043e\u043a");
        }
        if (!this._tableCellStarted) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u044f\u0447\u0435\u0435\u043a");
        }
        this._table.get((int)this._row).get((int)(this._col - 1)).items = this._paragraphItems;
        if (this._rowParams.header) {
            this._header.get((int)this._row).get((int)(this._col - 1)).items = this._paragraphItems;
        }
        this._col += this._table.get((int)this._row).get((int)(this._col - 1)).cellParams.colSpan - 1;
        this._tableCellStarted = false;
    }

    private static double mmTo1_72inch(double mm) {
        return mm / 25.4 * 72.0;
    }

    private Point2D getTranslatedCoord(double x, double y, double deltaY) {
        return new Point2D.Double(PdfGenerator.mmTo1_72inch(x), PdfGenerator.mmTo1_72inch(deltaY - y));
    }

    public static class IniFile {
        final Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        final Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
        final Map<String, Map<String, String>> _entries = new HashMap<String, Map<String, String>>();
        final ByteArrayOutputStream _iniContent = new ByteArrayOutputStream();
        private static final String FONTS_INI_KEY = "fonts.ini";

        public IniFile() throws Exception {
            this.prepareIniContent();
            this.load();
        }

        public String getFontFileNameFromINI(String fontName, boolean isBold, boolean isItalic) {
            String fontFileName = "";
            String styleComp = "0";
            if (isBold && !isItalic) {
                styleComp = "bold";
            } else if (!isBold && isItalic) {
                styleComp = "italic";
            } else if (isBold && isItalic) {
                styleComp = "bold,italic";
            }
            for (Map.Entry<String, Map<String, String>> pair : this._entries.entrySet()) {
                fontFileName = pair.getKey();
                String name = this.getString(fontFileName, "name", "");
                String style = this.getString(fontFileName, "style", "0");
                if (fontName.compareToIgnoreCase(name) == 0 && style.compareToIgnoreCase(styleComp) == 0) break;
                fontFileName = "";
            }
            if (fontFileName.isEmpty()) {
                fontFileName = isBold ? "tahomabd.ttf" : "tahoma.ttf";
            }
            return Ini.HomePath + File.separator + "fonts" + File.separator + fontFileName;
        }

        private void prepareIniContent() throws Exception {
            String dirPath = Ini.HomePath + File.separator + "fonts";
            File dir = new File(dirPath);
            if (!dir.exists()) {
                throw new InformException("The directory 'Fonts' doesn't exist in the root path.");
            }
            File fontFile = new File(dir, FONTS_INI_KEY);
            if (fontFile.exists()) {
                this.readFile(fontFile);
            } else {
                for (String fileName : dir.list()) {
                    if (!fileName.endsWith(".ini") || !(fontFile = new File(dir, fileName)).exists()) continue;
                    this.readFile(fontFile);
                }
            }
        }

        private void load() throws Exception {
            if (this._iniContent.size() == 0) {
                throw new InformException("Ini-file content is empty!");
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this._iniContent.internalBuffer())));){
                String line;
                String section = null;
                while ((line = br.readLine()) != null) {
                    Matcher m = this._section.matcher(line);
                    if (m.matches()) {
                        section = m.group(1).trim();
                        continue;
                    }
                    if (section == null || !(m = this._keyValue.matcher(line)).matches()) continue;
                    String key = m.group(1).trim();
                    String value = m.group(2).trim();
                    Map<String, String> kv = this._entries.get(section);
                    if (kv == null) {
                        kv = new HashMap<String, String>();
                        this._entries.put(section, kv);
                    }
                    kv.put(key, value);
                }
                br.close();
            }
        }

        private String getString(String section, String key, String defaultvalue) {
            Map<String, String> kv = this._entries.get(section);
            if (kv == null) {
                return defaultvalue;
            }
            String res = kv.get(key);
            if (res == null) {
                return defaultvalue;
            }
            return res;
        }

        private void readFile(File fontFile) throws Exception {
            try (FileInputStream fin = new FileInputStream(fontFile);){
                int n;
                byte[] buf = new byte[4096];
                while ((n = fin.read(buf)) > -1) {
                    this._iniContent.write(buf, 0, n);
                }
                fin.close();
            }
        }
    }

    private class Cell
    implements Cloneable {
        double height = 0.0;
        int topRowNum = 0;
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        int pageNum = 0;
        CellParams cellParams = new CellParams();
        int cellProperties = 0;
        ArrayList<LinesGroup> linesGroups;
        ArrayList<Item> items;
        boolean isUnbreakable = false;
        int unbreakableRowCount = 0;

        private Cell() {
        }

        public Cell clone() throws CloneNotSupportedException {
            Cell clone = (Cell)super.clone();
            clone.height = this.height;
            clone.topRowNum = this.topRowNum;
            clone.left = this.left;
            clone.right = this.right;
            clone.top = this.top;
            clone.bottom = this.bottom;
            clone.pageNum = this.pageNum;
            clone.cellProperties = this.cellProperties;
            clone.linesGroups = this.linesGroups;
            clone.items = this.items;
            clone.isUnbreakable = this.isUnbreakable;
            clone.unbreakableRowCount = this.unbreakableRowCount;
            if (this.cellParams != null) {
                clone.cellParams = this.cellParams.clone();
            }
            return clone;
        }
    }

    private class LinesGroup
    implements Cloneable {
        double height;
        double left;
        double right;
        double top;
        double bottom;
        int borders;
        int align;
        int vertAlign;
        int orientation = 0;
        int pageNum = 0;
        int color = 0x1FFFFFFF;
        String urlLink = "";
        TableMargins margins = new TableMargins();
        ArrayList<ItemsLine> itemsLines = new ArrayList();

        private LinesGroup() {
        }

        void assign(LinesGroup source) {
            if (source == null) {
                return;
            }
            this.height = source.height;
            this.left = source.left;
            this.right = source.right;
            this.top = source.top;
            this.bottom = source.bottom;
            this.borders = source.borders;
            this.align = source.align;
            this.vertAlign = source.vertAlign;
            this.orientation = source.orientation;
            this.pageNum = source.pageNum;
            this.color = source.color;
            this.urlLink = source.urlLink;
            this.margins.setLeft(source.margins.getLeft());
            this.margins.setRight(source.margins.getRight());
            this.margins.setTop(source.margins.getTop());
            this.margins.setBottom(source.margins.getBottom());
            this.itemsLines.clear();
        }

        public LinesGroup clone() throws CloneNotSupportedException {
            LinesGroup clone = (LinesGroup)super.clone();
            clone.margins = new TableMargins();
            clone.margins.setLeft(this.margins.getLeft());
            clone.margins.setRight(this.margins.getRight());
            clone.margins.setTop(this.margins.getTop());
            clone.margins.setBottom(this.margins.getBottom());
            return clone;
        }
    }

    private class ItemsLine {
        double width;
        double height;
        double textLeading;
        ArrayList<Item> items = new ArrayList();

        private ItemsLine() {
        }
    }

    private class ImageItem
    extends Item {
        double h;
        double w;
        PDImageXObject pdImage;
        int headerFooterAlign;

        public ImageItem() {
            this.h = 0.0;
            this.w = 0.0;
            this.pdImage = null;
            this.headerFooterAlign = 0;
            this.isTextItem = false;
        }

        @Override
        double getHeight() throws Exception {
            return this.h;
        }

        @Override
        double getWidth() throws Exception {
            return this.w;
        }

        void assign(ImageItem source) {
            if (source == null) {
                return;
            }
            this.x = source.x;
            this.y = source.y;
            this.h = source.h;
            this.w = source.w;
            this.urlLink = source.urlLink;
            this.pdImage = source.pdImage;
            this.headerFooterAlign = source.headerFooterAlign;
        }

        @Override
        void paint() throws Exception {
            Point2D point = PdfGenerator.this.getTranslatedCoord(this.x, this.y, PdfGenerator.this._currentSection.getPageHeight());
            if (this.pdImage != null) {
                if (!Strings.isVoid(this.urlLink)) {
                    PDAnnotationLink link = new PDAnnotationLink();
                    PDActionURI actionURI = new PDActionURI();
                    actionURI.setURI(this.urlLink);
                    link.setAction((PDAction)actionURI);
                    PDRectangle pdRectangle = new PDRectangle();
                    pdRectangle.setLowerLeftX((float)point.getX());
                    pdRectangle.setLowerLeftY((float)point.getY());
                    pdRectangle.setUpperRightX((float)(point.getX() + PdfGenerator.mmTo1_72inch(this.w)));
                    pdRectangle.setUpperRightY((float)(point.getY() + PdfGenerator.mmTo1_72inch(this.h)));
                    link.setRectangle(pdRectangle);
                    PdfGenerator.this._page.getAnnotations().add(link);
                }
                PdfGenerator.this._contentStream.drawImage(this.pdImage, (float)point.getX(), (float)point.getY(), (float)PdfGenerator.mmTo1_72inch(this.w), (float)PdfGenerator.mmTo1_72inch(this.h));
            }
        }
    }

    private class TextItem
    extends Item {
        String text;
        Font font;
        int bgColor;
        int textOrient;
        boolean wordWrap;

        public TextItem() {
            this.font = new Font();
            this.bgColor = 0x1FFFFFFF;
            this.textOrient = TextOrientation.LEFT_RIGHT.value();
            this.wordWrap = true;
            this.isTextItem = true;
        }

        @Override
        double getHeight() throws Exception {
            if (this.textOrient == TextOrientation.LEFT_RIGHT.value()) {
                return (double)this.font.getSize() * 25.4 / 72.0;
            }
            return (double)(PdfGenerator.this.getPDFont(this.font).getStringWidth(this.text) / 1000.0f * (float)this.font.getSize()) * 25.4 / 72.0;
        }

        @Override
        double getWidth() throws Exception {
            if (this.textOrient == TextOrientation.LEFT_RIGHT.value()) {
                return (double)(PdfGenerator.this.getPDFont(this.font).getStringWidth(this.text) / 1000.0f * (float)this.font.getSize()) * 25.4 / 72.0;
            }
            return (double)this.font.getSize() * 25.4 / 72.0;
        }

        void assign(TextItem source) {
            if (source == null) {
                return;
            }
            this.text = source.text;
            this.font.assign(source.font);
            this.bgColor = source.bgColor;
            this.x = source.x;
            this.y = source.y;
            this.textOrient = source.textOrient;
            this.urlLink = source.urlLink;
            this.wordWrap = source.wordWrap;
        }

        @Override
        void paint() throws Exception {
            Point2D point = PdfGenerator.this.getTranslatedCoord(this.x, this.y, PdfGenerator.this._currentSection.getPageHeight());
            if (!Strings.isVoid(this.urlLink)) {
                PDAnnotationLink link = new PDAnnotationLink();
                PDBorderStyleDictionary linkBorder = new PDBorderStyleDictionary();
                linkBorder.setStyle("U");
                linkBorder.setWidth(0.0f);
                link.setBorderStyle(linkBorder);
                PDActionURI actionURI = new PDActionURI();
                actionURI.setURI(this.urlLink);
                link.setAction((PDAction)actionURI);
                PDRectangle pdRectangle = new PDRectangle();
                pdRectangle.setLowerLeftX((float)point.getX());
                pdRectangle.setLowerLeftY((float)point.getY());
                pdRectangle.setUpperRightX((float)(point.getX() + PdfGenerator.mmTo1_72inch(this.getWidth())));
                pdRectangle.setUpperRightY((float)(point.getY() + PdfGenerator.mmTo1_72inch(this.getHeight())));
                link.setRectangle(pdRectangle);
                PdfGenerator.this._page.getAnnotations().add(link);
            }
            if (this.bgColor != 0x1FFFFFFF) {
                PdfGenerator.this._contentStream.setStrokingColor(new Color(this.bgColor & 0xFF, this.bgColor >> 8 & 0xFF, this.bgColor >> 16 & 0xFF));
                PdfGenerator.this._contentStream.setNonStrokingColor(new Color(this.bgColor & 0xFF, this.bgColor >> 8 & 0xFF, this.bgColor >> 16 & 0xFF));
                PdfGenerator.this._contentStream.addRect((float)point.getX(), (float)point.getY(), (float)PdfGenerator.mmTo1_72inch(this.getWidth()), (float)PdfGenerator.mmTo1_72inch(this.getHeight()));
                PdfGenerator.this._contentStream.fillAndStroke();
            }
            PdfGenerator.this._contentStream.beginText();
            PdfGenerator.this._contentStream.setFont(PdfGenerator.this.getPDFont(this.font), (float)this.font.getSize());
            int c = !Strings.isVoid(this.urlLink) ? 0xFF0000 : this.font.getColor();
            PdfGenerator.this._contentStream.setNonStrokingColor(new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF));
            PdfGenerator.this._contentStream.newLineAtOffset((float)point.getX(), (float)point.getY());
            if (this.textOrient == TextOrientation.BOTTOM_TOP.value()) {
                PdfGenerator.this._contentStream.setTextMatrix(Matrix.getRotateInstance((double)1.5707963267948966, (float)((float)point.getX()), (float)((float)point.getY())));
            }
            if (this.textOrient == TextOrientation.TOP_BOTTOM.value()) {
                PdfGenerator.this._contentStream.setTextMatrix(Matrix.getRotateInstance((double)4.71238898038469, (float)((float)point.getX()), (float)((float)point.getY())));
            }
            PdfGenerator.this._contentStream.showText(this.text);
            PdfGenerator.this._contentStream.endText();
            if (!(this.textOrient != TextOrientation.LEFT_RIGHT.value() || (this.font.getStyle() & 4) == 0 && Strings.isVoid(this.urlLink))) {
                PdfGenerator.this._contentStream.setLineWidth(1.0f);
                PdfGenerator.this._contentStream.setLineDashPattern(new float[]{15.0f, 0.0f}, 0.0f);
                PdfGenerator.this._contentStream.setStrokingColor(new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF));
                PdfGenerator.this._contentStream.moveTo((float)point.getX(), (float)(point.getY() - 2.0));
                PdfGenerator.this._contentStream.lineTo((float)(point.getX() + PdfGenerator.mmTo1_72inch(this.getWidth())), (float)(point.getY() - 2.0));
                PdfGenerator.this._contentStream.stroke();
            }
        }

        void remakeText(int nullCount) {
            if (nullCount == 0 || this.text.length() == 0) {
                return;
            }
            String buffStr = this.text;
            StringBuilder buff = new StringBuilder();
            String word = "";
            if (nullCount > 0) {
                boolean first = true;
                while (nullCount > 0) {
                    int i = 0;
                    boolean notSkipWS = false;
                    if (!first) {
                        String prevStr = buffStr;
                        if (prevStr.equals(buffStr = buff.toString())) {
                            return;
                        }
                        buff = new StringBuilder();
                    }
                    word = this.getWord(i, buffStr);
                    buff.append(word);
                    i += word.length();
                    word = "";
                    while (i < buffStr.length()) {
                        if (nullCount > 0 && notSkipWS && word.trim().equals("")) {
                            buff.append(" ");
                            --nullCount;
                        }
                        buff.append(word);
                        if ((word = this.getWord(i += word.length(), buffStr)).equals(" ")) continue;
                        notSkipWS = true;
                    }
                    first = false;
                }
            } else {
                int i = 0;
                while (i < buffStr.length()) {
                    buff.append(word);
                    word = this.getWord(i += word.length(), buffStr);
                }
            }
            this.text = buff.toString();
        }

        String getWord(int pos, String value) {
            int i;
            if (pos >= value.length()) {
                return "";
            }
            if (!this.urlLink.isEmpty()) {
                return this.urlLink;
            }
            String letters = "abcdefghijklmnopqrstuvwxyz\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f0123456789,.?!:()'\u00ab\u00bb-";
            String lowerValue = value.toLowerCase();
            for (i = pos; i < value.length() - 1 && letters.indexOf(lowerValue.charAt(i)) != -1; ++i) {
            }
            String res = i == pos ? value.substring(i, i + 1) : (i == value.length() - 1 ? value.substring(pos, i + 1) : value.substring(pos, i));
            return res;
        }

        String split(double allowedWidth, double maxWidth) throws Exception {
            if (!this.wordWrap) {
                return "";
            }
            allowedWidth = PdfGenerator.mmTo1_72inch(allowedWidth);
            maxWidth = PdfGenerator.mmTo1_72inch(maxWidth);
            PDFont f = PdfGenerator.this.getPDFont(this.font);
            StringBuilder vTempStr = new StringBuilder();
            String word = "";
            int i = 0;
            while (i < this.text.length() - 1 && (double)(f.getStringWidth(vTempStr.toString() + word) / 1000.0f * (float)this.font.getSize()) < allowedWidth) {
                vTempStr.append(word);
                word = this.getWord(i += word.length(), this.text);
            }
            if ((double)(f.getStringWidth(word) / 1000.0f * (float)this.font.getSize()) > maxWidth) {
                while (i < this.text.length()) {
                    if ((double)(f.getStringWidth(vTempStr.append(this.text.charAt(i)).toString()) / 1000.0f * (float)this.font.getSize()) > allowedWidth) {
                        if (i != 0 || allowedWidth != maxWidth) break;
                        ++i;
                        break;
                    }
                    ++i;
                }
            }
            String res = this.text.substring(i);
            this.text = i > 0 ? this.text.substring(0, i) : "";
            return res;
        }
    }

    private abstract class Item {
        boolean lastInLine;
        boolean isLineBreakElement = false;
        double x;
        double y;
        String urlLink = "";
        boolean isTextItem = false;

        abstract double getHeight() throws Exception;

        abstract double getWidth() throws Exception;

        abstract void paint() throws Exception;
    }

    private class RowParams {
        Font font;
        boolean header;
        double height;
        int color;
        boolean unbreakable;
        int unbreakableRowCount;

        public RowParams(DocRow row) {
            this.clear();
            if (row.getFont() != null) {
                this.font.assign(row.getFont());
            }
            this.header = row.rowType == 1;
            this.height = row.getHeight();
            this.color = row.getColor();
            this.unbreakable = row.unbreakable;
            this.unbreakableRowCount = row.unbreakableRowCount;
        }

        public void clear() {
            this.font = new Font();
            this.header = false;
            this.height = 0.0;
            this.color = 0x1FFFFFFF;
            this.unbreakable = false;
            this.unbreakableRowCount = 0;
        }
    }

    private class CellParams
    implements Cloneable {
        private static final double DEFAULT_CELL_MARGIN_TOP_BOTTOM = 0.1;
        TableMargins margins = new TableMargins();
        int borders;
        int color;
        boolean wordWrap;
        int vertAlign;
        int align;
        int textOrientation;
        Font font;
        int colSpan;
        int rowSpan;
        int colIndex;
        double width;
        String urlLink;

        public CellParams(DocCell cell) {
            this.margins.assign(cell.getSimpleCellMargins());
            if (this.margins.getTop() == 0.0) {
                this.margins.setTop(0.1);
            }
            if (this.margins.getBottom() == 0.0) {
                this.margins.setBottom(0.1);
            }
            this.borders = cell.borders();
            this.color = cell.getColor();
            this.urlLink = cell.getUrlLink();
            this.wordWrap = cell.isCellWordWrap();
            this.vertAlign = cell.getVertAlign();
            this.align = cell.getAlign();
            this.textOrientation = cell.getTextOrientation();
            this.font = new Font();
            if (cell.getFont() != null) {
                this.font.assign(cell.getFont());
            }
            this.colSpan = cell.colSpan();
            this.rowSpan = cell.rowSpan();
            this.colIndex = cell.getColIdx();
            this.width = 0.0;
            for (int i = this.colIndex; i < this.colIndex + this.colSpan; ++i) {
                this.width += cell.getTable().getColumns().get(i).getWidth();
            }
        }

        public CellParams() {
            this.borders = 0;
            this.color = 0;
            this.urlLink = "";
            this.wordWrap = false;
            this.vertAlign = 0;
            this.align = 0;
            this.textOrientation = 0;
            this.font = new Font();
            this.colSpan = 0;
            this.rowSpan = 0;
            this.colIndex = 0;
            this.width = 0.0;
        }

        public CellParams clone() throws CloneNotSupportedException {
            CellParams clone = (CellParams)super.clone();
            clone.margins = new TableMargins();
            clone.margins.assign(this.margins);
            clone.font = new Font();
            clone.font.assign(this.font);
            return clone;
        }
    }

    private class ParagraphParams {
        int align;
        int vAlign;
        int borders;
        int color;
        double leftMargin;
        double topMargin;
        double bottomMargin;
        double rightMargin;
        Font font;

        public ParagraphParams(DocParagraph p) {
            this.align = p.align().value();
            this.vAlign = p.vAlign().value();
            this.borders = DocBorders.assign(PdfGenerator.this._doc, p.getBorders());
            this.color = p.getColor();
            this.leftMargin = p.marginLeft();
            this.topMargin = p.marginTop();
            this.bottomMargin = p.marginBottom();
            this.rightMargin = p.marginRight();
            this.font = new Font();
            if (p.getFont() != null) {
                this.font.assign(p.getFont());
            }
        }

        public void clear() {
            this.align = 0;
            this.vAlign = 0;
            this.borders = 0;
            this.color = 0x1FFFFFFF;
            this.leftMargin = 0.0;
            this.topMargin = 0.0;
            this.bottomMargin = 0.0;
            this.rightMargin = 0.0;
            this.font = new Font();
        }
    }
}

