/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.SectionElement;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.CellPositions;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.VerticalAlign;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

public class TxtGenerator
implements WebReportGenerator {
    private static final int DEFAULT_LINE_PER_PAGE = 64;
    private static final int DEFAULT_SYMS_PER_LINE = 80;
    private final Document doc;
    private final String caption;
    private final String encoding;
    private int symsPerLine = 80;
    private int linePerPage = 64;
    private String pageInitChars = "";
    private String caretMoveChars = "";
    private PrintWriter pw = null;
    private int lineCount = 0;

    public TxtGenerator(Document doc, String caption, String encoding) throws Exception {
        this.doc = doc;
        this.caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
        this.encoding = encoding;
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.txt\"", this.caption.isEmpty() ? "noname" : this.caption));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(out, this.encoding), true);
        try {
            this.doc.prepareStore();
            CellPositions positions = new CellPositions();
            for (DocSection s : this.doc.sections()) {
                s.calculate(positions);
            }
            for (DocSection s : this.doc.sections()) {
                this.generateComponents(s.elements(), (int)(s.getPageWidth() / (double)this.symsPerLine));
            }
        }
        finally {
            this.pw.close();
        }
    }

    private void generateComponents(Iterable<SectionElement> elements, int mmPerSym) throws InformException {
        for (DocComponent docComponent : elements) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    this.generateParagraph((DocParagraph)docComponent);
                    break;
                }
                case TABLE: {
                    this.generateTable((DocTable)docComponent, mmPerSym);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
            }
        }
    }

    private boolean insertSpecSyms() {
        return !this.pageInitChars.isEmpty() && !this.caretMoveChars.isEmpty();
    }

    private void writeLine(String text) throws InformException {
        if (this.linePerPage < 2) {
            throw new InformException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 2");
        }
        assert (this.pw != null);
        if (this.lineCount == 0 && !this.pageInitChars.isEmpty()) {
            text = this.pageInitChars + "\r\n" + (String)text;
            ++this.lineCount;
        } else if (this.lineCount % this.linePerPage == 0 && this.insertSpecSyms()) {
            text = "\r\n" + this.caretMoveChars + this.pageInitChars + "\r\n" + (String)text;
            ++this.lineCount;
        }
        this.pw.append((CharSequence)text).append("\r\n");
        ++this.lineCount;
    }

    private String formatText(String text, HorizontalAlign align, int lLen, boolean fillSpaces) {
        switch (align) {
            case CENTER: {
                int spaces = (lLen - ((String)text).length()) / 2;
                for (int i = 0; i < spaces; ++i) {
                    text = " " + (String)text;
                }
                if (fillSpaces) {
                    text = (String)text + Strings.dup(' ', lLen - ((String)text).length());
                }
                return text;
            }
            case RIGHT: {
                int spaces = lLen - ((String)text).length();
                for (int i = 0; i < spaces; ++i) {
                    text = " " + (String)text;
                }
                return text;
            }
            case WIDTH: {
                int spaces = (lLen - ((String)text).length()) / 2;
                for (int i = 0; i < spaces; ++i) {
                    text = " " + (String)text;
                }
                if (fillSpaces) {
                    text = (String)text + Strings.dup(' ', lLen - ((String)text).length());
                }
                return text;
            }
        }
        if (fillSpaces) {
            text = (String)text + Strings.dup(' ', lLen - ((String)text).length());
        }
        return text;
    }

    private void generateParagraph(DocParagraph docParagraph) throws InformException {
        int i;
        StringBuilder text = new StringBuilder();
        for (DocComponent cm : docParagraph.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    DocText t = (DocText)cm;
                    text.append(t.getText());
                    break;
                }
            }
        }
        int borders = DocBorders.assign(this.doc, docParagraph.getBorders());
        StringBuilder token = new StringBuilder();
        if (DocBorders.topStyle(borders) != 0) {
            for (int i2 = 0; i2 < this.symsPerLine; ++i2) {
                token.append("-");
            }
            this.writeLine(token.toString());
            token.setLength(0);
        }
        int tmpSyms = this.symsPerLine;
        if (DocBorders.leftStyle(borders) != 0) {
            --tmpSyms;
        }
        if (DocBorders.rightStyle(borders) != 0) {
            --tmpSyms;
        }
        for (i = 0; i < text.length(); ++i) {
            if (token.length() >= tmpSyms) {
                this.writeLine(this.formatToken(token.toString(), docParagraph.align(), tmpSyms, borders, true));
                token.setLength(0);
            }
            if (text.charAt(i) == '\r') continue;
            if (text.charAt(i) == '\n') {
                this.writeLine(this.formatToken(token.toString(), docParagraph.align(), tmpSyms, borders, true));
                token.setLength(0);
                continue;
            }
            token.append(text.charAt(i));
        }
        if (token.length() > 0) {
            this.writeLine(this.formatToken(token.toString(), docParagraph.align(), tmpSyms, borders, true));
        }
        if (DocBorders.bottomStyle(borders) != 0) {
            token.setLength(0);
            for (i = 0; i < this.symsPerLine; ++i) {
                token.append("-");
            }
            this.writeLine(token.toString());
            token.setLength(0);
        }
    }

    private String formatToken(String token, HorizontalAlign align, int lLen, int borders, boolean isLast) {
        Object[] objectArray = new Object[3];
        objectArray[0] = DocBorders.leftStyle(borders) == 0 ? " " : "|";
        objectArray[1] = this.formatText(token, align, lLen, true);
        objectArray[2] = isLast ? (DocBorders.rightStyle(borders) == 0 ? " " : "|") : "";
        return String.format("%s%s%s", objectArray);
    }

    private ArrayList<String> getCellTextByLines(DocCell cell, int width, boolean isLast) throws InformException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder text = new StringBuilder();
        if (!cell.isCellValueEmpty()) {
            text.append(cell.getCellValue().asText());
        }
        for (DocComponent cm : cell.components()) {
            switch (cm.getType()) {
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                }
                case TEXT: {
                    text.append(((DocText)cm).getText());
                    break;
                }
            }
        }
        if (text.length() == 0) {
            text.append(' ');
        }
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (token.length() >= width) {
                result.add(this.formatToken(token.toString(), cell.horizontalAlign(), width, cell.borders(), isLast));
                token.setLength(0);
            }
            if (text.charAt(i) == '\r') continue;
            if (text.charAt(i) == '\n') {
                if (token.length() == this.symsPerLine) {
                    result.add(token.toString());
                } else {
                    result.add(this.formatToken(token.toString(), cell.horizontalAlign(), width, cell.borders(), isLast));
                }
                token.setLength(0);
                continue;
            }
            token.append(text.charAt(i));
        }
        if (token.length() > 0) {
            result.add(this.formatToken(token.toString(), cell.horizontalAlign(), width, cell.borders(), isLast));
        }
        return result;
    }

    private void correctCellText(CellInfo c, int lnCount, boolean isLast) {
        switch (c.vAlign) {
            case BOTTOM: {
                int beginLnCount = lnCount - c.text.size();
                if (beginLnCount == 0) {
                    return;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = DocBorders.leftStyle(c.borders) == 0 ? " " : "|";
                objectArray[1] = Strings.dup(' ', c.width - (isLast ? 2 : 1));
                objectArray[2] = isLast ? (DocBorders.rightStyle(c.borders) == 0 ? " " : "|") : "";
                String str = String.format("%s%s%s", objectArray);
                for (int i = 0; i < beginLnCount; ++i) {
                    c.text.add(0, str);
                }
                return;
            }
            case MIDDLE: {
                int i;
                int beginLnCount = (lnCount - c.text.size()) / 2;
                int endlnCount = lnCount - beginLnCount;
                if (beginLnCount == 0 && endlnCount == 0) {
                    return;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = DocBorders.leftStyle(c.borders) == 0 ? " " : "|";
                objectArray[1] = Strings.dup(' ', c.width - (isLast ? 2 : 1));
                objectArray[2] = isLast ? (DocBorders.rightStyle(c.borders) == 0 ? " " : "|") : "";
                String str = String.format("%s%s%s", objectArray);
                for (i = 0; i < beginLnCount; ++i) {
                    c.text.add(0, str);
                }
                for (i = 0; i < endlnCount; ++i) {
                    c.text.add(str);
                }
                return;
            }
            case BASELINE: {
                int beginLnCount = lnCount - c.text.size();
                if (beginLnCount == 0) {
                    return;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = DocBorders.leftStyle(c.borders) == 0 ? " " : "|";
                objectArray[1] = Strings.dup(' ', c.width - (isLast ? 2 : 1));
                objectArray[2] = isLast ? (DocBorders.rightStyle(c.borders) == 0 ? " " : "|") : "";
                String str = String.format("%s%s%s", objectArray);
                for (int i = 0; i < beginLnCount; ++i) {
                    c.text.add(0, str);
                }
                return;
            }
        }
        int endLnCount = lnCount - c.text.size();
        if (endLnCount == 0) {
            return;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = DocBorders.leftStyle(c.borders) == 0 ? " " : "|";
        objectArray[1] = Strings.dup(' ', c.width - (isLast ? 2 : 1));
        objectArray[2] = isLast ? (DocBorders.rightStyle(c.borders) == 0 ? " " : "|") : "";
        String str = String.format("%s%s%s", objectArray);
        for (int i = 0; i < endLnCount; ++i) {
            c.text.add(str);
        }
    }

    private int getMaxRowHeight(ArrayList<RowInfo> tModel, int ri) {
        int result = 1;
        int cols = tModel.get((int)0).cells.length;
        for (int i = 0; i < cols; ++i) {
            int ts;
            CellInfo c = tModel.get((int)ri).cells[i];
            if (c.text.size() > result && c.rowspan < 2 && c.rowspanIndex == -1) {
                result = c.text.size();
            }
            if (c.rowspanIndex <= -1 || tModel.get((int)c.rowspanIndex).cells[i].rowspan + c.rowspanIndex != ri || (ts = tModel.get((int)c.rowspanIndex).cells[i].text.size()) <= result) continue;
            result = ts;
        }
        return result;
    }

    private int getMaxRowHeightForRowspan(ArrayList<RowInfo> tModel, int ri, int rs) {
        int result = 1;
        for (int i = ri; i < rs; ++i) {
            result += this.getMaxRowHeight(tModel, i);
        }
        return result;
    }

    private int calcCellWidth(DocColumn c, boolean isLast, int mmPerSym) {
        int minCellWidth;
        int w = (int)(c.getWidth() / (double)mmPerSym);
        int n = minCellWidth = isLast ? 3 : 2;
        if (w < minCellWidth) {
            w = minCellWidth;
        }
        return w;
    }

    private void generateTable(DocTable docTable, int mmPerSym) throws InformException {
        boolean isLast;
        assert (mmPerSym != 0);
        int colCount = docTable.getColumns().size();
        ArrayList<RowInfo> tModel = new ArrayList<RowInfo>();
        int ri = -1;
        int[] rs = new int[docTable.getColumns().size()];
        int tWidth = 0;
        boolean initTWidth = true;
        for (DocRow r : docTable.rows()) {
            ++ri;
            int cellCount = r.getCells().size();
            assert (cellCount == colCount);
            CellInfo[] cells = new CellInfo[colCount];
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = new CellInfo();
            }
            int cs = 1;
            for (int i = 0; i < cellCount; ++i) {
                if (cs > 1) {
                    --cs;
                    cells[i].hidden = true;
                    if (rs[i] <= 1) continue;
                    cells[i].rowspanIndex = ri - rs[i] + 1;
                    int n = i;
                    rs[n] = rs[n] - 1;
                    continue;
                }
                if (rs[i] > 1) {
                    cells[i].rowspanIndex = ri - rs[i] + 1;
                    int n = i;
                    rs[n] = rs[n] - 1;
                    if (cs <= 1) continue;
                    --cs;
                    continue;
                }
                DocCell c = r.getCells().get(i);
                cs = c.colSpan();
                rs[i] = c.rowSpan();
                isLast = i == cellCount - 1 || i + cs == cellCount;
                cells[i].colspan = cs;
                cells[i].rowspan = rs[i];
                cells[i].borders = c.borders();
                cells[i].hidden = false;
                cells[i].width = 0;
                for (int j = 0; j < c.colSpan(); ++j) {
                    cells[i].width += this.calcCellWidth(docTable.getColumns().get(i + j), isLast, mmPerSym);
                }
                if (initTWidth) {
                    tWidth += cells[i].width;
                }
                cells[i].text = this.getCellTextByLines(c, cells[i].width - (isLast ? 2 : 1), isLast);
                cells[i].hidden = c.colSpan() == 0 && c.rowSpan() == 0;
                cells[i].vAlign = c.verticalAlign();
                cells[i].hAlign = c.horizontalAlign();
            }
            RowInfo rInfo = new RowInfo();
            rInfo.cells = cells;
            tModel.add(rInfo);
            initTWidth = false;
        }
        boolean firstRow = true;
        ri = -1;
        String preLine = "";
        if (tWidth < this.symsPerLine) {
            switch (docTable.align()) {
                case CENTER: {
                    preLine = Strings.dup(' ', (this.symsPerLine - tWidth) / 2);
                    break;
                }
                case RIGHT: {
                    preLine = Strings.dup(' ', this.symsPerLine - tWidth);
                    break;
                }
                case WIDTH: {
                    preLine = Strings.dup(' ', (this.symsPerLine - tWidth) / 2);
                }
            }
        }
        for (RowInfo r : tModel) {
            int i;
            ++ri;
            if (firstRow) {
                StringBuilder topLn = new StringBuilder(preLine);
                for (int i2 = 0; i2 < colCount; ++i2) {
                    if (!firstRow || r.cells[i2].hidden) continue;
                    topLn.append(Strings.dup(DocBorders.topStyle(r.cells[i2].borders) == 0 ? (char)' ' : '-', r.cells[i2].width));
                }
                this.writeLine(topLn.toString());
            }
            int maxLnCount = this.getMaxRowHeight(tModel, ri);
            for (i = 0; i < r.cells.length; ++i) {
                if (r.cells[i].rowspanIndex > -1) continue;
                if (r.cells[i].rowspan > 1) {
                    this.correctCellText(r.cells[i], this.getMaxRowHeightForRowspan(tModel, ri, r.cells[i].rowspan), i == r.cells.length - 1 || i + r.cells[i].colspan >= colCount);
                    continue;
                }
                if (r.cells[i].hidden) continue;
                this.correctCellText(r.cells[i], maxLnCount, i == r.cells.length - 1 || i + r.cells[i].colspan >= colCount);
            }
            for (i = 0; i < maxLnCount; ++i) {
                Object rowStr = "";
                for (int j = 0; j < r.cells.length; ++j) {
                    if (r.cells[j].hidden) continue;
                    String ct = "";
                    if (r.cells[j].rowspanIndex > -1) {
                        CellInfo rc = tModel.get((int)r.cells[j].rowspanIndex).cells[j];
                        if (rc.hidden) continue;
                        if (!rc.text.isEmpty()) {
                            ct = rc.text.get(0);
                            rc.text.remove(0);
                        } else {
                            boolean isLast2 = j == r.cells.length - 1 || j + r.cells[j].colspan >= colCount;
                            Object[] objectArray = new Object[3];
                            objectArray[0] = DocBorders.leftStyle(rc.borders) == 0 ? " " : "|";
                            objectArray[1] = Strings.dup(' ', rc.width - (isLast2 ? 2 : 1));
                            objectArray[2] = isLast2 ? (DocBorders.rightStyle(rc.borders) == 0 ? " " : "|") : "";
                            ct = String.format("%s%s%s", objectArray);
                        }
                    } else if (!r.cells[j].text.isEmpty()) {
                        ct = r.cells[j].text.get(0);
                        r.cells[j].text.remove(0);
                    }
                    rowStr = (String)rowStr + ct;
                }
                this.writeLine(preLine + (String)rowStr);
            }
            Object bottomLn = "";
            for (int i3 = 0; i3 < r.cells.length; ++i3) {
                boolean bl = isLast = i3 == r.cells.length - 1 || i3 + r.cells[i3].colspan == colCount;
                if (r.cells[i3].rowspan > 1) {
                    if (!r.cells[i3].text.isEmpty()) {
                        bottomLn = (String)bottomLn + r.cells[i3].text.get(0);
                        r.cells[i3].text.remove(0);
                        continue;
                    }
                    bottomLn = (String)bottomLn + this.formatToken(" ", r.cells[i3].hAlign, r.cells[i3].width, r.cells[i3].borders, isLast);
                    continue;
                }
                if (r.cells[i3].rowspanIndex > -1) {
                    RowInfo rsr = tModel.get(r.cells[i3].rowspanIndex);
                    if (rsr.cells[i3].hidden) continue;
                    if (r.cells[i3].rowspanIndex + rsr.cells[i3].rowspan == ri + 1) {
                        bottomLn = (String)bottomLn + Strings.dup(DocBorders.bottomStyle(rsr.cells[i3].borders) == 0 ? (char)' ' : '-', rsr.cells[i3].width);
                        continue;
                    }
                    if (!rsr.cells[i3].text.isEmpty()) {
                        bottomLn = (String)bottomLn + rsr.cells[i3].text.get(0);
                        rsr.cells[i3].text.remove(0);
                        continue;
                    }
                    bottomLn = (String)bottomLn + this.formatToken(" ", rsr.cells[i3].hAlign, rsr.cells[i3].width, rsr.cells[i3].borders, isLast);
                    continue;
                }
                if (r.cells[i3].hidden) continue;
                bottomLn = (String)bottomLn + (DocBorders.leftStyle(r.cells[i3].borders) == 0 ? (char)' ' : '|');
                bottomLn = (String)bottomLn + Strings.dup(DocBorders.bottomStyle(r.cells[i3].borders) == 0 ? (char)' ' : '-', r.cells[i3].width - 1);
            }
            this.writeLine(preLine + (String)bottomLn);
            firstRow = false;
        }
    }

    private static class RowInfo {
        CellInfo[] cells;

        private RowInfo() {
        }
    }

    private static class CellInfo {
        ArrayList<String> text = new ArrayList();
        int borders;
        boolean hidden = false;
        VerticalAlign vAlign = VerticalAlign.DEFAULT;
        HorizontalAlign hAlign = HorizontalAlign.DEFAULT;
        int width = 0;
        int colspan = 1;
        int rowspanIndex = -1;
        int rowspan = 1;

        private CellInfo() {
        }
    }
}

