/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.web.utils.BorderStyle;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class Borders {
    public static final int TAG_WEB_BORDER_LEFT = 1;
    public static final int TAG_WEB_BORDER_RIGHT = 2;
    public static final int TAG_WEB_BORDER_TOP = 3;
    public static final int TAG_WEB_BORDER_BOTTOM = 4;
    public static final int TAG_WEB_BORDER_HORZ = 5;
    public static final int TAG_WEB_BORDER_VERT = 6;
    public final BorderStyle leftBorder = new BorderStyle();
    public final BorderStyle rightBorder = new BorderStyle();
    public final BorderStyle topBorder = new BorderStyle();
    public final BorderStyle bottomBorder = new BorderStyle();
    public final BorderStyle verticalBorder = new BorderStyle();
    public final BorderStyle horizontalBorder = new BorderStyle();
    private boolean inherited = true;

    public Borders(Scriptable scope) {
    }

    public String getClassName() {
        return "Borders";
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        this.inherited = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.leftBorder.load(in.getSubStreamReader());
                    break;
                }
                case 2: {
                    this.rightBorder.load(in.getSubStreamReader());
                    break;
                }
                case 3: {
                    this.topBorder.load(in.getSubStreamReader());
                    break;
                }
                case 4: {
                    this.bottomBorder.load(in.getSubStreamReader());
                    break;
                }
                case 5: {
                    this.horizontalBorder.load(in.getSubStreamReader());
                    break;
                }
                case 6: {
                    this.verticalBorder.load(in.getSubStreamReader());
                }
            }
        }
    }

    public void docStore(TaggedWriter out) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        this.leftBorder.storeAs(1, stream, writer, out);
        this.rightBorder.storeAs(2, stream, writer, out);
        this.topBorder.storeAs(3, stream, writer, out);
        this.bottomBorder.storeAs(4, stream, writer, out);
        out.flush();
    }

    public void docStoreAs(int tag, TaggedWriter out) throws IOException {
        if (this.inherited) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        this.docStore(writer);
        out.putRaw(tag, stream);
    }

    public BorderStyle getBottomBorder() {
        return this.bottomBorder;
    }

    public BorderStyle getHorizontalBorder() {
        return this.horizontalBorder;
    }

    public BorderStyle getLeftBorder() {
        return this.leftBorder;
    }

    public BorderStyle getRightBorder() {
        return this.rightBorder;
    }

    public BorderStyle getTopBorder() {
        return this.topBorder;
    }

    public BorderStyle getVerticalBorder() {
        return this.verticalBorder;
    }

    public boolean getIsInherited() {
        return this.inherited;
    }

    public void setIsInherited(boolean isInherited) {
        this.inherited = isInherited;
    }

    public int getHorzColor() {
        return this.horizontalBorder.getColor();
    }

    public void setHorzColor(int style) {
        this.inherited = false;
        this.horizontalBorder.setColor(style);
    }

    public int getVertColor() {
        return this.verticalBorder.getColor();
    }

    public void setVertColor(int style) {
        this.inherited = false;
        this.verticalBorder.setColor(style);
    }

    public int getLeftColor() {
        return this.leftBorder.getColor();
    }

    public void setLeftColor(int style) {
        this.inherited = false;
        this.leftBorder.setColor(style);
    }

    public int getRightColor() {
        return this.rightBorder.getColor();
    }

    public void setRightColor(int style) {
        this.inherited = false;
        this.rightBorder.setColor(style);
    }

    public int getTopColor() {
        return this.topBorder.getColor();
    }

    public void setToptColor(int style) {
        this.inherited = false;
        this.topBorder.setColor(style);
    }

    public int getBottomColor() {
        return this.bottomBorder.getColor();
    }

    public void setBottomColor(int style) {
        this.inherited = false;
        this.bottomBorder.setColor(style);
    }

    public int getHorz() {
        return this.horizontalBorder.getType();
    }

    public void setHorz(int style) {
        this.inherited = false;
        this.horizontalBorder.setType(style);
    }

    public int getVert() {
        return this.verticalBorder.getType();
    }

    public void setVert(int style) {
        this.inherited = false;
        this.verticalBorder.setType(style);
    }

    public int getLeft() {
        return this.leftBorder.getType();
    }

    public void setLeft(int style) {
        this.inherited = false;
        this.leftBorder.setType(style);
    }

    public int getRight() {
        return this.rightBorder.getType();
    }

    public void setRight(int style) {
        this.inherited = false;
        this.rightBorder.setType(style);
    }

    public int getTop() {
        return this.topBorder.getType();
    }

    public void setTop(int style) {
        this.inherited = false;
        this.topBorder.setType(style);
    }

    public int getBottom() {
        return this.bottomBorder.getType();
    }

    public void setBottom(int style) {
        this.inherited = false;
        this.bottomBorder.setType(style);
    }

    public void assign(Borders borders) {
        if (borders.inherited) {
            this.reset();
        } else {
            this.leftBorder.assign(borders.leftBorder);
            this.rightBorder.assign(borders.rightBorder);
            this.topBorder.assign(borders.topBorder);
            this.bottomBorder.assign(borders.bottomBorder);
            this.verticalBorder.assign(borders.verticalBorder);
            this.horizontalBorder.assign(borders.horizontalBorder);
        }
    }

    public void assignCopy(Borders borders) {
        this.inherited = borders.inherited;
        if (borders.inherited) {
            this.reset();
        } else {
            this.leftBorder.assign(borders.leftBorder);
            this.rightBorder.assign(borders.rightBorder);
            this.topBorder.assign(borders.topBorder);
            this.bottomBorder.assign(borders.bottomBorder);
            this.verticalBorder.assign(borders.verticalBorder);
            this.horizontalBorder.assign(borders.horizontalBorder);
        }
    }

    private void reset() {
        this.leftBorder.reset();
        this.rightBorder.reset();
        this.topBorder.reset();
        this.bottomBorder.reset();
        this.verticalBorder.reset();
        this.horizontalBorder.reset();
    }

    public static class Cloned
    extends Borders {
        public Cloned(Scriptable scope) {
            super(scope);
        }
    }
}

