/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.web.utils.TypedValue;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public class KeyValues {
    final ArrayList<TypedValue> values = new ArrayList();

    KeyValues(KeyValues values) {
        this.assign(values);
    }

    public KeyValues(Scriptable scope, KeyValues values) {
        this.assign(values);
        this.assign(values);
    }

    public boolean isEqual(KeyValues key) throws InformException {
        if (key == null || key.isEmpty()) {
            return false;
        }
        if (this.values.size() != key.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Object ko;
            Object o;
            TypedValue v = this.values.get(i);
            TypedValue kv = key.values.get(i);
            if (v.dataType != kv.dataType) {
                return false;
            }
            if (!(v.dataType == DataType.NONE ? !v.equals(kv) : !(o = ValueCaster.getCastedValue(v.dataType, v.value)).equals(ko = ValueCaster.getCastedValue(kv.dataType, kv.value)))) continue;
            return false;
        }
        return true;
    }

    public String getClassName() {
        return "KeyValues";
    }

    public Object get(int index, Scriptable start) {
        return this.values.get((int)index).value;
    }

    public void put(int index, Scriptable start, Object value) {
        this.values.get((int)index).value = value;
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public void add(int dataType, Object value) {
        this.values.add(new TypedValue(DataType.getDataTypeById(dataType), value));
    }

    public void set(int index, int dataType, Object value) {
        if (index < 0 || index >= this.values.size()) {
            return;
        }
        TypedValue v = this.values.get(index);
        v.dataType = DataType.getDataTypeById(dataType);
        v.value = value;
    }

    public void addFieldValue(DataType dataType, Object value) {
        this.values.add(new TypedValue(dataType, value));
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public void assign(KeyValues key) {
        this.values.clear();
        if (key == null || key.isEmpty()) {
            return;
        }
        for (TypedValue v : key.values) {
            this.values.add(v);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValues keyValues = (KeyValues)o;
        try {
            return this.isEqual(keyValues);
        }
        catch (InformException e) {
            Core.logger.error(null, e);
            return false;
        }
    }

    public int hashCode() {
        int hashCode = 1;
        for (TypedValue v : this.values) {
            hashCode = 31 * hashCode + (v.dataType == null ? 0 : v.dataType.toInt());
            hashCode = 31 * hashCode + (v.value == null ? 0 : v.value.hashCode());
        }
        return hashCode;
    }
}

