/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.ScriptableValue;

public class TypedValue
implements ScriptableValue {
    DataType dataType;
    Object value;
    int count = 0;
    final int summaryFunction;

    public TypedValue(DataType dataType, Object value) {
        this(dataType, value, 0);
    }

    public TypedValue(DataType dataType, Object value, int summaryFunction) {
        this.dataType = dataType;
        this.value = value;
        this.summaryFunction = summaryFunction;
        if (value != null) {
            this.count = 1;
        }
    }

    public DataType getType() {
        return this.dataType;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getRawValue() {
        return this.value;
    }

    @Override
    public boolean getIsIgnored() {
        return false;
    }

    public void fixateValue() {
        switch (this.summaryFunction) {
            case 2: {
                this.value = this.count;
                break;
            }
            case 7: {
                if (this.count == 0) {
                    this.value = null;
                    break;
                }
                this.value = TypedValue.asNumber(this.value) / (double)this.count;
                break;
            }
        }
    }

    public void setValue(Object value) {
        if (this.summaryFunction == 0) {
            this.value = value;
        } else if (value != null) {
            if (this.count == 0) {
                this.value = value;
            } else {
                double v = TypedValue.asNumber(value);
                double summary = TypedValue.asNumber(this.value);
                switch (this.summaryFunction) {
                    case 1: 
                    case 7: {
                        this.value = summary + v;
                        break;
                    }
                    case 3: {
                        if (!(v < summary)) break;
                        this.value = v;
                        break;
                    }
                    case 4: {
                        if (!(summary < v)) break;
                        this.value = v;
                    }
                }
            }
            ++this.count;
        }
    }

    private static double asNumber(Object value) {
        try {
            return ValueCaster.toDouble(value);
        }
        catch (InformException ex) {
            return 0.0;
        }
    }
}

