/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class AsmoLogger
extends MarkerIgnoringBase {
    private static boolean collect = false;
    private static final HashMap<LogContext, ArrayList<String>> queries = new HashMap();
    private static final HashMap<LogContext, Boolean> collectSql = new HashMap();

    AsmoLogger() {
        this.name = "AsmoLogger";
    }

    public synchronized void setCollectSql(boolean val) {
        collect = val;
    }

    public synchronized boolean getCollectSql() {
        return collect;
    }

    public synchronized void clearCollectedSql() {
        queries.clear();
        collectSql.clear();
    }

    public synchronized void setCollectSql(LogContext cx, boolean enable) {
        if (collect) {
            collectSql.put(cx, enable);
            queries.put(cx, new ArrayList());
        }
    }

    public synchronized void collectSql(LogContext cx, String sql) {
        Boolean b;
        if (collect && (b = collectSql.get(cx)) != null && b.booleanValue()) {
            queries.get(cx).add(sql);
        }
    }

    public synchronized String getCollectedSql(LogContext cx) {
        ArrayList<String> L = queries.get(cx);
        StringBuilder result = new StringBuilder();
        if (L != null) {
            for (String s : L) {
                result.append(s).append(";\n\n");
            }
        }
        return result.toString();
    }

    public synchronized ArrayList<LogContext> getCollectConnections() {
        ArrayList<LogContext> result = new ArrayList<LogContext>();
        for (LogContext L : queries.keySet()) {
            result.add(L);
        }
        return result;
    }

    public void security(String msg) {
        this.log(Level.SEC, msg, null, null);
    }

    public void security(String format, Object arg) {
        this.formatAndLog(Level.SEC, format, arg, null);
    }

    public void security(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.SEC, format, arg1, arg2);
    }

    public void security(String format, Object ... argArray) {
        this.formatAndLog(Level.SEC, format, argArray);
    }

    public void security(String msg, Throwable t) {
        this.log(Level.SEC, msg, t, null);
    }

    public boolean isTraceEnabled() {
        return Level.TRACE.enabled();
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg, null, null);
    }

    public void trace(String format, Object arg) {
        this.formatAndLog(Level.TRACE, format, arg, null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.formatAndLog(Level.TRACE, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.TRACE, msg, t, null);
    }

    public boolean isDebugEnabled() {
        return Level.DEBUG.enabled();
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg, null, null);
    }

    public void debug(String format, Object arg) {
        this.formatAndLog(Level.DEBUG, format, arg, null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.formatAndLog(Level.DEBUG, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.DEBUG, msg, t, null);
    }

    public boolean isInfoEnabled() {
        return Level.INFO.enabled();
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(Level.INFO, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        this.formatAndLog(Level.INFO, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t, null);
    }

    public boolean isWarnEnabled() {
        return Level.WARN.enabled();
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg, null, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(Level.WARN, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.formatAndLog(Level.WARN, format, args);
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARN, msg, t, null);
    }

    public boolean isErrorEnabled() {
        return Level.ERROR.enabled();
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg, null, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(Level.ERROR, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.formatAndLog(Level.ERROR, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.ERROR, msg, t, null);
    }

    public void ddl(String msg) {
        this.log(Level.DDL, msg, null, null);
    }

    public void ddl(String format, Object arg) {
        this.formatAndLog(Level.DDL, format, arg, null);
    }

    public void ddl(String format, Object arg1, Object arg2) {
        this.formatAndLog(Level.DDL, format, arg1, arg2);
    }

    public void ddl(String format, Object ... argArray) {
        this.formatAndLog(Level.DDL, format, argArray);
    }

    public void ddl(String msg, Throwable t) {
        this.log(Level.DDL, msg, t, null);
    }

    public void logSql(String msg, LogContext localContext) {
        if (Ini.TraceSql) {
            this.log(Level.INFO, msg, null, localContext);
        }
    }

    public void logDangerSql(String msg, String info, LogContext localContext) {
    }

    private void formatAndLog(Level level, String format, Object arg1, Object arg2) {
        if (!level.enabled()) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.log(level, tp.getMessage(), tp.getThrowable(), null);
    }

    private void formatAndLog(Level level, String format, Object[] argArray) {
        if (!level.enabled()) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.log(level, tp.getMessage(), tp.getThrowable(), null);
    }

    public void log(Level level, String format, Object ... args) {
        this.formatAndLog(level, format, args);
    }

    public void log(Level level, String message, Throwable t, LogContext localContext) {
        if (!level.enabled()) {
            return;
        }
        if (message == null && t != null) {
            message = t.toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(Thread.currentThread().getName());
        LogContext cx = LogContext.CURRENT.get();
        if (cx != null || localContext != null) {
            String s;
            LogContext.Builder b = new LogContext.Builder();
            if (cx != null) {
                cx.contextMessage(b);
            }
            if (localContext != null) {
                localContext.contextMessage(b);
            }
            if (!(s = b.toString()).isEmpty()) {
                buf.append('|').append(' ').append(s);
            }
        }
        buf.append(']').append(' ');
        buf.append(message);
        if (t != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.println(buf.toString());
            AsmoLogger.printStackTrace(t, printer);
            printer.flush();
            Core.writeLogLine(level.level, writer.toString());
        } else {
            Core.writeLogLine(level.level, buf.toString());
        }
    }

    private static void printStackTrace(Throwable e, PrintWriter printer) {
        Object value;
        if (e instanceof JavaScriptException && (value = ((JavaScriptException)e).getValue()) != null) {
            Object w;
            Object jex;
            if (value instanceof Throwable) {
                AsmoLogger.printStackTrace((Throwable)value, printer);
            } else if (value instanceof ScriptableObject && (jex = ((ScriptableObject)value).get("javaException", null)) != null && jex instanceof Wrapper && (w = ((Wrapper)jex).unwrap()) != null && w instanceof Throwable) {
                AsmoLogger.printStackTrace((Throwable)w, printer);
            }
        }
        e.printStackTrace(printer);
    }

    public static enum Level {
        TRACE(0),
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3),
        DDL(4),
        DANGER(5),
        SEC(6);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean enabled() {
            return this.level == 6 || (Ini.ConsoleDialog || !Ini.DisableLog) && (Ini.verbose || 1 <= this.level);
        }
    }
}

