/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.record.DocumentEncryptionAtom;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.crypt.ChunkedCipherInputStream;
import org.apache.poi.poifs.crypt.ChunkedCipherOutputStream;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.util.BitField;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HSLFSlideShowEncrypted
implements Closeable {
    DocumentEncryptionAtom dea;
    EncryptionInfo _encryptionInfo;
    ChunkedCipherOutputStream cyos;
    private static final BitField fieldRecInst = new BitField(65520);
    private static final int[] BLIB_STORE_ENTRY_PARTS = new int[]{1, 1, 16, 2, 4, 4, 4, 1, 1, 1, 1};

    protected HSLFSlideShowEncrypted(DocumentEncryptionAtom dea) {
        this.dea = dea;
    }

    protected HSLFSlideShowEncrypted(byte[] docstream, NavigableMap<Integer, Record> recordMap) {
        UserEditAtom userEditAtomWithEncryption = null;
        for (Map.Entry me : recordMap.descendingMap().entrySet()) {
            UserEditAtom uea;
            Record r = (Record)me.getValue();
            if (!(r instanceof UserEditAtom) || (uea = (UserEditAtom)r).getEncryptSessionPersistIdRef() == -1) continue;
            userEditAtomWithEncryption = uea;
            break;
        }
        if (userEditAtomWithEncryption == null) {
            this.dea = null;
            return;
        }
        Record r = (Record)recordMap.get(userEditAtomWithEncryption.getPersistPointersOffset());
        if (!(r instanceof PersistPtrHolder)) {
            throw new RecordFormatException("Encountered an unexpected record-type: " + r);
        }
        PersistPtrHolder ptr = (PersistPtrHolder)r;
        Integer encOffset = ptr.getSlideLocationsLookup().get(userEditAtomWithEncryption.getEncryptSessionPersistIdRef());
        if (encOffset == null) {
            this.dea = null;
            return;
        }
        r = (Record)recordMap.get(encOffset);
        if (r == null) {
            r = Record.buildRecordAtOffset(docstream, encOffset);
            recordMap.put(encOffset, r);
        }
        if (!(r instanceof DocumentEncryptionAtom)) {
            throw new EncryptedPowerPointFileException("Did not have a DocumentEncryptionAtom: " + r);
        }
        this.dea = (DocumentEncryptionAtom)r;
        String pass = Biff8EncryptionKey.getCurrentUserPassword();
        EncryptionInfo ei = this.getEncryptionInfo();
        try {
            if (ei == null || ei.getDecryptor() == null) {
                throw new IllegalStateException("Invalid encryption-info: " + ei);
            }
            if (!ei.getDecryptor().verifyPassword(pass != null ? pass : "VelvetSweatshop")) {
                throw new EncryptedPowerPointFileException("PowerPoint file is encrypted. The correct password needs to be set via Biff8EncryptionKey.setCurrentUserPassword()");
            }
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedPowerPointFileException(e);
        }
    }

    public DocumentEncryptionAtom getDocumentEncryptionAtom() {
        return this.dea;
    }

    protected EncryptionInfo getEncryptionInfo() {
        return this.dea != null ? this.dea.getEncryptionInfo() : null;
    }

    protected OutputStream encryptRecord(OutputStream plainStream, int persistId, Record record) {
        boolean isPlain = this.dea == null || record instanceof UserEditAtom || record instanceof PersistPtrHolder || record instanceof DocumentEncryptionAtom;
        try {
            if (isPlain) {
                if (this.cyos != null) {
                    this.cyos.flush();
                }
                return plainStream;
            }
            if (this.cyos == null) {
                Encryptor enc = this.getEncryptionInfo().getEncryptor();
                enc.setChunkSize(-1);
                this.cyos = enc.getDataStream(plainStream, 0);
            }
            this.cyos.initCipherForBlock(persistId, false);
        }
        catch (Exception e) {
            throw new EncryptedPowerPointFileException(e);
        }
        return this.cyos;
    }

    private static void readFully(ChunkedCipherInputStream ccis, byte[] docstream, int offset, int len) throws IOException {
        if (IOUtils.readFully((InputStream)ccis, (byte[])docstream, (int)offset, (int)len) == -1) {
            throw new EncryptedPowerPointFileException("unexpected EOF");
        }
    }

    protected void decryptRecord(byte[] docstream, int persistId, int offset) {
        if (this.dea == null) {
            return;
        }
        Decryptor dec = this.getEncryptionInfo().getDecryptor();
        dec.setChunkSize(-1);
        try (LittleEndianByteArrayInputStream lei = new LittleEndianByteArrayInputStream(docstream, offset);
             ChunkedCipherInputStream ccis = (ChunkedCipherInputStream)dec.getDataStream((InputStream)lei, docstream.length - offset, 0);){
            ccis.initCipherForBlock(persistId);
            HSLFSlideShowEncrypted.readFully(ccis, docstream, offset, 8);
            int rlen = (int)LittleEndian.getUInt((byte[])docstream, (int)(offset + 4));
            HSLFSlideShowEncrypted.readFully(ccis, docstream, offset + 8, rlen);
        }
        catch (Exception e) {
            throw new EncryptedPowerPointFileException(e);
        }
    }

    private void decryptPicBytes(byte[] pictstream, int offset, int len) throws IOException, GeneralSecurityException {
        LittleEndianByteArrayInputStream lei = new LittleEndianByteArrayInputStream(pictstream, offset);
        Decryptor dec = this.getEncryptionInfo().getDecryptor();
        ChunkedCipherInputStream ccis = (ChunkedCipherInputStream)dec.getDataStream((InputStream)lei, len, 0);
        HSLFSlideShowEncrypted.readFully(ccis, pictstream, offset, len);
        ccis.close();
        lei.close();
    }

    protected void decryptPicture(byte[] pictstream, int offset) {
        if (this.dea == null) {
            return;
        }
        try {
            this.decryptPicBytes(pictstream, offset, 8);
            int recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
            int recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
            int rlen = (int)LittleEndian.getUInt((byte[])pictstream, (int)(offset + 4));
            int endOffset = (offset += 8) + rlen;
            if (recType == 61447) {
                for (int part : BLIB_STORE_ENTRY_PARTS) {
                    this.decryptPicBytes(pictstream, offset, part);
                }
                int cbName = LittleEndian.getUShort((byte[])pictstream, (int)((offset += 36) - 3));
                if (cbName > 0) {
                    this.decryptPicBytes(pictstream, offset, cbName);
                    offset += cbName;
                }
                if (offset == endOffset) {
                    return;
                }
                this.decryptPicBytes(pictstream, offset, 8);
                recInst = fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
                recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
                offset += 8;
            }
            int rgbUidCnt = recInst == 535 || recInst == 981 || recInst == 1131 || recInst == 1347 || recInst == 1761 || recInst == 1763 || recInst == 1765 || recInst == 1961 ? 2 : 1;
            for (int i = 0; i < rgbUidCnt; ++i) {
                this.decryptPicBytes(pictstream, offset, 16);
                offset += 16;
            }
            int nextBytes = recType == 61466 || recType == 61467 || recType == 61468 ? 34 : 1;
            this.decryptPicBytes(pictstream, offset, nextBytes);
            int blipLen = endOffset - (offset += nextBytes);
            this.decryptPicBytes(pictstream, offset, blipLen);
        }
        catch (Exception e) {
            throw new CorruptPowerPointFileException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void encryptPicture(byte[] pictstream, int offset) {
        block18: {
            block17: {
                if (this.dea == null) {
                    return;
                }
                ccos = null;
                los = new LittleEndianByteArrayOutputStream(pictstream, offset);
                enc = this.getEncryptionInfo().getEncryptor();
                enc.setChunkSize(-1);
                ccos = enc.getDataStream((OutputStream)los, 0);
                recInst = HSLFSlideShowEncrypted.fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
                recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
                rlen = (int)LittleEndian.getUInt((byte[])pictstream, (int)(offset + 4));
                ccos.write(pictstream, offset, 8);
                ccos.flush();
                endOffset = (offset += 8) + rlen;
                if (recType != 61447) ** GOTO lbl39
                cbName = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 33));
                for (int part : HSLFSlideShowEncrypted.BLIB_STORE_ENTRY_PARTS) {
                    ccos.write(pictstream, offset, part);
                    ccos.flush();
                    offset += part;
                }
                if (cbName > 0) {
                    ccos.write(pictstream, offset, cbName);
                    ccos.flush();
                    offset += cbName;
                }
                if (offset != endOffset) break block17;
                los.close();
                IOUtils.closeQuietly((Closeable)ccos);
                return;
            }
            try {
                recInst = HSLFSlideShowEncrypted.fieldRecInst.getValue(LittleEndian.getUShort((byte[])pictstream, (int)offset));
                recType = LittleEndian.getUShort((byte[])pictstream, (int)(offset + 2));
                ccos.write(pictstream, offset, 8);
                ccos.flush();
                offset += 8;
lbl39:
                // 2 sources

                rgbUidCnt = recInst == 535 || recInst == 981 || recInst == 1131 || recInst == 1347 || recInst == 1761 || recInst == 1763 || recInst == 1765 || recInst == 1961 ? 2 : 1;
                for (i = 0; i < rgbUidCnt; ++i) {
                    ccos.write(pictstream, offset, 16);
                    ccos.flush();
                    offset += 16;
                }
                if (recType == 61466 || recType == 61467 || recType == 61468) {
                    ccos.write(pictstream, offset, 34);
                    offset += 34;
                    ccos.flush();
                } else {
                    ccos.write(pictstream, offset, 1);
                    ++offset;
                    ccos.flush();
                }
                blipLen = endOffset - offset;
                ccos.write(pictstream, offset, blipLen);
                ccos.flush();
                break block18;
                {
                    catch (Throwable var5_7) {
                        throw var5_7;
                    }
                }
                finally {
                    los.close();
                }
            }
            catch (Exception e) {
                try {
                    throw new EncryptedPowerPointFileException(e);
                }
                catch (Throwable var15_19) {
                    IOUtils.closeQuietly(ccos);
                    throw var15_19;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)ccos);
    }

    protected Record[] updateEncryptionRecord(Record[] records) {
        String password = Biff8EncryptionKey.getCurrentUserPassword();
        if (password == null) {
            if (this.dea == null) {
                return records;
            }
            this.dea = null;
            return HSLFSlideShowEncrypted.removeEncryptionRecord(records);
        }
        if (this.dea == null) {
            this.dea = new DocumentEncryptionAtom();
        }
        EncryptionInfo ei = this.dea.getEncryptionInfo();
        byte[] salt = ei.getVerifier().getSalt();
        Encryptor enc = this.getEncryptionInfo().getEncryptor();
        if (salt == null) {
            enc.confirmPassword(password);
        } else {
            byte[] verifier = ei.getDecryptor().getVerifier();
            enc.confirmPassword(password, null, null, verifier, salt, null);
        }
        records = HSLFSlideShowEncrypted.normalizeRecords(records);
        return HSLFSlideShowEncrypted.addEncryptionRecord(records, this.dea);
    }

    protected static Record[] normalizeRecords(Record[] records) {
        UserEditAtom uea = null;
        PositionDependentRecordAtom pph = null;
        TreeMap<Integer, Integer> slideLocations = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Record> recordMap = new TreeMap<Integer, Record>();
        ArrayList<Integer> obsoleteOffsets = new ArrayList<Integer>();
        int duplicatedCount = 0;
        for (Record r : records) {
            assert (r instanceof PositionDependentRecord);
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)r);
            if (pdr instanceof UserEditAtom) {
                uea = (UserEditAtom)pdr;
                continue;
            }
            if (pdr instanceof PersistPtrHolder) {
                if (pph != null) {
                    ++duplicatedCount;
                }
                pph = (PersistPtrHolder)pdr;
                for (Map.Entry<Integer, Integer> me : ((PersistPtrHolder)pph).getSlideLocationsLookup().entrySet()) {
                    Integer oldOffset = slideLocations.put(me.getKey(), me.getValue());
                    if (oldOffset == null) continue;
                    obsoleteOffsets.add(oldOffset);
                }
                continue;
            }
            recordMap.put(pdr.getLastOnDiskOffset(), r);
        }
        if (uea == null || pph == null || uea.getPersistPointersOffset() != pph.getLastOnDiskOffset()) {
            throw new EncryptedDocumentException("UserEditAtom and PersistPtrHolder must exist and their offset need to match.");
        }
        recordMap.put(pph.getLastOnDiskOffset(), pph);
        recordMap.put(uea.getLastOnDiskOffset(), uea);
        if (duplicatedCount == 0 && obsoleteOffsets.isEmpty()) {
            return records;
        }
        uea.setLastUserEditAtomOffset(0);
        ((PersistPtrHolder)pph).clear();
        for (Map.Entry entry : slideLocations.entrySet()) {
            ((PersistPtrHolder)pph).addSlideLookup((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        for (Integer n : obsoleteOffsets) {
            recordMap.remove(n);
        }
        return recordMap.values().toArray(new Record[0]);
    }

    protected static Record[] removeEncryptionRecord(Record[] records) {
        int deaSlideId = -1;
        int deaOffset = -1;
        PersistPtrHolder ptr = null;
        UserEditAtom uea = null;
        ArrayList<Record> recordList = new ArrayList<Record>();
        for (Record r : records) {
            if (r instanceof DocumentEncryptionAtom) {
                deaOffset = ((DocumentEncryptionAtom)r).getLastOnDiskOffset();
                continue;
            }
            if (r instanceof UserEditAtom) {
                uea = (UserEditAtom)r;
                deaSlideId = uea.getEncryptSessionPersistIdRef();
                uea.setEncryptSessionPersistIdRef(-1);
            } else if (r instanceof PersistPtrHolder) {
                ptr = (PersistPtrHolder)r;
            }
            recordList.add(r);
        }
        if (ptr == null || uea == null) {
            throw new EncryptedDocumentException("UserEditAtom or PersistPtrholder not found.");
        }
        if (deaSlideId == -1 && deaOffset == -1) {
            return records;
        }
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>(ptr.getSlideLocationsLookup());
        ptr.clear();
        int maxSlideId = -1;
        for (Map.Entry<Integer, Integer> me : tm.entrySet()) {
            if (me.getKey() == deaSlideId || me.getValue() == deaOffset) continue;
            ptr.addSlideLookup(me.getKey(), me.getValue());
            maxSlideId = Math.max(me.getKey(), maxSlideId);
        }
        uea.setMaxPersistWritten(maxSlideId);
        records = recordList.toArray(new Record[0]);
        return records;
    }

    protected static Record[] addEncryptionRecord(Record[] records, DocumentEncryptionAtom dea) {
        assert (dea != null);
        int ueaIdx = -1;
        int ptrIdx = -1;
        int deaIdx = -1;
        int idx = -1;
        for (Record r : records) {
            ++idx;
            if (r instanceof UserEditAtom) {
                ueaIdx = idx;
                continue;
            }
            if (r instanceof PersistPtrHolder) {
                ptrIdx = idx;
                continue;
            }
            if (!(r instanceof DocumentEncryptionAtom)) continue;
            deaIdx = idx;
        }
        assert (ueaIdx != -1 && ptrIdx != -1 && ptrIdx < ueaIdx);
        if (deaIdx != -1) {
            DocumentEncryptionAtom deaOld = (DocumentEncryptionAtom)records[deaIdx];
            dea.setLastOnDiskOffset(deaOld.getLastOnDiskOffset());
            records[deaIdx] = dea;
            return records;
        }
        PersistPtrHolder ptr = (PersistPtrHolder)records[ptrIdx];
        UserEditAtom uea = (UserEditAtom)records[ueaIdx];
        dea.setLastOnDiskOffset(ptr.getLastOnDiskOffset() - 1);
        int nextSlideId = uea.getMaxPersistWritten() + 1;
        ptr.addSlideLookup(nextSlideId, ptr.getLastOnDiskOffset() - 1);
        uea.setEncryptSessionPersistIdRef(nextSlideId);
        uea.setMaxPersistWritten(nextSlideId);
        Record[] newRecords = new Record[records.length + 1];
        if (ptrIdx > 0) {
            System.arraycopy(records, 0, newRecords, 0, ptrIdx);
        }
        if (ptrIdx < records.length - 1) {
            System.arraycopy(records, ptrIdx, newRecords, ptrIdx + 1, records.length - ptrIdx);
        }
        newRecords[ptrIdx] = dea;
        return newRecords;
    }

    @Override
    public void close() throws IOException {
        if (this.cyos != null) {
            this.cyos.close();
        }
    }
}

