/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

public abstract class AbstractNioWorkerPool<E extends AbstractNioWorker>
implements WorkerPool<E>,
ExternalResourceReleasable {
    private final AbstractNioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();
    private final Executor workerExecutor;

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") must be a positive integer.");
        }
        this.workers = new AbstractNioWorker[workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.createWorker(workerExecutor);
        }
        this.workerExecutor = workerExecutor;
    }

    protected abstract E createWorker(Executor var1);

    @Override
    public E nextWorker() {
        return (E)this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

