(function() {
    if ( typeof asmo !== "undefined" )
        return;
    asmo = {root: "{ARROOT}", user: '{USER}'};

    var icon = null;
    var links = document.getElementsByTagName( "link" );
    for ( var i = 0; i < links.length; i++ )
        if ( links[i].rel === "shortcut icon" ) {
            icon = links[i];
            break;
        }
    if ( !icon ) {
        icon = document.createElement( "link" );
        icon.rel = "shortcut icon";
        icon.href = asmo.root + "/static/favicon.ico";
        var head = document.getElementsByTagName( "head" )[0];
        head.appendChild( icon );
    }

    function pathToName(path) {
        return 'asmo' + path.replace(/[\/\?=]/g, '_');
    }
    asmo.pathToName = pathToName;

    window.name = pathToName(window.location.pathname);

    var debug = false;
    window.onkeydown = function( e ) {
        if ( e.ctrlKey && e.shiftKey && e.altKey ) {
            debug = !debug;
            var debugs = document.getElementsByClassName( "debug" );
            for (var i = 0, l = debugs.length; i < l; ++i) {
                var d = debugs[i];
                d.style.display = debug ? "block" : "none";
                if (d._wcl_invalidate)
                    d._wcl_invalidate();
            }
        }
    };

    log = (function() {
        var list = document.createElement( "div" ), count = 0;
        list.className = "errlist";
        onerror = function( err, source, line ) {
            if ( !arguments.length )
                return;
            try {
                if ( err.responseText )//xmlhttprequest
                    err = err.responseText;
                if ( (typeof err === "string") && (err[0] === '{') ) {
                    var e = JSON.parse( err );
                    err = e.debug || e.message;
                }
            } catch(e) {
            }
            var rec = document.createElement( "pre" );
            rec.innerHTML = err && ((err.message || err) + '\n' + (err.stack || ""));
            if ( source ) {
                var b = document.createElement( "b" );
                b.innerHTML = '(' + source + ':' + (line || '?') + ")\n";
                rec.insertBefore( b, rec.firstChild );
            }
            var cb = document.createElement( "button" );
            cb.innerHTML = "&times;";
            cb.onclick = function() {
                rec.parentNode.removeChild( rec );
                count--;
                if ( count === 0 ) {
                    if ( list.parentNode )
                        list.parentNode.removeChild( list );
                    var abs = document.getElementsByName( "errors" );
                    for ( var i = 0; i < abs.length; i++ ) {
                        abs[i].style.display = "none";
                        abs[i].style.boxShadow = "";
                    }
                }
            };
            rec.insertBefore( cb, rec.firstChild );
            list.appendChild( rec );
            if ( count === 0 ) {
                var abs = document.getElementsByName( "errors" );
                if ( !abs.length )
                    alert( (source && ('(' + source + ':' + (line || '?') + ")\n") || "") + (err && (err.message || err)) + '\n' + (err.stack || "") );
                for ( var i = 0; i < abs.length; i++ ) {
                    var b = abs[i];
                    b.style.display = "inline";
                    setTimeout( (function(b){return function() {
                        b.style.boxShadow = "0 0 0 red";
                    };})(b), 100 );
                    b.onclick = function() {
                        if ( list.parentNode === this.parentNode )
                            return this.parentNode.removeChild( list );
                        this.parentNode.appendChild( list );
                        list.style.width = list.clientWidth + "px";
                        list.style.top = (this.offsetTop + this.clientHeight + 1) + "px";
                        var left = this.offsetLeft + this.clientWidth - list.clientWidth;
                        list.style.left = Math.max(left, 4) + "px";
                    };
                }
            }
            count++;
            return rec;
        };
        function pass(log, args) {
            if (log.apply)//browsers
                log.apply(console, args);
            else//IE8
                log(Array.prototype.join.call(args, ' '));
        }
        return {
            info: function() {
                if (typeof console !== 'undefined')
                    pass(console.log, arguments);
            },
            debug: function() {
                if (!log.debug.enabled)
                    return;
                if (typeof console !== 'undefined')
                    pass(console.debug, arguments);
            },
            error: onerror
        };
    })();

    if ( typeof JSON === "undefined" )
    JSON = {
        parse: function( s ) {
            var result = null;
            eval( "var result=" + s );
            return result;
        },
        stringify: function( o ) {
            if ( o === null )
                return "null";
            if ( o === undefined )
                return "undefined";
            if ( o instanceof Array ) {
                var result = '[';
                for ( var i = 0, len = o.length; i < len; i++ ) {
                    if ( i )
                        result += ',';
                    var v = o[i];
                    if ( typeof v === "function" )
                        result += "null";
                    else
                        result += JSON.stringify( v );
                }
                return result + ']';
            }
            switch ( typeof o ) {
                case "function":
                    return "undefined";
                case "string":
                    return '"' + o.replace( /\\/g, "\\\\" ).replace( /"/g, "\\\"" ) + '"';
                case "number":
                case "boolean":
                    return o.toString();
                case "object": {
                    var result = '{', nc = false;
                    for ( var i in o ) {
                        var v = o[i];
                        if ( typeof v === "function" )
                            continue;
                        if ( nc )
                            result += ',';
                        result += JSON.stringify( i ) + ':' + JSON.stringify( v );
                        nc = true;
                    }
                    return result + '}';
                }
                default:
                    throw "unsupported JSON value object type: " + (typeof o)
            }
        }
    };

CLASS = function( def, base ) {
    var r = def.constructor;
    if ( r === Object )
        r = base ? function() {
            base.apply( this, arguments );
        } : function() {
        };
    var p;
    if ( base ) {
        var pf = function() {
        };
        pf.prototype = base.prototype;
        p = new pf();
        for ( var i in def )
            r[i] = p[i] = def[i];
    } else {
        p = def;
        for ( var i in def )
            r[i] = def[i];
    }
    r.constructor = p.constructor = r;//IE8 bug
    r.prototype = p;
    if ( base )
        r.inherited = base.prototype;
    return r;
};

Asyncs = (function() {
    var PENDING = "penging", RESOLVED = "resolved", REJECTED = "rejected";
    var activities = (function() {
        var tasks = {}, count = 0, IDGEN = 0;
        var list = document.createElement( "div" );
        list.className = "tasklist";
        function getActivitiesButtons() {
            if (document.getElementsByClassName)
                return document.getElementsByClassName('activities');
            var result = [], tmp = document.getElementsByTagName('button');
            for (var i = 0; i < tmp.length; i++)
                if (String(tmp[i].className).indexOf('activities') >= 0)
                    result.push(tmp[i]);
            return result;
        }
        return {
            add: function( caption ) {
                var id = ++IDGEN;
                var task = tasks[id] = document.createElement( "div" );
                task.innerHTML = caption;
                list.appendChild( task );
                list.style.right = '0';
                if ( count === 0 ) {
                    var abs = getActivitiesButtons();
                    for ( var i = 0; i < abs.length; i++ ) {
                        var b = abs[i];
                        b._bk_act_claccName = b.className;
                        b.className += ' waiting';
                        b.onclick = function() {
                            if ( list.parentNode === this )
                                return this.removeChild( list );
                            this.insertBefore( list, this.firstChild );
                            list.style.width = list.clientWidth + "px";
                            list.style.top = (this.offsetTop + this.clientHeight + 1) + "px";
                        };
                    }
                }
                count++;
                return id;
            },
            del: function( id ) {
                var task = tasks[id];
                if ( !task )
                    return;
                task.parentNode.removeChild( task );
                delete tasks[id];
                count--;
                if ( count === 0 ) {
                    if ( list.parentNode )
                        list.parentNode.removeChild( list );
                    var abs = getActivitiesButtons();
                    for ( var i = 0; i < abs.length; i++ ) {
                        var b = abs[i];
                        b.className = b._bk_act_claccName;
                        b._bk_act_claccName = undefined;//IE8bug/delete b._bk_act_claccName;
                    }
                }
            }
        };
    })();
    var temperrors = (function() {
        var errors = [];
        function find() {
            for ( var i in errors ) {
                var e = errors[i], ok = true;
                for ( var j = 0, l = e.args.length; j < l; j++ )
                    if ( e.args[j] !== arguments[j] ) {
                        ok = false;
                        break;
                    }
                if ( ok )
                    return i;
            }
            return undefined;
        }
        return {
            add: function() {
                if ( !arguments.length )
                    return;
                var old = find.apply( null, arguments );
                var e;
                if ( old !== undefined )
                    e = errors[old];
                else
                    errors.push( e = {
                        args: arguments,
                        refs: 0,
                        mesg: log.error(arguments.length === 1 ? arguments[0] : Array.prototype.join.call(arguments, '\n'))
                    } );
                e.refs++;
            },
            del: function() {
                if ( !arguments.length )
                    return;
                var old = find.apply( null, arguments );
                if ( old === undefined )
                    return;
                var e = errors[old];
                e.refs--;
                if ( e.refs )
                    return;
                delete errors[old];
                e.mesg.parentNode.removeChild( e.mesg );
            }
        };
    })();
    function Promise( then ) {
        this.then = then;
        this.done = function( done ) {
            return then( done );
        };
        this.fail = function( fail ) {
            return then( undefined, fail );
        };
    }
    function asResolved( args, done, fail ) {
        if ( !done )
            return mkResolved( args );
        try {
            var v = done.apply( null, args );
            if ( v instanceof Promise )
                return v;
            return mkResolved( [v] );
        } catch ( e ) {
            return mkRejected( [e] );
        }
    }
    function mkResolved( args ) {
        return new Promise( function( done, fail ) {
            return asResolved( args, done, fail );
        } );
    }
    function asRejected( args, done, fail ) {
        if ( !fail )
            return mkRejected( args );
        try {
            var v = fail.apply( null, args );
            temperrors.del.apply( temperrors, args );
            if ( v instanceof Promise )
                return v;
            return mkResolved( [v] );
        } catch ( e ) {
            return mkRejected( [e] );
        }
    }
    function mkRejected( args ) {
        return new Promise( function( done, fail ) {
            return asRejected( args, done, fail );
        } );
    }
    return {
        when: function() {
            if ( arguments.length < 2 ) {
                var value = arguments[0];
                if ( value instanceof Promise )
                    return value;
                return mkResolved( arguments );
            }
            var args = [], pendings = arguments.length, async = Asyncs.create();
            for ( var i = 0; i < arguments.length; i++ ) {
                var value = arguments[i];
                if ( value instanceof Promise )
                    value.then( (function( i ) {
                        return function( v ) {
                            args[i] = v;
                            pendings--;
                            if ( !pendings ) {
                                pendings = -1;
                                async.resolve.apply( null, args );
                            }
                        };
                    })( i ), function() {
                        pendings = -1;
                        async.reject.apply( null, arguments );
                    } );
                else {
                    args[i] = value;
                    pendings--;
                }
            }
            if ( !pendings )
                return mkResolved( args );
            return async.promise();
        },
        create: function( caption ) {
            var regid = caption ? activities.add( caption ) : 0;
            var state = PENDING;
            var value = null;
            var nexts = [];
            var promise = new Promise( function( done, fail ) {
                if ( state === RESOLVED )
                    return asResolved( value, done, fail );
                else if ( state === REJECTED )
                    return asRejected( value, done, fail );
                else {
                    var r = Asyncs.create();
                    r._done = done;
                    r._fail = fail;
                    nexts.push( r );
                    return r.promise();
                }
            } );
            return {
                promise: function() {
                    return promise;
                },
                resolve: function() {
                    regid && activities.del( regid );
                    state = RESOLVED;
                    value = arguments;
                    for ( var i in nexts ) {
                        var n = nexts[i];
                        if ( n._done )
                            try {
                                var _ = n._done.apply( null, arguments );
                                if ( _ instanceof Promise )
                                    _.then( n.resolve, n.reject );
                                else
                                    n.resolve( _ );
                            } catch ( e ) {
                                n.reject( e );
                            }
                        else//propagate result
                            n.resolve.apply( null, arguments );
                    }
                    nexts = null;
                },
                reject: function() {
                    regid && activities.del( regid );
                    state = REJECTED;
                    value = arguments;
                    (!nexts.length) && temperrors.add.apply( temperrors, arguments );
                    for ( var i in nexts ) {
                        var n = nexts[i];
                        if ( n._fail )
                            try {
                                var _ = n._fail.apply( null, arguments );
                                if ( _ instanceof Promise )
                                    _.then( n.resolve, n.reject );
                                else
                                    n.resolve( _ );
                            } catch ( e ) {
                                n.reject( e );
                            }
                        else//propagate exception
                            n.reject.apply( null, arguments );
                    }
                    nexts = null;
                }
            };
        }
    };
})();
    if (typeof assert === 'undefined')
        assert = function(condition, message) {
            if (!condition)
                throw Error(message || 'assert');
        };
    Elements = {
        attribute: function(element, name) {
            var a = element.attributes.getNamedItem(name);
            return a ? a.value : undefined;
        },
        dataset: document.documentElement.dataset ? function(element, key) {
            return element.dataset[key.replace(/-(\w)/g, function(_,s){return s.toUpperCase();})];
        } : function(element, key) {
            return Elements.attribute(element, 'data-' + key);
        }
    };
    var modules = {};
    function require_ex(base, requires, callback) {
        function sync_require() { throw Error('not supported yet'); }
        var promises = [];
        var exports = null;
        for ( var i in requires ) {
            var r = requires[i], p;
          if (r === 'exports') {
            if (exports === null)
                exports = {};
            p = Asyncs.when(exports);
          } else if (r === 'require') {
            p = Asyncs.when(sync_require);
          } else {
            if (base) {
                if (!/\./.test(r))
                    r = base + '.' + r;
                else if (/^\.\//.test(r)) {
                    r = base + r.replace(/^\.\//, '.');
                } else if (/\.\./.test(r)) {
                    r = base.replace(/\./g, '/') + '/' + r;
                    r = r.replace(/[^\/]+\/\.\.\//g, '');
                    r = r.replace(/\//g, '.');
                }
            }
            var m = modules[r], css = r.indexOf( "css!" ) === 0;
            if (!m) {
                if ( css ) {
                    var styles = document.getElementsByTagName( "link" );
                    var link = null, href = asmo.root + (r.charAt(4) === '/' ? "/static" + r.substr( 4 ) : "/module/" + r);
                    for ( var i = 0; i < styles.length; i++ )
                        if (Elements.attribute(styles[i], 'href') === href) {
                            link = styles[i];
                            break;
                        }
                    if ( !link ) {
                        link = document.createElement( "link" );
                        link.rel = "stylesheet";
                        link.href = href;
                        var head = document.getElementsByTagName( "head" )[0];
                        head.appendChild( link );
                    }
                    m = modules[r] = link;
                } else {
                    m = modules[r] = Asyncs.create( " : " + r );
                    script = document.createElement( "script" );
                    var head = document.getElementsByTagName( "head" )[0];
                    head.appendChild( script );
                    script.onerror = function() {
                        delete modules[r];
                        m.reject( "  : " + this.src );
                    };
                    script.src = asmo.root + "/module/" + r;
                }
            }
            p = css ? null : m.promise();
          }
            promises.push(p);
        }
        var result = Asyncs.when.apply( Asyncs, promises );
        if (callback) {
            result = result.then(callback);
            if (exports !== null)
                result = result.then(function (r) {
                    return r || exports;
                });
        }
        return result;
    };
    require = function( requires, callback ) {
        return require_ex(undefined, requires, callback);
    };
    define = function() {
        var name = arguments[0];
        if ( (typeof name) !== "string" )
            throw "unamed module";
        var m = modules[name];
        if ( !m )
            m = modules[name] = Asyncs.create( " : " + name );
        if ( arguments[1] instanceof Array ) {
            var b = arguments[2], fb = (typeof b) === "function" ? b : function() { return b; };
            require_ex(name.replace(/\.[^\.]+$/, ''), arguments[1], fb).then(m.resolve);
        } else {
            var b = arguments[1], vb = (typeof b) === "function" ? b() : b;
            m.resolve( vb );
        }
    };
})();