define( [
    "inform.agent.web.forms.Formats",
    "inform.agent.web.forms.WebCalendar",
    "inform.agent.web.forms.Dropdown",
    "static.jquery.jquery"
], function( Formats, WebCalendar, DD, $ ) {
    var expo = {};
var PV = function( parameter, element, getter, error ) {
    this.parameter = parameter;
    this.element = element;
    this.getter = getter;
    this.error = error;
};
PV.prototype = {
    validate: function() {
        var v = this.getter();
        var p = this.parameter;
        var e = p.kind.validate( p, v );
        this.element.style.boxShadow = e ? "0 0 1px 1px #FF0000" : "";
        if ( this.error )
            this.error.innerHTML = e ? ("<div style='border:1px solid #C0C0C0;border-radius:3px;padding:2px 4px;white-space:nowrap;background-color:white;'>"+e.toLowerCase()+"</div>") : "";
        this.element.title = e ? e : '';
        return e;
    }
};
var P = expo.P = function( kind, caption, name, required, multival, initValues ) {
    this.kind = kind;
    this.caption = caption;
    this.name = name;
    this.required = required;
    this.multival = multival;
    this.init = initValues;
    this.ignored = initValues === undefined;
    this.values = [];
};
P.prototype = {
    validate: function(f) {
        if ( this.ignored && this.required )
            if ( f )
                f( "  ", this );
        for ( var i in this.values ) {
            var e = this.values[i].validate();
            if ( f && e )
                f( e, this );
        }
    },
    valueAdd: function( v ) { this.values.push( v ); },
    valueDel: function( v ) {
        function f(_){return _ != v};
        if ( this.values.filter )
            this.values = this.values.filter( f );
        else {
            var tmp = [];
            for ( var i in this.values ) {
                var _ = this.values[i];
                if ( f(_) )
                    tmp.push( _ );
            }
            this.values = tmp;
        }
    },
    submitValue: function() {
        if ( this.ignored )
            return "#";
        var r = [];
        for ( var i in this.values )
            r.push( this.values[i].getter() );
        return JSON.stringify( r.length > 1 ? r : r[0] );
    }
};
var STR = expo.STR = {
    validate: function( parameter, v ) { return undefined; },
    genvalue: function( parameter, erre, v ) {
        var e = document.createElement( "input" );
        e.style.width = "100%";
        var r = new PV( parameter, e, function() { return e.value; }, erre );
        e.type = "text";
        if ( v )
            e.value = v;
        e.onkeydown = function() { setTimeout( function(){ r.validate(); } ); };
        e.onchanged = function() { r.validate(); };
        return r;
    },
    generate: function( parameter, table, v ) {
        var idx = table.rows.length;
        var tr = table.insertRow( idx );
        if ( parameter.multival ) {
            var ce = tr.insertCell( tr.cells.length );
            $(ce).css( {
                cursor: "pointer",
                fontSize: "13pt",
                fontWeight: "bold",
                textShadow: "1px 1px 1px gray",
                width:  "1px"
            } );
            if ( idx )
            {
                ce.style.color = "#CC0000";
                ce.innerHTML = "&times;";
                ce.title = "";
                ce.onclick = function() {
                    var vv = v.getter();
                    if ( (vv !== "") && (vv !== null) && !confirm("  ?") )
                        return;
                    table.deleteRow( tr.rowIndex );
                    parameter.valueDel( v );
                };
            } else {
                ce.style.color = "#00CC00";
                ce.innerHTML = "+";
                ce.title = "";
                ce.onclick = function() {
                    parameter.kind.generate( parameter, table );
                };
            }
        }
        var ve = tr.insertCell( tr.cells.length );
        var ee = tr.insertCell( tr.cells.length );
        ee.style.fontSize = "8pt";
        ee.style.color = "red";
        var v = this.genvalue( parameter, ee, v );
        parameter.valueAdd( v );
        ve.appendChild( v.element );
        v.validate();
    }
};
var INT = expo.INT = {
    validate: function( parameter, v ) {
        var e = STR.validate( parameter, v );
        return e || (v.match(/^\d*$/) ? undefined : "  ");
    },
    generate: STR.generate,
    genvalue: STR.genvalue
};
var FLT = expo.FLT = {
    validate: function( parameter, v ) {
        var e = STR.validate( parameter, v );
        return e || (v.match(/^\d*\.?\d*$/) ? undefined : "  "); //"  "
    },
    generate: STR.generate,
    genvalue: STR.genvalue
};
var BLN = expo.BLN = {
    validate: STR.validate,
    generate: STR.generate,
    genvalue: function( parameter, erre, v ) {
        var e = document.createElement( "img" );
        e.className = "ctrl";
        var r = new PV( parameter, e, function() { return e.value ? 1 : (e.value == 0 ? 0 : null); }, erre );
        function update() {
            if ( e.value ) {
                e.src = asmo.root + "/static/images/cb_c.png";
                e.title = "";
            } else if ( e.value == 0 ) {
                e.src = asmo.root + "/static/images/cb_u.png";
                e.title = "";
            } else {
                e.src = asmo.root + "/static/images/cb_n.png";
                e.title = "NULL";
            }
        }
        e.onclick = function() {
            if ( e.value )
                e.value = null;
            else if ( e.value == 0 )
                e.value = 1;
            else
                e.value = 0;
            update();
            r.validate();
        };
        e.value = v;
        update();
        return r;
    }
};
var Dates = (function() {
    var MS_PER_DAY = 24 * 60 * 60 * 1000;
    var GREG_MS = (new Date(1899, 11, 30)).valueOf();
    return {
        d2js: function(v) {
            return new Date(GREG_MS + v * MS_PER_DAY);
        },
        js2d: function(v) {
            return (v.getTime() - GREG_MS) / MS_PER_DAY;
        }
    };
})();
expo.DTM = function(fmt) {
    this.fmtid = fmt;
    this.fmt = Formats.findById(fmt);
};
expo.DTM.prototype = {
    validate: function( parameter, v ) {
        if ((typeof v) === "number" )
            return undefined;
        var e = STR.validate( parameter, v );
        if ( e || !v || !this.fmt.parse )
            return e;
        try {
            this.fmt.parse( v );
            return undefined;
        } catch( e ) {
            return e.toString();
        }
    },
    generate: STR.generate,
    genvalue: function( parameter, erre, v ) {
        var e = document.createElement( "input" );
        var fmtid = this.fmtid, fmt = this.fmt;
        $(e).prop("readonly", !fmt.parse);
        e.type = "text";
        var getter;
        if (v)
            e.value = fmt.format(v);
        if (fmt.parse)
            getter = function() {
                return e.value ? fmt.parse(e.value) : null;
            };
        else
            getter = function() {
                return v;
            };
        var elem;
        if (fmt.calendar) {
            require(["css!inform.agent.web.forms.WebEdit"]);
            var ee = document.createElement("span");
            ee.className = "edit";
            ee.appendChild(e);
            var b = document.createElement("span");
            b.className = "button";
            b.innerHTML = "...";
            var calendar = null;
            b.onclick = function() {
                if ( calendar === null ) {
                    var mdl = WebCalendar.createModel( v ? Dates.d2js( v ) : new Date() );
                    var cal = WebCalendar.createByFormat( fmtid, mdl ), ce$ = $( cal.element() );
                    cal.onselect = function() {
                        v = Dates.js2d( mdl() );
                        e.value = fmt.format(v);
                        ce$.remove();
                    };
                    calendar = {mdl: mdl, cal: cal};
                }
                calendar.mdl( v ? Dates.d2js( v ) : new Date() );
                DD.popover( calendar.cal.element(), this );
                calendar.cal.showed();
            };
            ee.appendChild(b);
            $(e).css( {
                borderRight: "none",
                borderTopRightRadius: 0,
                borderBottomRightRadius: 0
            } );
            elem = ee;
        } else
            elem = e;
        var r = new PV( parameter, elem, getter, erre );
        e.onkeydown = function() { setTimeout( function(){ r.validate(); } ); };
        e.onchanged = function() { r.validate(); };
        return r;
    }
};
var DIR = expo.DIR = function( table, fv, ft, dt, oid ) {
    this.table = table;
    this.fv = fv;
    this.ft = ft;
    this.dt = dt;
    this.ownerId = oid;
};
DIR.prototype = {
    data: function() {
        if ( !this._data ) {
            var url = asmo.root + "/rq/getDistinctValues?t=" + this.table;
            url += "&owner="+this.ownerId;
            if ( this.fv )
                url += "&v=" + this.fv; 
            if ( this.ft )
                url += "&d=" + this.ft; 
            var rq = new XMLHttpRequest();
            rq.open( "GET", url, false );
            rq.send();
            if ( (rq.readyState !== 4) || (rq.status !== 200) )
                throw rq.readyState + ":" + rq.status + ":" + rq.responseText;
            this._data = eval( rq.responseText );
        }
        return this._data;
    },
    validate: STR.validate,
    generate: STR.generate,
    genvalue: function( parameter, erre, v ) {
        var e = document.createElement( "select" );
        e.style.width = "100%";
        var self = this;
        function a(d, v) {
            var _ = document.createElement( "option" );
            if (self.dt === 10)//METATREE_NODE
                _._nodeid = d;
            else
                _.innerHTML = d;
            if (v !== undefined)
                _.value = v;
            e.appendChild( _ );
        }
        a( '' );
        var d = this.data();
        for ( var i in d ) {
            var o = d[i];
            a( o.d, o.v );
        }
        e.value = v;
        var r = new PV( parameter, e, function() { return e.value ? e.value : null; }, erre );
        e.onchange = function() {
            var opt = this.children[this.selectedIndex];
            if ( opt && opt.style.backgroundImage ) {
                this.style.backgroundImage = opt.style.backgroundImage;
                this.style.backgroundPosition = "2px center";
                this.style.backgroundRepeat = "no-repeat";
                this.style.paddingLeft = "20px";
            } else {
                this.style.backgroundImage = "";
                this.style.paddingLeft = "";
            }
            r.validate();
        };
        if (this.dt === 10)//METATREE_NODE
            require( [
                "inform.agent.web.NodeInfo"
            ], function( NodeInfo ) {
                function update() {
                    var options = e.children;
                    for (var i = 0; i < options.length; i++) {
                        var opt = options[i];
                        opt.style.height = "18px";
                        if (opt._nodeid) {
                            var ni = NodeInfo.fetch(opt._nodeid, NodeInfo.Options.NAME | NodeInfo.Options.IMAGE);
                            if (!ni)
                                continue;
                            delete opt._nodeid;
                            opt.innerHTML = ni.name;
                            opt.style.paddingLeft = "19px";
                            opt.style.backgroundRepeat = "no-repeat";
                            opt.style.backgroundPosition = "1px center";
                            opt.style.backgroundImage = "url(" + asmo.root + "/images/icons/16/" + ni.image + ")";
                        }
                    }
                }
                NodeInfo._listen(update);
                update();
            } );
        return r;
    }
};
var MTN = expo.MTN = function(filter) {
    this.filter = filter;
};
MTN.prototype = {
    validate: STR.validate,
    generate: STR.generate,
    genvalue: function( parameter, erre, v ) {
        var e = document.createElement( "button" );
        e.style.width = "100%";
        e.style.color = "black";
        var r = new PV( parameter, e, function() { return e._value; }, erre );
        if ( v )
            e._value = v;
        function refresh() {
            if ( !e._value ) {
                e.innerHTML = "<span style='color:gray'> </span>";
            } else {
                e.innerHTML = " ...";
                e.className = "waiting";
                require( [
                    "inform.agent.web.NodeInfo"
                ], function( NodeInfo ) {
                    var updated = false;
                    function update() {
                        if ( updated )
                            return;
                        var ni = NodeInfo.fetch( e._value, NodeInfo.Options.NAME | NodeInfo.Options.IMAGE );
                        if ( !ni )
                            return;
                        e.className = "";
                        e.innerHTML = "<div style='text-align:left;line-height:16px;padding-left:18px;background-image:url(" + asmo.root + "/images/icons/16/" + ni.image + ");background-repeat:no-repeat'>" + ni.name + "</div>";
                        updated = true;
                    }
                    NodeInfo._listen( update );
                    update();
                } );
            }
        }
        refresh();
        var self = this;
        e.onclick = function( ev ) {
            ev = ev || window.event;
            ev && (ev.preventDefault ? ev.preventDefault() : ev.cancelBubble = true);
            e.disabled = true;
            require( [
                "inform.agent.web.Metatree"
            ], function( Metatree ) {
                e.disabled = false;
                Metatree.select( e._value || 0, self.filter ).then( function( info ) {
                    e._value = info.id;
                    refresh();
                } );
            } );
        };
        return r;
    }
};
function mkParmForm( element$, PARAMS ) {
    var list = $( "<table cellspacing='0' cellpadding='2' width='100%'></table>" ).appendTo( element$ );
    for ( var i in PARAMS )
    {
        var p = PARAMS[i];
        var tr = list[0].insertRow( i );
        tr.style.backgroundColor = (i % 2) ? "#F4F4F4" : "#FAFAFA";
        var td = tr.insertCell( tr.cells.length );
        $(td).css( {
            verticalAlign: "middle",
            whiteSpace: "nowrap",
            width: "1px",
            paddingLeft: "4px"
        } );
        td.innerHTML = p.caption ? p.caption.replace(" ", "&nbsp;") : "&nbsp;";
        var td = tr.insertCell( tr.cells.length );
        td.style.width = "1px"
        var im$ = $( "<img src='" + asmo.root + "/static/images/p_ignore.png' title=''>" ).css( {
            border: "none",
            width: "16px",
            height: "16px",
            float: "left",
            cursor: "pointer"
        } );
        im$.appendTo( td );
        var td = tr.insertCell( tr.cells.length );
        var ie$ = $( "<div></div>" ).css( {
            margin: "2px",
            padding: "2px",
            border: "1px solid #C0C0C0",
            borderRadius: "3px",
            backgroundColor: "white",
            textAlign: "center",
            cursor: "pointer"
        } );
        if ( p.required )
            ie$.html( " <span style='color:red'>(  )</span>" );
        else
            ie$.text( "" );
        var vt = document.createElement( "table" );
        vt.width = "100%";
        vt.cellSpacing = 0;
        vt.cellPadding = 2;
        if ( p.init instanceof Array ) {
            for ( var j in p.init )
                p.kind.generate( p, vt, p.init[j] );
        } else
            p.kind.generate( p, vt, p.init );
        td.appendChild( vt );
        ie$.appendTo( td );
        function setupIgnored(p, ie$, vt, im$) {
            function updateIgnored() {
                if ( p.ignored ) {
                    vt.style.display = "none";
                    im$.css( "display", "none" );
                    ie$.css( "display", "" );
                } else {
                    ie$.css( "display", "none" );
                    im$.css( "display", "" );
                    vt.style.display = '';
                }
            }
            ie$.click( function() {
                p.ignored = false;
                updateIgnored();
            } );
            im$.click( function() {
                p.ignored = true;
                updateIgnored();
            } );
            updateIgnored();
        }
        setupIgnored( p, ie$, vt, im$ );
    }
    return {
        PARAMS: PARAMS,
        validate: function() {
            var error = "";
            function fe(e, p) {
                error += p.caption + ": " + e + '\n';
            }
            for ( var i in PARAMS )
                PARAMS[i].validate( fe );
            if ( error ) {
                alert( error );
                return false;
            } else
                return true;
        }
    };
}
    expo.mkParmForm = mkParmForm;
    return expo;
} );
