define( [], function() {
    function dash2camel( s ) {
        return s.replace( /-(\w)/g, function( _, s ) {
            return s.toUpperCase();
        } );
    }
    function camel2dash(s) {
        return s.replace(/([A-Z])/g, function(_, s) {
            return '-' + s.toLowerCase();
        });
    }
    var Sheet = function( style ) {
        style._sheet = this;
        var sheet = style.sheet || style.styleSheet;
        var idgen = 0;
        var rcache = {};
        this.rule = function( selector ) {
            var rules = sheet.rules || sheet.cssRules;
            if ( selector ) {
                if ( rcache[selector] )
                    return rcache[selector];
                for ( var i = 0, l = rules.length; i < l; i++ ) {
                    var rule = rules[i];
                    if ( rule.selectorText === selector )
                        return rcache[selector] = new Rule( this, rule );
                }
            } else
                selector = ".R" + (idgen++).toString( 36 );
            try {
                var idx = rules.length;
                if ( sheet.addRule )
                    sheet.addRule( selector, "{}" );
                else
                    sheet.insertRule( selector + "{}", idx );
                return rcache[selector] = new Rule( this, (sheet.rules || sheet.cssRules)[idx] );
            } catch(e) {
                return rcache[selector] = {
                    style: function(arg) {
                        switch (arguments.length) {
                            case 1:
                                if ((typeof arg) === 'string')
                                    return '';
                                return this;
                            case 2:
                                return this;
                        }
                    }};
            }
        };
        this.rules = function( rules ) {
            for ( var k in rules )
                this.rule( k ).style( rules[k] );
        };
    };
    Sheet.wrap = function( style ) {
        return style._sheet instanceof Sheet ? style._sheet : new Sheet( style );
    };
    var css_pfx = '';
    switch (navigator.appName) {
        case 'Netscape':
            if (('msPointerEnabled' in navigator) || ('msDoNotTrack' in navigator))
                css_pfx = 'ms';
            else if('webkitTemporaryStorage' in navigator)
                css_pfx = 'webkit';
            else
                css_pfx = 'moz';
            break;
        case 'Microsoft Internet Explorer':
            css_pfx = 'ms';
            break;
    }
    function prefixer(kw) {
        return function(sp, v, k) {
            sp(k, v);
            if (!css_pfx)
                return;
            var idx = v.indexOf(kw);
            if (idx < 0)
                return;
            v = v.substr(0, idx) + '-' + css_pfx + '-' + v.substr(idx);
            sp(k, v);
        };
    }
    var PFX_PROPS = {
        'box-sizing': ['moz', 'webkit']
        ,'background-image': prefixer('linear-gradient')
        ,filter: function(sp, v, k) {
            sp(k, v);
            if (v.indexOf('gray') < 0)
                return;
            if (css_pfx === 'webkit')
                sp('-webkit-' + k, 'grayscale(100%)');
            else if (css_pfx === 'moz')
                sp(k, 'url(\'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg"><filter id="grayscale"><feColorMatrix type="matrix" values="0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0"/></filter></svg>#grayscale\')');
        }
    };
    function _setstyle(style, k, v) {
        v = String(v);
        var ei = v.indexOf('!'), va = '';
        if (ei >= 0) {
            va = v.substr(ei + 1);
            v = v.substr(0, ei).replace(/\s+$/, '');
        }
        function setprop(k, v) {
            try {
                if (style.setProperty)
                    style.setProperty(k, v, va);
                else
                    style.cssText += ';' + k + ':' + v + (va ? (' !' + va) : '');
            } catch(e) {
                log.info(e + ':' + k + '=' + v + ':' + va);
            }
        }
        k = camel2dash(k);
        setprop(k, v);
        var pp = PFX_PROPS[k];
        if (pp instanceof Function)
            pp(setprop, v, k);
        else if (pp !== undefined)
            for (var i = 0, l = pp.length; i < l; i++)
                setprop('-' + pp[i] + '-' + k, v);
    }
    function setstyle(style, k, vv) {
        if (vv instanceof Array)
            for (var i = 0; i < vv.length; i++)
                _setstyle(style, k, vv[i]);
        else
            _setstyle(style, k, vv);
    }
    var Rule = function( sheet, rule ) {
        this.style = function( arg ) {
            switch ( arguments.length ) {
                case 1:
                    if ( (typeof arg) === "string" )
                        return rule.style[dash2camel( arg )];
                    for ( var i in arg ) {
                        var k = i, v = arg[i];
                        if (((typeof v) === "object") && !(v instanceof Array)) {
                            if ( /^[\*\w]/.test( k ) )
                                k = ' ' + k;
                            sheet.rule( rule.selectorText + k ).style( v );
                        } else
                            setstyle(rule.style, k, v);
                    }
                    return this;
                case 2:
                    setstyle(rule.style, arg, arguments[1]);
                    return this;
            }
        };
    };
    function findWholeWord(string, word) {
        var ni = 0, sl = string.length, wl = word.length;
        while (ni < sl) {
            var i = string.indexOf(word, ni);
            if (i === -1)
                return -1;
            var j = i + wl;
            if (((i === 0) || (string[i - 1] === ' ')) && ((j === sl) || (string[j] === ' ')))
                return i;
            ni = i + 1;
        }
        return -1;
    }
    var supportsClassList = document.documentElement.classList !== undefined;
    var hasClass = supportsClassList ? function(element, className) {
        return element.classList.contains(className);
    } : function(element, className) {
        return findWholeWord(String(element.className), className) !== -1;
    };
    var addClass = supportsClassList ? function(element, className) {
        element.classList.add(className);
    } : function(element, className) {
        var i = findWholeWord(String(element.className), className);
        if (i === -1)
            element.className += ' ' + className;
    };
    var removeClass = supportsClassList ? function(element, className) {
        element.classList.remove(className);
    } : function(element, className) {
        var cn = String(element.className);
        var i = findWholeWord(cn, className);
        if (i === -1)
            return;
        var i1 = i + className.length;
        element.className = cn.substr(0, i - 1) + cn.substr(i1, cn.length - i1);
    };
    return {
        sheet: function( element ) {
            if ( !element )
                element = document.getElementsByTagName( "head" )[0];
            else if ( element.tagName === "STYLE" )
                return Sheet.wrap( element );
            var styles = element.getElementsByTagName( "style" );
            if ( styles.length )
                return Sheet.wrap( styles[0] );
            var style = document.createElement( "style" );
            element.appendChild( style );
            return new Sheet( style );
        },
        apply: function(style, def) {
            for (var i in def)
                setstyle(style, i, def[i]);
        },
        hasClass: hasClass,
        addClass: addClass,
        removeClass: removeClass
    };
} );