define( [
    "inform.agent.web.forms.Formats",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.Dropdown",
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.WebCalendar",
    "inform.agent.web.NodeInfo",
    "inform.agent.web.Expressions",
    "inform.agent.web.utils.Strings",
    "static.jquery.jquery",
    "static.jquery.jquery-ui",
    "static.jquery.jquery-maskedinput"
    ,'inform.agent.web.Styles'
    ,'static.wcl.Core'
    ,'static.wcl.Theme'
], function(Formats, DM, DD, WebForm, WebCalendar, NodeInfo, Expressions, Strings, $, $ui, $mi, Styles, Wcl, Theme) {
    var Dates = (function() {
        var MS_PER_DAY = 24 * 60 * 60 * 1000;
        var GREG_MS = (new Date( 1899, 11, 30 )).valueOf();
        return {
            d2js: function( v ) {
                return new Date( GREG_MS + v * MS_PER_DAY );
            },
            js2d: function( v ) {
                return (v.getTime() - GREG_MS) / MS_PER_DAY;
            }
        };
    })();
    function bool2str( v ) {
        if ( (v === null) || (v === undefined) || (v === DM.fetchFPathValue.NVAL) )
            return "";
        return v ? "" : "";
    }
    function nvl( v, def ) {
        return ((v === null) || (v === undefined) || (v === DM.fetchFPathValue.NVAL)) ? def : v;
    }
    function make( components ) {
        var element = this, element$ = $( this );
        var fixedWidth = !!element.style.width;
        var readonly = element$.attr( "readonly" ) !== undefined;
        var dsid = element$.attr( "data-datasource" );
        var fid = element$.attr( "data-datafield" );
        var expr = element$.attr( "data-expression" );
        var type = element$.attr( "data-datatype" ) | 0;
        var expression = expr && Expressions.make( expr, components );
        var fmt = null, fmtid = element$.attr( "data-format" ) | 0;
        var fmtopt = element$.attr( "fmtopt" );
        if ( fmtid ) {
            fmt = fmtopt && Formats.byIdAndOption(fmtid, fmtopt && Strings.base64_to_bytestr(fmtopt));
            if ( !fmt )
                fmt = Formats.findById( fmtid );
            if ( !fmt )
                element$.css( "color", "red" );
            else if ( fmt.mask ) {
                $mi.fn.mask.call( element$, fmt.mask );
                element$.attr( "size", fmt.mask.length );
                if ( !fixedWidth )
                    element$.css( "width", (fmt.mask.length + 1.1) + "ex" );
            }
        }
        var fpath = null;
        var asel = element$.attr( "data-selector" );
        if ( asel ) {
            var _ = asel.split( ':' );
            asel = {
                dsid: _[0] | 0,
                fvid: _[1],
                fdid: _[2],
                ptid: _[3],
                only: _[4] === "only"
            };
        }
        var selector = asel && asel.dsid ? (function() {
            var sds = components[asel.dsid];
            var sfv = asel.fvid && DM.mkFieldPath( asel.fvid.split( ',' ), asel.dsid, components );
            var sfd = asel.fdid && DM.mkFieldPath( asel.fdid.split( ',' ), asel.dsid, components );
            var result = null, response = null, term = null, hl = null;
            function tryit() {
                if ( !response )
                    return;
                if ( sds._scan( function( cursor ) {
                    var rcount = cursor._rowsCount();
                    if ( rcount === DM.fetchFPathValue.WAIT )
                        return;
                    result = [];
                    var ctx = DM.createCachedContext();
                    for ( cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++ ) {
                        var row = cursor._row();
                        if ( !row ) {
                            result = null;
                            break;
                        }
                        ctx.init( sds, row );
                        var sv = DM.fetchFPathValue( sfv, ctx.rower( sfv[0]._datasource ) );
                        if ( sv === DM.fetchFPathValue.WAIT ) {
                            result = null;
                            break;
                        }
                        var sd = sfd ? DM.fetchFPathValue( sfd, ctx.rower( sfd[0]._datasource ) ) : sv;
                        if ( sd === DM.fetchFPathValue.WAIT ) {
                            result = null;
                            break;
                        }
                        if ( (sd === null) || (sd === undefined) || (sd === DM.fetchFPathValue.NVAL) )
                            continue;
                        sd = sd.toString();
                        if ( !sd.match( term ) )
                            continue;
                        result.push( {value: sv, label: hl(sd)} );
                    }
                } ) && result ) {
                    response( result );
                    response = null;
                }
            }
            for ( var i in sfv )
                sfv[i]._datasource._listen( tryit );
            for ( var i in sfd )
                sfd[i]._datasource._listen( tryit );
            return function( req, resp ) {
                result = null;
                response = resp;
                term = new RegExp( $ui.ui.autocomplete.escapeRegex( req.term ), "gi" );
                hl = req.term ? function(s) {
                    return s.replace(term, "<b>$&</b>");
                } : function(s) {
                    return s;
                };
                tryit();
            };
        })() : function( req, resp ) {
            if ( !fpath )
                return false;
            var fd = fpath[1], fvid = -1;
            var hl = req.term ? (function() {
                var term = new RegExp( $ui.ui.autocomplete.escapeRegex( req.term ), "gi" );
                return function(s) {
                    return s.replace(term, "<b>$&</b>");
                };
            })() : function(s) {
                return s;
            };
            $.ajax( {
                url: asmo.root + "/rq/getDistinctValues",
                data: {
                    t: fd._datasource._descriptor.node,
                    v: fvid,
                    d: fd.id,
                    term: req.term,
                    owner: fd._datasource._descriptor.ownerId
                },
                success: function( response ) {
                    var out = [];
                    for ( var i in response )
                        out.push( {value: response[i].v, label: hl(response[i].d)} );
                    resp( out );
                }
            } );
        };
        function mkButton( text, hint ) {
            var btn = document.createElement( "span" );
            btn.className = "button";
            btn.innerHTML = text;
            hint && (btn.title = hint);
            var cw = element.clientWidth;
            var btn$ = $( btn );
            btn$.insertAfter( element$ );
            if ( fixedWidth )
                element$.width( cw - btn$[0].clientWidth - 5 );
            element$.css( {
                borderRight: "none",
                borderTopRightRadius: 0,
                borderBottomRightRadius: 0
            } );
            return btn$;
        }
        var act = element$.attr( "data-action" );
        var actEditModeOnly = element$.attr( "data-action-editonly" ) !== undefined;
        var actSelect = element$.attr( "data-select-action" );
        if ( actSelect )
            actSelect = new (WebForm.ActionList)( actSelect, components );
        var button$ = null;
        if ( act ) {
            var ac = new (WebForm.ActionList)( act, components );
            button$ = mkButton( "..." );
            function bupdate() {
                var act = ac._action();
                button$.attr( "disabled", !act );
                button$.context.onclick = act ? function( e ) {
                    act( {event: e || window.event} );
                } : null;
            }
            ac._listen( bupdate );
            bupdate();
        }
        if ( (dsid && fid) || expr ) {
            if ( dsid && fid ) {
            var orgvalue = "", orgvalueraw = null, row = null;
            fpath = DM.mkFieldPath( fid.split( ',' ), dsid, components );
            var generateWaiterTimeout = null;
            var ff = fpath[0], fl = fpath && fpath[fpath.length - 1], ds = ff._datasource;
            type = type || (fl && fl._descriptor.type);
            var disabledit = (asel && asel.only) || (type === DM.DataType.METATREE_NODE) || (fmt && !fmt.parse);
            if ( ds._modify ) {
                element$.keyup( function( e ) {
                    if ( e.keyCode === 27 )
                        ds._touch();
                } ).focus( function() {
                    if ( !disabledit )
                        element$.val( orgvalue );
                } ).blur( function() {
                    expression && expression._touch();
                } );
                function mkAutoComplete() {
                    function show( term ) {
                        DD.show( {
                            element: element,
                            source: function( resp ) {
                                return selector( {term: term}, resp );
                            },
                            value: function() {
                                if ( arguments.length ) {//set
                                    var v = arguments[0];
                                    if ( type === DM.DataType.DIRECTORY ) {
                                        var vv = parseFloat( v );
                                        if ( isNaN( vv ) )
                                            throw v + " is not a number";
                                        v = vv;
                                    }
                                    var sp = ds._dmodel && ds._dmodel._savepoint();
                                    Asyncs.when( v ).then( function( v ) {
                                        row = ds._modify( row );
                                        row[ff.index] = orgvalue = v;
                                        ds._touch();
                                        if ( actSelect ) {
                                            var sa = actSelect._action();
                                            if ( !sa )
                                                throw "disabled action";
                                            return sa({});
                                        }
                                    } ).fail( function() {
                                        log.error.apply( log, arguments );
                                        if ( !ds._dmodel )
                                            return;
                                        ds._dmodel._rollback( sp );
                                        ds._dmodel._touch();
                                    } );
                                } else//get
                                    return element._dirvalue || element$.val();
                            }
                        } );
                    }
                    var tmoUpdate = null;
                    element$.keyup( function() {
                        var v = element$.val();
                        if ( orgvalue === v )
                            return;
                        orgvalue = v;
                        clearTimeout( tmoUpdate );
                        tmoUpdate = setTimeout( function() {
                            show( v );
                        }, 250 );
                    } ).change( function() {
                        ds._touch();
                    } ).blur( function() {
                        clearTimeout( tmoUpdate );
                        tmoUpdate = null;
                    } );
                    if ( !readonly && asel && asel.only )
                        element$.click( function() {
                            show( "" );
                        } );
                    if ( !button$ ) {
                        button$ = mkButton( "&#9660;", "  " ).click( function() {
                            if (button$.attr("disabled"))
                                return;
                            show( "" );
                        } );
                        button$.attr("disabled", readonly);
                    }
                }
                if ( fpath.length === 1 ) {
                    element$.change( function() {
                        var val = element$.val();
                        if ( val && fmt )
                            try {
                                val = fmt.parse( val );
                                element$.attr( "error", null );
                                element$.attr( "title", null );
                            } catch ( e ) {
                                element$.attr( "error", e );
                                element$.attr( "title", e );
                                return;
                            }
                        row = ds._modify( row );
                        row[ff.index] = val || null;
                        ds._touch();
                    } );
                    if ( asel && asel.dsid )
                        mkAutoComplete();
                } else if ( fpath.length === 2 )
                    mkAutoComplete();
                else
                    readonly = true;
            }
                function bclick_mtree() {
                    if (button$.attr("disabled"))
                        return;
                    require( [
                        "inform.agent.web.Metatree"
                    ], function( Metatree ) {
                        Metatree.select( orgvalueraw, fl && fl._descriptor.filter ).then( function( info ) {
                            row = ds._modify( row );
                            row[ff.index] = info.id;
                            ds._touch();
                        } );
                    } );
                }
                var calendar = null;
                function bclick_datetime() {
                    if (button$.attr("disabled"))
                        return;
                    if ( calendar === null ) {
                        var mdl = WebCalendar.createModel( orgvalueraw ? Dates.d2js( orgvalueraw ) : new Date() );
                        var cal = WebCalendar.createByFormat( fmtid, mdl ), ce$ = $( cal.element() );
                        cal.onselect = function() {
                            var val = Dates.js2d( mdl() );
                            row = ds._modify( row );
                            row[ff.index] = val || null;
                            ds._touch();
                            ce$.remove();
                        };
                        calendar = {mdl: mdl, cal: cal};
                    }
                    calendar.mdl( orgvalueraw ? Dates.d2js( orgvalueraw ) : new Date() );
                    DD.popover( calendar.cal.element(), this );
                    calendar.cal.showed();
                }
                if ( fl ) {
                    if ( fl._descriptor.type === DM.DataType.METATREE_NODE )
                        (button$ = mkButton( "..." )).click( bclick_mtree );
                    if ( (fl._descriptor.type === DM.DataType.DATE_TIME) && (!fmt || fmt.calendar) )
                        (button$ = mkButton( "..." )).click( bclick_datetime );
                    var vari = (fl._descriptor.type === DM.DataType.VARIANT) || fl._descriptor.multilookup;
                    if ( vari )
                        button$ = mkButton( "..." );
                }
            }
            function update() {
                function tryup() {
                    function valueByType(t, val) {
                        switch ( t ) {
                            case DM.DataType.DATE_TIME:
                                if ( fmt && (val !== null) && (val !== undefined) )
                                    val = fmt.format( val );
                                break;
                            case DM.DataType.BOOLEAN:
                                val = bool2str( val );
                                break;
                            case DM.DataType.METATREE_NODE:
                                if ( (val !== null) && (val !== undefined) ) {
                                    var ni = NodeInfo.fetch( val, NodeInfo.Options.NAME | NodeInfo.Options.IMAGE | NodeInfo.Options.FIO );
                                    if ( !ni )
                                        return false;
                                    img = ni.image;
                                    val = fmt ? fmt.format( ni ) : ni.name;
                                }
                                break;
                            default:
                                if ( fmt && (val !== null) && (val !== undefined) )
                                    val = fmt.format( val );
                                break;
                        }
                        return val;
                    }
                    var typo = {type: type};
                    orgvalue = "";
                    var ve = undefined, ro = true;
                    if ( fpath ) {
                    row = fpath[0]._datasource._row();
                    if ( row === null )
                        return false;
                    ve = DM.fetchFPathValue( fpath, row, typo );
                    if ( ve === DM.fetchFPathValue.WAIT )
                        return false;
                    if ( ve === DM.fetchFPathValue.NVAL )
                        ve = undefined;
                        ro = (row === undefined);
                    if ( !ro && (fpath.length === 2) )
                        element._dirvalue = row[fpath[0].index];
                    orgvalueraw = ve;
                        ve = valueByType(typo.type, ve);
                    }
                    var v = undefined;
                    if ( expression ) {
                        v = expression.evaluate( DM.DefaultContext );
                        if ( v === Expressions.WAIT )
                            return false;
                        if ( v === DM.fetchFPathValue.NVAL )
                            v = undefined;
                    }
                    element$.prop( "readonly", disabledit || readonly || ro );
                    button$ && button$.attr( "disabled", (readonly || ro) && (!act || actEditModeOnly) );
                    clearTimeout( generateWaiterTimeout );
                    generateWaiterTimeout = null;
                    element$.removeClass( "waiting" );
                    var img = 0;
                    v = valueByType(typo.type, v);
                    if ( vari )
                        switch ( typo.type ) {
                            case DM.DataType.DATE_TIME:
                                button$[0].onclick = bclick_datetime;
                                button$.insertAfter( element$ );
                                break;
                            case DM.DataType.METATREE_NODE:
                                button$[0].onclick = bclick_mtree;
                                button$.insertAfter( element$ );
                                break;
                            default:
                                button$.remove();
                                break;
                        }
                    if ( img ) {
                        element.style.paddingLeft = "20px";
                        element.style.backgroundImage = "url(" + asmo.root + "/images/icons/16/" + img + ")";
                    } else {
                        element.style.paddingLeft = "";
                        element.style.backgroundImage = "";
                    }
                    orgvalue = nvl( ve, "" );
                    element$.val( nvl( v, '' ) );
                    return true;
                }
                if ( !tryup() ) {
                    element$.prop( "readonly", true );
                    button$ && button$.attr( "disabled", true );
                    if ( !generateWaiterTimeout )
                        generateWaiterTimeout = setTimeout( function() {
                            if ( !generateWaiterTimeout )//IE8 bug
                                return;
                            element$.val( "" ).addClass( "waiting" );
                        }, 250 );
                }
            }
            for ( var i in fpath )
                fpath[i]._datasource._listen( update );
            expression && expression._listen( update );
            (type === DM.DataType.METATREE_NODE) && NodeInfo._listen( update );
            update();
                switch ( fmtid ) {
                    case 407:
                        var div = document.createElement( "span" );
                        div.className = "spinner";
                        var btn = document.createElement( "span" );
                        btn.className = "button";
                        btn.onclick = function() {
                            var v = parseFloat( element.value );
                            if ( isNaN( v ) )
                                return;
                            v++;
                            var l = element$.attr( "max" );
                            if ( l )
                                v = Math.min( v, l | 0 );
                            element.value = v;
                        };
                        btn.innerHTML = "&#9650;";
                        div.appendChild( btn );
                        var btn = document.createElement( "span" );
                        btn.className = "button";
                        btn.onclick = function() {
                            var v = parseFloat( element.value );
                            if ( isNaN( v ) )
                                return;
                            v--;
                            var l = element$.attr( "min" );
                            if ( l )
                                v = Math.max( v, l | 0 );
                            element.value = v;
                        };
                        btn.innerHTML = "&#9660;";
                        div.appendChild( btn );
                        var cw = element.clientWidth;
                        element.parentNode.appendChild( div );
                        if ( fixedWidth )
                            element$.width( cw - div.clientWidth - 5 );
                        element$.css( {
                            borderRight: "none",
                            borderTopRightRadius: 0,
                            borderBottomRightRadius: 0
                        } );
                        break;
                }
        }
    }
    return {
        WclControl: function(parent, container, arg) {
            var msr = {
                'width': 'auto !important',
                'height': 'auto !important'
            };
            Styles.sheet().rules({
                '.wcl-edit': {
                    '.wcl-measure': {
                        '>input': msr,
                        '>textarea': msr
                    },
                    '>textarea': {
                        'resize': 'none'
                    }
                }
            });
            container.appendChild(arg.item);
            Styles.addClass(arg.item, 'wcl-edit');
            var edit = arg.item.firstChild;
            var multiline = edit.tagName === 'TEXTAREA';
            var minw = 0, minh = 0, maxw = 0, maxh = 0;
            arg.minh = arg.minh || (multiline ? 2 : 1);
            if (multiline)
            {
                var mm = document.createElement('textarea');
                mm.style.visibility = 'hidden';
                mm.style.height = 'auto';
                mm.position = 'absolute';
                mm.cols = mm.rows = 1;
                document.body.appendChild(mm);
                var mmw = mm.clientWidth, mmh = mm.clientHeight;
                mm.cols = mm.rows = 11;
                var pps = (mm.clientWidth - mmw) / 10, ppr = (mm.clientHeight - mmh) / 10;
                arg.minw = arg.minw || 2;
                minw = arg.minw && (pps * arg.minw + 4 + 4);
                minh = arg.minh && (ppr * arg.minh + 4 + 2);
                maxw = arg.maxw && (pps * arg.maxw + 4 + 4);
                maxh = arg.maxh && (ppr * arg.maxh + 4 + 2);
                document.body.removeChild(mm);
            } else {
                var mm = document.createElement('span');
                mm.style.visibility = 'hidden';
                mm.position = 'absolute';
                mm.innerHTML = 'A';
                document.body.appendChild(mm);
                var mmw = mm.offsetWidth;
                minh = maxh = Theme.LINECONTROL_HEIGHT;
                mm.innerHTML = Array(11).join('A');
                var pps = (mm.offsetWidth - mmw) / 10;
                if (!arg.minw && !edit.style.width) {
                    var fmtid = Elements.attribute(edit, 'data-format') | 0;
                    if (fmtid) {
                        var fmt = Formats.findById(fmtid);
                        if (fmt && fmt.mask)
                            arg.minw = fmt.mask.length;
                    }
                }
                arg.minw = arg.minw || 2;
                minw = (pps * arg.minw + 4 + 2);
                maxw = arg.maxw && (pps * arg.maxw + 4 + 2);
                document.body.removeChild(mm);
            }
            this.flowType = arg.flowType|0;
            this.calculate = function() {
                var ex;
                var sz = Wcl._measure(arg.item, function() {
                    ex = edit.offsetWidth;
                });
                var ls = sz.x - ex;
                return {
                    min: {x: minw + ls, y: minh},
                    max: {x: (maxw || Wcl.Control.UNBOUND_MAX.y) + ls, y: multiline ? (maxh || Wcl.Control.UNBOUND_MAX.y) : Theme.LINECONTROL_HEIGHT},
                    _ls: ls
                };
            };
            var recti = Wcl._mkRecter(arg.item), recte = Wcl._mkRecter(edit);
            this.validate = function(arg) {
                var sy = multiline ? arg.rect.s.y : Theme.LINECONTROL_HEIGHT;
                recte({
                    p: arg.rect.p,
                    s: {
                        x: arg.rect.s.x - arg.calc._ls,
                        y: sy
                    }
                });
                recti(arg.rect);
            };
        },
        initialization: function( root$, components ) {
            root$.find( "input[type=text],input[type=number],textarea" ).each( function() {
                make.call( this, components );
            } );
        }
    };
} );
