define( [
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Formats",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.utils.Strings",
    "inform.agent.web.Expressions",
    "inform.agent.web.NodeInfo",
    "inform.agent.web.Styles",
    "static.jquery.jquery"
    , 'static.wcl.Core'
], function(F, Formats, DM, Strings, Expressions, NodeInfo, Styles, $, Wcl) {
    Styles.sheet().rule( "span.label" ).style( {
        overflow: "hidden"
    } );
    function make( components ) {
        var element = this, element$ = $( element );        
        var expr = element$.attr( "data-expression" );
        var fmt = element$.attr( "data-format" );
        if ( fmt ) {
            fmt = Formats.findById( fmt );
            if ( !fmt )
                element.style.color = "red";
        }
        var type = element$.attr( "data-datatype" ) | 0;
        if ( !type ) {
            var dsid = element$.attr( "data-datasource" );
            var fid = element$.attr( "data-datafield" );
            if ( dsid && fid ) {
                var fp = DM.mkFieldPath( fid.split( ',' ), dsid, components );
                type = fp[fp.length - 1]._descriptor.type;
            }
        }
        element.style.whiteSpace = "pre";
        if ( expr ) {
            var e = Expressions.make( expr, components );
            var generateWaiterTimeout = null;
            function update() {
                function tryup() {
                    var v = e.evaluate( DM.DefaultContext );
                    if ( v === Expressions.WAIT )
                        return false;
                    clearTimeout( generateWaiterTimeout );
                    generateWaiterTimeout = null;
                    if ( (v !== null) && (v !== undefined) && (v !== Expressions.NVAL) ) {
                        if ( type === DM.DataType.BOOLEAN )
                            v = v ? "" : "";
                        else if (type === DM.DataType.METATREE_NODE) {
                            var ni = NodeInfo.fetch(v, NodeInfo.Options.NAME | NodeInfo.Options.FIO);
                            if (!ni)
                                return false;
                            v = fmt ? fmt.format(ni) : ni.name;
                        } else if (fmt)
                            v = fmt.format( v );
                        else if (e.isHtml)
                            F.innerHTML = v;
                    }
                    F.setTextContent( element, v );
                    element$.removeClass( "waiting" );
                    return true;
                }
                if ( !tryup() && !generateWaiterTimeout )
                    generateWaiterTimeout = setTimeout( function() {
                        if ( generateWaiterTimeout )//IE8 bug
                            element$.html( "&nbsp;" ).addClass( "waiting" );
                    }, 250 );
            }
            update();
            e._listen( update );
            (type === DM.DataType.METATREE_NODE) && NodeInfo._listen( update );
        }
    }
    return {
        model: function(arg) {
            if (!arg.exp)
                return arg.text;
            var fmt = arg.fmt && Formats.byIdAndOption(arg.fmt, arg.fmtopt && Strings.base64_to_bytestr(arg.fmtopt));
            var m = Wcl.createRWModel(arg.text);
            this.flowType = arg.flowType|0;
            function update(v) {
                if (v === Expressions.WAIT)
                    return;
                if ((v !== null) && (v !== undefined) && (v !== Expressions.NVAL)) {
                    if (arg.typ === DM.DataType.METATREE_NODE) {
                        var ni = NodeInfo.fetch(v, NodeInfo.Options.NAME | NodeInfo.Options.FIO);
                        if (!ni)
                            return;
                        v = fmt ? fmt.format(ni) : ni.name;
                    } else if (fmt)
                        v = fmt.format(v);
                    else if (arg.typ === DM.DataType.BOOLEAN)
                        v = v ? "" : "";
                }
                m.set(v === null ? arg.text : String(v));
            }
            setTimeout(function(){//delayed init
            var exp = Expressions.wrapAsModel(Expressions.make(arg.exp, arg.cmps));
            exp._listen(update);
            if (arg.typ === DM.DataType.METATREE_NODE)
                NodeInfo._listen(function() {
                    update(exp());
                });
            update(exp());
            });
            return m;
        },
        initialization: function( root$, components ) {
            root$.find( "span.wcl-label" ).each( function() {
                make.call( this, components );
            } );
        }
    };
} );
