define([
    'inform.agent.web.forms.Datamodel',
    'inform.agent.web.Styles',
    'static.wcl.Core',
    'static.wcl.layouts.Flow',
    'static.wcl.controls.Button'
], function(DM, Styles, Core, Flow, Button) {
    return {
        VeerButton: function(parent, container, arg) {
            var flow = Core._mk(parent, container, {
                _: Flow, type: Flow.HORZ, gap: 0
            });
            var datasource = arg.ds;
            var buttons = [];
            function update() {
                var ok = true;
                if (!datasource._scan(function(cursor) {
                    var rcount = cursor._rowsCount();
                    if (rcount === DM.fetchFPathValue.WAIT) {
                        ok = false;
                        return;
                    }
                    while (rcount < buttons.length) {
                        var i = buttons.length - 1;
                        flow.removeItem(buttons[i].item);
                        buttons.splice(i, 1);
                    }
                    Styles.removeClass(container, 'waiting');
                    var ridx = cursor._ridx;
                    var ctx = DM.createCachedContext();
                    for (cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++) {
                        var row = cursor._row();
                        if (!row) {
                            ok = false;
                            break;
                        }
                        ctx.init(datasource, row);
                        var vc = "";
                        if (arg.fcap) {
                            vc = DM.fetchFPathValue(arg.fcap, row);
                            if (vc === DM.fetchFPathValue.WAIT) {
                                ok = false;
                                break;
                            }
                            if (vc === DM.fetchFPathValue.NVAL)
                                vc = "";
                        }
                        var vi = 0;
                        if (arg.fimg) {
                            var vi = DM.fetchFPathValue(arg.fimg, row);
                            if (vi === DM.fetchFPathValue.WAIT) {
                                ok = false;
                                break;
                            }
                            if (vi === DM.fetchFPathValue.NVAL)
                                vi = 0;
                        }
                        var b;
                        if (cursor._ridx >= buttons.length) {
                            var mcap = arg.fcap ? Core.createRWModel(vc) : null;
                            var mimg = arg.fimg ? Core.createRWModel(vi) : null;
                            var mcls = Core.createRWModel("");
                            var mclk = Core.createRWModel((function(ridx) {
                                return function() {
                                    cursor._ridx = ridx;
                                    datasource._touch();
                                };
                            })(cursor._ridx));
                            if (arg.onclick !== undefined)
                                Core._modelUpdater(arg.onclick, (function(ridx) {
                                    return function(f) {
                                        mclk.set(f && function() {
                                            cursor._ridx = ridx;
                                            datasource._touch();
                                            f.apply(null, arguments);
                                        });
                                    };
                                })(cursor._ridx));
                            buttons.push(b = {
                                mcap: mcap,
                                mimg: mimg,
                                mcls: mcls,
                                mclk: mclk,
                                item: flow.appendItem({
                                    _: Button,
                                    text: mcap,
                                    icon: mimg,
                                    onclick: mclk,
                                    className: mcls
                                })
                            });
                        } else {
                            b = buttons[cursor._ridx];
                            b.mcap && b.mcap.set(vc);
                            b.mimg && b.mimg.set(vi);
                        }
                        b.mcls.set(cursor._ridx === ridx ? 'active' : '');
                    }
                }) || !ok)
                    Styles.addClass(container, 'waiting');
            }
            datasource._listen(update);
            update();
            return flow;
        }
    };
});