define( [
    "inform.agent.web.forms.Requests",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.Modal",
    "inform.agent.web.forms.AsyncUI",
    "inform.agent.web.forms.WebForm"
    , "static.jquery.jquery"
    , 'static.wcl.Core'
    , 'static.wcl.layouts.Flow'
    , 'static.wcl.Utils'
], function(Requests, DM, Actioner, Modal, AsyncUI, F, $, Wcl, Flow, Utils) {
    function createMItem(content) {
        content.style.maxWidth = content.style.maxHeight = '';
        var r = Wcl.create(content, {_: Utils.Margin(Flow), type: Flow.VERT});
        var orgvald = r.validate, oldcalc = r.calculate;
        var recter = Wcl._mkRecter(content);
        r.calculate = function() {
            var ow = content.style.width, oh = content.style.height;
            try {
                content.style.width = content.style.height = '';
                var _ = oldcalc.call(r);
                var view_width = Math.min(window.innerWidth || Number.MAX_VALUE, document.body.clientWidth), view_height = Math.min(window.innerHeight || Number.MAX_VALUE, document.body.clientHeight);
                var sz = {
                    x: Math.min(_.max.x, view_width - 10),
                    y: Math.min(_.max.y, view_height - 10 - 36)
                };
                var rr = {
                    _rc: _,
                    min: sz,
                    max: sz
                };
                return rr;
            } finally {
                content.style.width = ow;
                content.style.height = oh;
            }
        };
        r.validate = function(arg) {
            var rect = arg.rect;
            recter(rect);
            var pw = content.parentNode.clientWidth;
            if (pw > rect.s.x) {
                rect = {p: arg.rect.p, s: {x: pw, y: arg.rect.s.y}};
                recter(rect);
            }
            orgvald.call(r, {
                rect: {
                    p: arg.rect.p,
                    s: {
                        x: Math.max(rect.s.x, arg.calc._rc.min.x),
                        y: Math.max(rect.s.y, arg.calc._rc.min.y)
                    }
                },
                calc: arg.calc._rc
            });
        };
        return r;
    }
    var Launcher;
    return Launcher = CLASS( {
        constructor: function( descriptor ) {
            Launcher.inherited.constructor.call( this );
            this._descriptor = descriptor;
            this._dependOn( descriptor.p_bindings );
            this._dependOn( descriptor.paramsyncs );
        },
        _postinit: function( components ) {
            DM.CBind.resolve( this._descriptor.p_bindings, components );
            this._dependOn( this._descriptor.p_bindings );
            DM.CBind.resolve( this._descriptor.paramsyncs, components );
            this._dependOn( this._descriptor.paramsyncs );
            this._touch();
        },
        _action: function( id ) {
            if ( (id !== 1) && (id !== 2) )//only execute and select actions supported
                return null;
            var d = this._descriptor;
            var url = "/node/" + d.node + '?';
            var nc = false;
            if ( d.paramsyncs )
                for ( var i in d.paramsyncs ) {
                    var p = d.paramsyncs[i];
                    if ( p instanceof DM.CBind )
                        return null;//not resolved
                    if ( p instanceof DM.Datasource.Field ) {
                        var ds = p._datasource;
                        var r = ds._row();
                        if ( r === null )//not loaded
                            return null;
                        if ( r === undefined )//no row
                            return null;
                        p = r[p.index];
                    }
                    if ( nc )
                        url += '&';
                    nc = true;
                    url += i + '=' + encodeURIComponent( JSON.stringify( p ) );
                }
            var parameters = {};
            for ( var i in d.p_bindings ) {
                var p = d.p_bindings[i];
                if ( p instanceof DM.CBind )
                    return null;//not resolved
                if ( p instanceof DM.Datasource.Field ) {
                    var ds = p._datasource;
                    var r = ds._row();
                    if ( r === null )//not loaded
                        return null;
                    if ( r === undefined )//no row
                        return null;
                    p = r[p.index];
                }
                parameters[i] = p;
            }
            var launch;
            if ( id === 2 )
                launch = function(args) {
                    var _url = url, _nc = nc;
                    for ( var i in parameters ) {
                        if ( _nc )
                            _url += '&';
                        _nc = true;
                        _url += '@' + i + '=' + encodeURIComponent( JSON.stringify( parameters[i] ) );
                    }
                    _url += (_nc ? '&' : "") + "$as_inline";
                    var form = null, result = null, rq = null, m = Modal.show( {
                        caption: d.caption,
                        content: $( "<div class='waiting' style='padding:1em 2em'>...</div>" )
                    } );
                    var done = m.addButton( "", function() {
                        for ( var i in d.dfmappings ) {
                            var _ = d.dfmappings[i];
                            var fpath = DM.mkFieldPath( _.sf, _.ds, form.components.datamodel._datasources );
                            var row = fpath[0]._datasource._row();
                            if ( !row )
                                throw "no row";
                            var v = null;
                            for ( var i = 0; row && (i < fpath.length); i++ ) {
                                var f = fpath[i];
                                if ( i > 0 ) {
                                    row = f._datasource._row( v );
                                    if ( row === null )
                                        throw "no next row";
                                    if ( row === undefined ) {
                                        v = undefined;
                                        break;
                                    }
                                }
                                v = row[f.index];
                            }
                            var ds = _.target._datasource;
                            var r = ds._row();
                            if ( !r )
                                throw "no row";
                            r = ds._modify( r );
                            r[_.target.index] = v;
                            ds._touch();
                        }
                        m.close();
                        result && result.resolve();
                    } );
                    m.onclose = function() {
                        function cancel() {
                            rq.abort();
                            m.close();
                            result && result.reject();
                        }
                        if ( args.savepoint.modified() ) {
                            return AsyncUI.confirm( " ?" ).then( cancel );
                        } else
                            cancel();
                    };
                    function updateButtons() {
                        if ( !rq || !rq._ready )
                            done.hide();
                        else
                            done.show();
                    }
                    updateButtons();
                    rq = Requests.execute( {
                        caption: " ",
                        url: _url
                    } );
                    return rq.done( function( response ) {
                        var p$ = m.content.html( response );
                        var f = eval( "form" + d.node );
                        return f( {
                            root: p$,
                            dsmappings: d.dsmappings
                            , menu: m.menu
                            , mitem: createMItem(m.content[0])
                        } ).done( function( f ) {
                            rq._ready = true;
                            updateButtons();
                            result = Asyncs.create();
                            form = f;
                            return result.promise();
                        } );
                    } );
                };
            else
                launch = function(args) {
                var _url = url, _nc = nc, vprms = [];
                for ( var i in parameters ) {
                    if ( _nc )
                        _url += '&';
                    _nc = true;
                    _url += '@' + i + '=' + encodeURIComponent( JSON.stringify( parameters[i] ) );
                    if ( !d.parameters[i].hidden )
                        vprms.push( i | 0 );
                }
                if ( vprms.length ) {
                    if ( _nc )
                        _url += '&';
                    _url += "$vis_params=" + encodeURIComponent( vprms );
                    _nc = true;
                }
                if (d.type === "report") {
                    if (d.output !== undefined) {
                        if (_nc)
                            _url += '&';
                        _url += "@output=" + d.output;
                    }
                    window.open(asmo.root + _url);
                    return;
                }
                if (d.type === "query") {
                    window.open(asmo.root + _url);
                    return;
                }
                switch ( d.mode ) {
                    case 0://replace
                        window.location = asmo.root + _url;
                        break;
                    case 1://newdoc
                            window.open(asmo.root + _url);
                        break;
                    case 2://modal
                        _url += (_nc ? '&' : "") + "$as_inline";
                        var result = null, fsp = null;
                        var rq, m = Modal.show( {
                            caption: d.caption,
                            content: $( "<div class='waiting' style='padding:1em 2em'>...</div>" )
                        } );
                        m.onclose = function() {
                            function cancel() {
                                rq.abort();
                                m.close();
                                result && result.reject();
                            }
                            if ( args.savepoint.modified() || (fsp && fsp.modified()) )
                                return AsyncUI.confirm( " ?" ).then( cancel );
                            else
                                cancel();
                        };
                        var done = m.addButton( "OK", function() {
                            m.close();
                            result && result.resolve();
                        } );
                        function updateButtons() {
                            if ( !rq || !rq._ready ) {
                                done.hide();
                            } else if ( args.savepoint.modified() || (fsp && fsp.modified()) )
                                done.show().text( "" );
                            else
                                done.show().text( "OK" );
                        }
                        d.dmodel._listen( updateButtons );
                        updateButtons();
                        rq = Requests.execute( {
                            caption: " ",
                            url: _url
                        } );
                        return rq.done( function( response ) {
                            m.content.html( response );
                            var f = eval( "form" + d.node );
                            return f( {
                                root: m.content,
                                dsmappings: d.dsmappings
                                , menu: m.menu
                                , mitem: createMItem(m.content[0])
                            } ).done( function( form ) {
                                rq._ready = true;
                                updateButtons();
                                result = Asyncs.create();
                                var dm = form.components.datamodel;
                                fsp = dm._savepoint();
                                updateButtons();
                                dm._listen( updateButtons );
                                return result.promise();
                            } );
                        } );
                }
            };
            if ( d.dontAskParams )
                return launch;
            for ( var i in d.parameters )
                if ( !d.parameters[i].hidden )
                    return function() {
                        var args = arguments;
                        return DM.showParametersDialog( {
                            values: parameters,
                            fields: d.parameters
                        } ).done( function(values) {
                            for ( var i in values )
                                parameters[i] = values[i];
                            return launch.apply( null, args );
                        } );
                    };
            return launch;
        }
    }, Actioner );
}
);
