define( [
    "inform.agent.web.forms.Requests",
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.Modal",
    "inform.agent.web.Tasks"
    , "static.jquery.jquery"
], function( Requests, Actioner, DM, Modal, Tasks, $ ) {
    var ScriptLauncher;
    return ScriptLauncher = CLASS( {
        constructor: function( descriptor ) {
            ScriptLauncher.inherited.constructor.call( this );
            this._descriptor = descriptor;
            this._rq = null;
            this._dependOn( descriptor.p_bindings );
        },
        _postinit: function( components ) {
            DM.CBind.resolve( this._descriptor.p_bindings, components );
            this._dependOn( this._descriptor.p_bindings );
            this._touch();
        },
        _action: function( id ) {
            if ( id !== 1 )//only execute action supported
                return null;
            if ( this._rq !== null )
                return null;//wait complete
            var d = this._descriptor;
            var parameters = {}, pinrows = {};
            for ( var i in d.p_bindings ) {
                var p = d.p_bindings[i];
                if ( p instanceof DM.CBind )
                    return null;//not resolved
                if ( p instanceof DM.Datasource.Field ) {
                    var ds = p._datasource;
                    var r = ds._row();
                    if ( r === null )//not loaded
                        return null;
                    if ( r === undefined )//no row
                        return null;
                    if ( d.parameters[i].retval )
                        pinrows[i] = r;
                    p = r[p.index];
                }
                parameters[i] = p;
            }
            var self = this;
            var launch = function() {
                var url = "/rq/executeScript?node=" + d.node+"&owner="+d.ownerId+"&uid:"+d.id;
                var params = [];
                for ( var i in parameters )
                    params.push( [i | 0, parameters[i]] );
                if ( params.length )
                    url += "&parameters=" + encodeURIComponent( JSON.stringify( params ) );
                var asyncId = (Math.random() * 1E10).toString( 36 );
                var rq, tasks$ = $( "<div></div>" ), tasks = Tasks.create( tasks$ ), m = null;
                function show() {
                    if ( m )
                        return;
                    function updateProgress() {
                        $.ajax(asmo.root + "/async/" + asyncId).then(function done(r) {
                            r = JSON.parse( r );
                            r.changes && tasks.process( r.changes );
                            if (r.error) {
                                tasks.fail(r.error);
                                return;
                            }
                            if ( r.state === "DONE" ) {
                                if ( !tasks.failed ) {
                                    if ( !d.syncok )
                                        m.close();
                                    else
                                        tasks.done();
                                }
                                return;
                            }
                            if ( !tasks.failed )
                                setTimeout( updateProgress, 500 );
                        }, log.error );
                    }
                    m = Modal.show( {
                        caption: "  ",
                        content: tasks$
                    } );
                    m.onclose = function() {
                        if ( tasks.ready )
                            m && m.close();
                        else
                            rq.abort();
                    };
                    updateProgress();
                }
                var tmoProgress;
                if ( !d.silent )
                    tmoProgress = setTimeout( function() {
                        if ( tmoProgress )
                            show();
                    }, 250 );
                self._rq = rq = Requests.execute( {
                    caption: "  ",
                    url: url + "&async=" + asyncId
                } );
                function always() {
                    clearTimeout( tmoProgress );
                    tmoProgress = null;
                    self._rq = null;
                    self._touch();
                }
                var result = rq.done( function done( response ) {
                    if ( d.syncok )
                        show();
                    var result = JSON.parse(response).parameters;
                    for ( var i in result ) {
                        var p = d.p_bindings && d.p_bindings[i], v = result[i];
                        if ( p instanceof DM.Datasource.Field ) {
                            var ds = p._datasource, r = ds._modify( pinrows[i] );
                            if ( (v instanceof Object) && !(v instanceof Array) )
                                v = DM.ALLVAL;
                            r[p.index] = v;
                            ds._touch();
                        }
                    }
                    always();
                } );
                result.fail( function( e ) {
                    show();
                    tasks.fail( e );
                    always();
                } );
                return result;
            };
            for ( var i in d.parameters )
                if ( !d.parameters[i].hidden )
                    return function() {
                        return DM.showParametersDialog( {
                            values: parameters,
                            fields: d.parameters
                        } ).done( function(values) {
                            for ( var i in parameters )
                                parameters[i] = values[i];
                            return launch();
                        } );
                    };
            return launch;
        }
    }, Actioner );
} );